/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttPacket;
import swim.util.Murmur3;

public final class MqttPubAckPacket
extends MqttPacket<Object>
implements Debug {
    final int packetFlags;
    final int packetId;
    private static int hashSeed;

    MqttPubAckPacket(int packetFlags, int packetId) {
        this.packetFlags = packetFlags;
        this.packetId = packetId;
    }

    @Override
    public int packetType() {
        return 4;
    }

    @Override
    public int packetFlags() {
        return this.packetFlags;
    }

    public MqttPubAckPacket packetFlags(int packetFlags) {
        return new MqttPubAckPacket(packetFlags, this.packetId);
    }

    public int packetId() {
        return this.packetId;
    }

    public MqttPubAckPacket packetId(int packetId) {
        return new MqttPubAckPacket(this.packetFlags, packetId);
    }

    @Override
    int variableHeaderSize(MqttEncoder mqtt) {
        return 2;
    }

    @Override
    public Encoder<?, MqttPubAckPacket> mqttEncoder(MqttEncoder mqtt) {
        return mqtt.pubAckPacketEncoder(this);
    }

    @Override
    public Encoder<?, MqttPubAckPacket> encodeMqtt(OutputBuffer<?> output, MqttEncoder mqtt) {
        return mqtt.encodePubAckPacket(output, this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttPubAckPacket) {
            MqttPubAckPacket that = (MqttPubAckPacket)other;
            return this.packetFlags == that.packetFlags && this.packetId == that.packetId;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttPubAckPacket.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.packetFlags), (int)this.packetId));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("MqttPubAckPacket").write(46).write("create").write(40).debug((Object)this.packetId).write(41);
        if (this.packetFlags != 0) {
            output = output.write(46).write("packetFlags").write(40).debug((Object)this.packetFlags).write(41);
        }
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static MqttPubAckPacket create(int packetFlags, int packetId) {
        return new MqttPubAckPacket(packetFlags, packetId);
    }

    public static MqttPubAckPacket create(int packetId) {
        return new MqttPubAckPacket(0, packetId);
    }
}

