/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.mqtt.MqttDecoder;
import swim.mqtt.MqttException;
import swim.mqtt.MqttPubAckPacket;

final class MqttPubAckPacketDecoder
extends Decoder<MqttPubAckPacket> {
    final MqttDecoder mqtt;
    final int packetFlags;
    final int packetId;
    final int remaining;
    final int step;

    MqttPubAckPacketDecoder(MqttDecoder mqtt, int packetFlags, int packetId, int remaining, int step) {
        this.mqtt = mqtt;
        this.packetFlags = packetFlags;
        this.packetId = packetId;
        this.remaining = remaining;
        this.step = step;
    }

    MqttPubAckPacketDecoder(MqttDecoder mqtt) {
        this(mqtt, 0, 0, 0, 1);
    }

    public Decoder<MqttPubAckPacket> feed(InputBuffer input) {
        return MqttPubAckPacketDecoder.decode(input, this.mqtt, this.packetFlags, this.packetId, this.remaining, this.step);
    }

    static Decoder<MqttPubAckPacket> decode(InputBuffer input, MqttDecoder mqtt, int packetFlags, int packetId, int remaining, int step) {
        if (step == 1 && input.isCont()) {
            packetFlags = input.head() & 0xF;
            input = input.step();
            step = 2;
        }
        while (step >= 2 && step <= 5 && input.isCont()) {
            int b = input.head();
            input = input.step();
            remaining |= (b & 0x7F) << 7 * (step - 2);
            if ((b & 0x80) == 0) {
                step = 6;
                break;
            }
            if (step < 5) {
                ++step;
                continue;
            }
            return Decoder.error((Throwable)new MqttException("packet length too long"));
        }
        if (step == 6 && remaining > 0 && input.isCont()) {
            packetId = input.head() << 8;
            input = input.step();
            --remaining;
            step = 7;
        }
        if (step == 7 && remaining > 0 && input.isCont()) {
            packetId |= input.head();
            input = input.step();
            --remaining;
            step = 8;
        }
        if (step == 8 && remaining == 0) {
            return Decoder.done((Object)mqtt.pubAckPacket(packetFlags, packetId));
        }
        if (remaining < 0) {
            return Decoder.error((Throwable)new MqttException("packet length too short"));
        }
        if (input.isDone()) {
            return Decoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return Decoder.error((Throwable)input.trap());
        }
        return new MqttPubAckPacketDecoder(mqtt, packetFlags, packetId, remaining, step);
    }

    static Decoder<MqttPubAckPacket> decode(InputBuffer input, MqttDecoder mqtt) {
        return MqttPubAckPacketDecoder.decode(input, mqtt, 0, 0, 0, 1);
    }
}

