/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttPacket;
import swim.util.Murmur3;

public final class MqttPubCompPacket
extends MqttPacket<Object>
implements Debug {
    final int packetFlags;
    final int packetId;
    private static int hashSeed;

    MqttPubCompPacket(int packetFlags, int packetId) {
        this.packetFlags = packetFlags;
        this.packetId = packetId;
    }

    @Override
    public int packetType() {
        return 7;
    }

    @Override
    public int packetFlags() {
        return this.packetFlags;
    }

    public MqttPubCompPacket packetFlags(int packetFlags) {
        return new MqttPubCompPacket(packetFlags, this.packetId);
    }

    public int packetId() {
        return this.packetId;
    }

    public MqttPubCompPacket packetId(int packetId) {
        return new MqttPubCompPacket(this.packetFlags, packetId);
    }

    @Override
    int variableHeaderSize(MqttEncoder mqtt) {
        return 2;
    }

    @Override
    public Encoder<?, MqttPubCompPacket> mqttEncoder(MqttEncoder mqtt) {
        return mqtt.pubCompPacketEncoder(this);
    }

    @Override
    public Encoder<?, MqttPubCompPacket> encodeMqtt(OutputBuffer<?> output, MqttEncoder mqtt) {
        return mqtt.encodePubCompPacket(output, this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttPubCompPacket) {
            MqttPubCompPacket that = (MqttPubCompPacket)other;
            return this.packetFlags == that.packetFlags && this.packetId == that.packetId;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttPubCompPacket.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.packetFlags), (int)this.packetId));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("MqttPubCompPacket").write(46).write("create").write(40).debug((Object)this.packetId).write(41);
        if (this.packetFlags != 0) {
            output = output.write(46).write("packetFlags").write(40).debug((Object)this.packetFlags).write(41);
        }
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static MqttPubCompPacket create(int packetFlags, int packetId) {
        return new MqttPubCompPacket(packetFlags, packetId);
    }

    public static MqttPubCompPacket create(int packetId) {
        return new MqttPubCompPacket(0, packetId);
    }
}

