/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.mqtt.MqttDecoder;
import swim.mqtt.MqttException;
import swim.mqtt.MqttPublishPacket;

final class MqttPublishPacketDecoder<T>
extends Decoder<MqttPublishPacket<T>> {
    final MqttDecoder mqtt;
    final Decoder<T> payloadDecoder;
    final int packetFlags;
    final Decoder<String> topicNameDecoder;
    final int packetId;
    final int remaining;
    final int step;

    MqttPublishPacketDecoder(MqttDecoder mqtt, Decoder<T> payloadDecoder, int packetFlags, Decoder<String> topicNameDecoder, int packetId, int remaining, int step) {
        this.mqtt = mqtt;
        this.payloadDecoder = payloadDecoder;
        this.packetFlags = packetFlags;
        this.topicNameDecoder = topicNameDecoder;
        this.packetId = packetId;
        this.remaining = remaining;
        this.step = step;
    }

    MqttPublishPacketDecoder(MqttDecoder mqtt, Decoder<T> payloadDecoder) {
        this(mqtt, payloadDecoder, 0, null, 0, 0, 1);
    }

    public Decoder<MqttPublishPacket<T>> feed(InputBuffer input) {
        return MqttPublishPacketDecoder.decode(input, this.mqtt, this.payloadDecoder, this.packetFlags, this.topicNameDecoder, this.packetId, this.remaining, this.step);
    }

    static <T> Decoder<MqttPublishPacket<T>> decode(InputBuffer input, MqttDecoder mqtt, Decoder<T> payloadDecoder, int packetFlags, Decoder<String> topicNameDecoder, int packetId, int remaining, int step) {
        boolean inputPart;
        int inputRemaining;
        int inputLimit;
        int inputStart;
        if (step == 1 && input.isCont()) {
            packetFlags = input.head() & 0xF;
            input = input.step();
            step = 2;
        }
        while (step >= 2 && step <= 5 && input.isCont()) {
            int b = input.head();
            input = input.step();
            remaining |= (b & 0x7F) << 7 * (step - 2);
            if ((b & 0x80) == 0) {
                step = 6;
                break;
            }
            if (step < 5) {
                ++step;
                continue;
            }
            return Decoder.error((Throwable)new MqttException("packet length too long"));
        }
        if (step == 6) {
            inputStart = input.index();
            inputLimit = input.limit();
            inputRemaining = inputLimit - inputStart;
            if (remaining < inputRemaining) {
                input = input.limit(inputStart + remaining);
            }
            inputPart = input.isPart();
            input = input.isPart(remaining > inputRemaining);
            topicNameDecoder = topicNameDecoder == null ? mqtt.decodeString(input) : topicNameDecoder.feed(input);
            input = input.limit(inputLimit).isPart(inputPart);
            remaining -= input.index() - inputStart;
            if (topicNameDecoder.isDone()) {
                step = (packetFlags & 6) >>> 1 != 0 ? 7 : 9;
            } else if (topicNameDecoder.isError()) {
                return topicNameDecoder.asError();
            }
        }
        if (step == 7 && remaining > 0 && input.isCont()) {
            packetId = input.head() << 8;
            input = input.step();
            --remaining;
            step = 8;
        }
        if (step == 8 && remaining > 0 && input.isCont()) {
            packetId |= input.head();
            input = input.step();
            --remaining;
            step = 9;
        }
        if (step == 9) {
            inputStart = input.index();
            inputLimit = input.limit();
            inputRemaining = inputLimit - inputStart;
            if (remaining < inputRemaining) {
                input = input.limit(inputStart + remaining);
            }
            inputPart = input.isPart();
            input = input.isPart(remaining > inputRemaining);
            payloadDecoder = payloadDecoder.feed(input);
            input = input.limit(inputLimit).isPart(inputPart);
            remaining -= input.index() - inputStart;
            if (payloadDecoder.isDone()) {
                step = 10;
            } else if (payloadDecoder.isError()) {
                return payloadDecoder.asError();
            }
        }
        if (step == 10 && remaining == 0) {
            return Decoder.done(mqtt.publishPacket(packetFlags, (String)topicNameDecoder.bind(), packetId, payloadDecoder.bind()));
        }
        if (remaining < 0) {
            return Decoder.error((Throwable)new MqttException("packet length too short"));
        }
        if (input.isDone()) {
            return Decoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return Decoder.error((Throwable)input.trap());
        }
        return new MqttPublishPacketDecoder<T>(mqtt, payloadDecoder, packetFlags, (Decoder<String>)topicNameDecoder, packetId, remaining, step);
    }

    static <T> Decoder<MqttPublishPacket<T>> decode(InputBuffer input, MqttDecoder mqtt, Decoder<T> payloadDecoder) {
        return MqttPublishPacketDecoder.decode(input, mqtt, payloadDecoder, 0, null, 0, 0, 1);
    }
}

