/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.collections.FingerTrieSeq;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttPacket;
import swim.mqtt.MqttSubStatus;
import swim.util.Murmur3;

public final class MqttSubAckPacket
extends MqttPacket<Object>
implements Debug {
    final int packetFlags;
    final int packetId;
    final FingerTrieSeq<MqttSubStatus> subscriptions;
    private static int hashSeed;

    MqttSubAckPacket(int packetFlags, int packetId, FingerTrieSeq<MqttSubStatus> subscriptions) {
        this.packetFlags = packetFlags;
        this.packetId = packetId;
        this.subscriptions = subscriptions;
    }

    @Override
    public int packetType() {
        return 9;
    }

    @Override
    public int packetFlags() {
        return this.packetFlags;
    }

    public MqttSubAckPacket packetFlags(int packetFlags) {
        return new MqttSubAckPacket(packetFlags, this.packetId, this.subscriptions);
    }

    public int packetId() {
        return this.packetId;
    }

    public MqttSubAckPacket packetId(int packetId) {
        return new MqttSubAckPacket(this.packetFlags, packetId, this.subscriptions);
    }

    public FingerTrieSeq<MqttSubStatus> subscriptions() {
        return this.subscriptions;
    }

    public MqttSubAckPacket subscriptions(FingerTrieSeq<MqttSubStatus> subscriptions) {
        return new MqttSubAckPacket(this.packetFlags, this.packetId, subscriptions);
    }

    public MqttSubAckPacket subscriptions(MqttSubStatus ... subscriptions) {
        return new MqttSubAckPacket(this.packetFlags, this.packetId, (FingerTrieSeq<MqttSubStatus>)FingerTrieSeq.of((Object[])subscriptions));
    }

    public MqttSubAckPacket subscription(MqttSubStatus subscription) {
        return new MqttSubAckPacket(this.packetFlags, this.packetId, (FingerTrieSeq<MqttSubStatus>)this.subscriptions.appended((Object)subscription));
    }

    @Override
    int variableHeaderSize(MqttEncoder mqtt) {
        return 2 + this.subscriptions.size();
    }

    @Override
    public Encoder<?, MqttSubAckPacket> mqttEncoder(MqttEncoder mqtt) {
        return mqtt.subAckPacketEncoder(this);
    }

    @Override
    public Encoder<?, MqttSubAckPacket> encodeMqtt(OutputBuffer<?> output, MqttEncoder mqtt) {
        return mqtt.encodeSubAckPacket(output, this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttSubAckPacket) {
            MqttSubAckPacket that = (MqttSubAckPacket)other;
            return this.packetFlags == that.packetFlags && this.packetId == that.packetId && this.subscriptions.equals(that.subscriptions);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttSubAckPacket.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.packetFlags), (int)this.packetId), (int)this.subscriptions.hashCode()));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("MqttSubAckPacket").write(46).write("create").write(40).debug((Object)this.packetId).write(41);
        if (this.packetFlags != 0) {
            output = output.write(46).write("packetFlags").write(40).debug((Object)this.packetFlags).write(41);
        }
        int n = this.subscriptions.size();
        for (int i = 0; i < n; ++i) {
            output = output.write(46).write("subscription").write(40).debug(this.subscriptions.get(i)).write(41);
        }
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static MqttSubAckPacket create(int packetFlags, int packetId, FingerTrieSeq<MqttSubStatus> subscriptions) {
        return new MqttSubAckPacket(packetFlags, packetId, subscriptions);
    }

    public static MqttSubAckPacket create(int packetId, FingerTrieSeq<MqttSubStatus> subscriptions) {
        return new MqttSubAckPacket(0, packetId, subscriptions);
    }

    public static MqttSubAckPacket create(int packetId, MqttSubStatus ... subscriptions) {
        return new MqttSubAckPacket(0, packetId, (FingerTrieSeq<MqttSubStatus>)FingerTrieSeq.of((Object[])subscriptions));
    }

    public static MqttSubAckPacket create(int packetId) {
        return new MqttSubAckPacket(0, packetId, (FingerTrieSeq<MqttSubStatus>)FingerTrieSeq.empty());
    }
}

