/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.collections.FingerTrieSeq;
import swim.mqtt.MqttDecoder;
import swim.mqtt.MqttException;
import swim.mqtt.MqttSubAckPacket;
import swim.mqtt.MqttSubStatus;

final class MqttSubAckPacketDecoder
extends Decoder<MqttSubAckPacket> {
    final MqttDecoder mqtt;
    final int packetFlags;
    final int packetId;
    final FingerTrieSeq<MqttSubStatus> subscriptions;
    final int remaining;
    final int step;

    MqttSubAckPacketDecoder(MqttDecoder mqtt, int packetFlags, int packetId, FingerTrieSeq<MqttSubStatus> subscriptions, int remaining, int step) {
        this.mqtt = mqtt;
        this.packetFlags = packetFlags;
        this.packetId = packetId;
        this.subscriptions = subscriptions;
        this.remaining = remaining;
        this.step = step;
    }

    MqttSubAckPacketDecoder(MqttDecoder mqtt) {
        this(mqtt, 0, 0, (FingerTrieSeq<MqttSubStatus>)FingerTrieSeq.empty(), 0, 1);
    }

    public Decoder<MqttSubAckPacket> feed(InputBuffer input) {
        return MqttSubAckPacketDecoder.decode(input, this.mqtt, this.packetFlags, this.packetId, this.subscriptions, this.remaining, this.step);
    }

    static Decoder<MqttSubAckPacket> decode(InputBuffer input, MqttDecoder mqtt, int packetFlags, int packetId, FingerTrieSeq<MqttSubStatus> subscriptions, int remaining, int step) {
        if (step == 1 && input.isCont()) {
            packetFlags = input.head() & 0xF;
            input = input.step();
            step = 2;
        }
        while (step >= 2 && step <= 5 && input.isCont()) {
            int b = input.head();
            input = input.step();
            remaining |= (b & 0x7F) << 7 * (step - 2);
            if ((b & 0x80) == 0) {
                step = 6;
                break;
            }
            if (step < 5) {
                ++step;
                continue;
            }
            return Decoder.error((Throwable)new MqttException("packet length too long"));
        }
        if (step == 6 && remaining > 0 && input.isCont()) {
            packetId = input.head() << 8;
            input = input.step();
            --remaining;
            step = 7;
        }
        if (step == 7 && remaining > 0 && input.isCont()) {
            packetId |= input.head();
            input = input.step();
            step = --remaining > 0 ? 8 : 9;
        }
        while (step == 8 && remaining > 0 && input.isCont()) {
            int code = input.head();
            input = input.step();
            subscriptions = subscriptions.appended((Object)mqtt.subStatus(code));
            if (--remaining != 0) continue;
            step = 9;
            break;
        }
        if (step == 9 && remaining == 0) {
            return Decoder.done((Object)mqtt.subAckPacket(packetFlags, packetId, subscriptions));
        }
        if (remaining < 0) {
            return Decoder.error((Throwable)new MqttException("packet length too short"));
        }
        if (input.isDone()) {
            return Decoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return Decoder.error((Throwable)input.trap());
        }
        return new MqttSubAckPacketDecoder(mqtt, packetFlags, packetId, (FingerTrieSeq<MqttSubStatus>)subscriptions, remaining, step);
    }

    static Decoder<MqttSubAckPacket> decode(InputBuffer input, MqttDecoder mqtt) {
        return MqttSubAckPacketDecoder.decode(input, mqtt, 0, 0, (FingerTrieSeq<MqttSubStatus>)FingerTrieSeq.empty(), 0, 1);
    }
}

