/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.mqtt.MqttQoS;
import swim.util.Murmur3;

public final class MqttSubStatus
implements Debug {
    public final int code;
    private static int hashSeed;
    static final int MAX_QOS_MASK = 3;
    public static final MqttSubStatus AT_MOST_ONCE;
    public static final MqttSubStatus AT_LEAST_ONCE;
    public static final MqttSubStatus EXACTLY_ONCE;
    public static final MqttSubStatus FAILURE;

    MqttSubStatus(int code) {
        this.code = code;
    }

    public boolean isSuccess() {
        return this.code != 128;
    }

    public boolean isAtMostOnce() {
        return this.code == 0;
    }

    public boolean isAtLeastOnce() {
        return this.code == 1;
    }

    public boolean isExactlyOnce() {
        return this.code == 2;
    }

    public boolean isFailure() {
        return this.code == 128;
    }

    public MqttQoS maxQoS() {
        return MqttQoS.from(this.code & 3);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttSubStatus) {
            MqttSubStatus that = (MqttSubStatus)other;
            return this.code == that.code;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttSubStatus.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.code));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("MqttSubStatus").write(46);
        switch (this.code) {
            case 0: {
                output = output.write("AT_MOST_ONCE");
                break;
            }
            case 1: {
                output = output.write("AT_LEAST_ONCE");
                break;
            }
            case 2: {
                output = output.write("EXACTLY_ONCE");
                break;
            }
            case 128: {
                output = output.write("FAILURE");
                break;
            }
            default: {
                output = output.write("create").write(40).debug((Object)this.code).write(41);
            }
        }
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static MqttSubStatus create(int code) {
        switch (code) {
            case 0: {
                return AT_MOST_ONCE;
            }
            case 1: {
                return AT_LEAST_ONCE;
            }
            case 2: {
                return EXACTLY_ONCE;
            }
            case 3: {
                return FAILURE;
            }
        }
        return new MqttSubStatus(code);
    }

    static {
        AT_MOST_ONCE = new MqttSubStatus(0);
        AT_LEAST_ONCE = new MqttSubStatus(1);
        EXACTLY_ONCE = new MqttSubStatus(2);
        FAILURE = new MqttSubStatus(128);
    }
}

