/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttException;
import swim.mqtt.MqttSubscribePacket;
import swim.mqtt.MqttSubscription;

final class MqttSubscribePacketEncoder
extends Encoder<Object, MqttSubscribePacket> {
    final MqttEncoder mqtt;
    final MqttSubscribePacket packet;
    final Encoder<?, ?> part;
    final int length;
    final int remaining;
    final int step;

    MqttSubscribePacketEncoder(MqttEncoder mqtt, MqttSubscribePacket packet, Encoder<?, ?> part, int length, int remaining, int step) {
        this.mqtt = mqtt;
        this.packet = packet;
        this.part = part;
        this.length = length;
        this.remaining = remaining;
        this.step = step;
    }

    MqttSubscribePacketEncoder(MqttEncoder mqtt, MqttSubscribePacket packet) {
        this(mqtt, packet, null, 0, 0, 1);
    }

    public Encoder<Object, MqttSubscribePacket> pull(OutputBuffer<?> output) {
        return MqttSubscribePacketEncoder.encode(output, this.mqtt, this.packet, this.part, this.length, this.remaining, this.step);
    }

    static Encoder<Object, MqttSubscribePacket> encode(OutputBuffer<?> output, MqttEncoder mqtt, MqttSubscribePacket packet, Encoder<?, ?> part, int length, int remaining, int step) {
        if (step == 1 && output.isCont()) {
            remaining = length = packet.variableHeaderSize(mqtt);
            output = output.write(packet.packetType() << 4 | packet.packetFlags & 0xF);
            step = 2;
        }
        while (step >= 2 && step <= 5 && output.isCont()) {
            int b = length & 0x7F;
            if ((length >>>= 7) > 0) {
                b |= 0x80;
            }
            output = output.write(b);
            if (length == 0) {
                step = 6;
                break;
            }
            if (step < 5) {
                ++step;
                continue;
            }
            return Encoder.error((Throwable)new MqttException("packet length too long: " + remaining));
        }
        if (step == 6 && remaining > 0 && output.isCont()) {
            output = output.write(packet.packetId >>> 8);
            --remaining;
            step = 7;
        }
        if (step == 7 && remaining > 0 && output.isCont()) {
            output = output.write(packet.packetId);
            --remaining;
            step = 8;
        }
        while (step >= 8 && step < 8 + packet.subscriptions.size() && output.isCont()) {
            int outputStart = output.index();
            int outputLimit = output.limit();
            int outputRemaining = outputLimit - outputStart;
            if (remaining < outputRemaining) {
                output = output.limit(outputStart + remaining);
            }
            boolean outputPart = output.isPart();
            output = output.isPart(remaining > outputRemaining);
            part = part == null ? ((MqttSubscription)packet.subscriptions.get(step - 8)).encodeMqtt(output, mqtt) : part.pull(output);
            output = output.limit(outputLimit).isPart(outputPart);
            remaining -= output.index() - outputStart;
            if (part.isDone()) {
                part = null;
                ++step;
                continue;
            }
            if (!part.isError()) continue;
            return part.asError();
        }
        if (step == 8 + packet.subscriptions.size() && remaining == 0) {
            return Encoder.done((Object)packet);
        }
        if (remaining < 0) {
            return Encoder.error((Throwable)new MqttException("packet length too short"));
        }
        if (output.isDone()) {
            return Encoder.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return Encoder.error((Throwable)output.trap());
        }
        return new MqttSubscribePacketEncoder(mqtt, packet, part, length, remaining, step);
    }

    static Encoder<Object, MqttSubscribePacket> encode(OutputBuffer<?> output, MqttEncoder mqtt, MqttSubscribePacket packet) {
        return MqttSubscribePacketEncoder.encode(output, mqtt, packet, null, 0, 0, 1);
    }
}

