/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttSubscription;

final class MqttSubscriptionEncoder
extends Encoder<MqttSubscription, MqttSubscription> {
    final MqttEncoder mqtt;
    final MqttSubscription subscription;
    final Encoder<?, ?> part;
    final int step;

    MqttSubscriptionEncoder(MqttEncoder mqtt, MqttSubscription subscription, Encoder<?, ?> part, int step) {
        this.mqtt = mqtt;
        this.subscription = subscription;
        this.part = part;
        this.step = step;
    }

    MqttSubscriptionEncoder(MqttEncoder mqtt, MqttSubscription subscription) {
        this(mqtt, subscription, null, 1);
    }

    public Encoder<MqttSubscription, MqttSubscription> feed(MqttSubscription subscription) {
        return new MqttSubscriptionEncoder(this.mqtt, subscription, null, 1);
    }

    public Encoder<MqttSubscription, MqttSubscription> pull(OutputBuffer<?> output) {
        return MqttSubscriptionEncoder.encode(output, this.mqtt, this.subscription, this.part, this.step);
    }

    static int sizeOf(MqttEncoder mqtt, MqttSubscription subscription) {
        return mqtt.sizeOfString(subscription.topicName) + 1;
    }

    static Encoder<MqttSubscription, MqttSubscription> encode(OutputBuffer<?> output, MqttEncoder mqtt, MqttSubscription subscription, Encoder<?, ?> part, int step) {
        if (step == 1) {
            if ((part = part == null ? mqtt.encodeString(output, subscription.topicName) : part.pull(output)).isDone()) {
                part = null;
                step = 2;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 2 && output.isCont()) {
            output = output.write(subscription.flags);
            return Encoder.done((Object)subscription);
        }
        if (output.isDone()) {
            return Encoder.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return Encoder.error((Throwable)output.trap());
        }
        return new MqttSubscriptionEncoder(mqtt, subscription, part, step);
    }

    static Encoder<MqttSubscription, MqttSubscription> encode(OutputBuffer<?> output, MqttEncoder mqtt, MqttSubscription subscription) {
        return MqttSubscriptionEncoder.encode(output, mqtt, subscription, null, 1);
    }
}

