/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttPacket;
import swim.util.Murmur3;

public final class MqttUnsubAckPacket
extends MqttPacket<Object>
implements Debug {
    final int packetFlags;
    final int packetId;
    private static int hashSeed;

    MqttUnsubAckPacket(int packetFlags, int packetId) {
        this.packetFlags = packetFlags;
        this.packetId = packetId;
    }

    @Override
    public int packetType() {
        return 11;
    }

    @Override
    public int packetFlags() {
        return this.packetFlags;
    }

    public MqttUnsubAckPacket packetFlags(int packetFlags) {
        return new MqttUnsubAckPacket(packetFlags, this.packetId);
    }

    public int packetId() {
        return this.packetId;
    }

    public MqttUnsubAckPacket packetId(int packetId) {
        return new MqttUnsubAckPacket(this.packetFlags, packetId);
    }

    @Override
    int variableHeaderSize(MqttEncoder mqtt) {
        return 2;
    }

    @Override
    public Encoder<?, MqttUnsubAckPacket> mqttEncoder(MqttEncoder mqtt) {
        return mqtt.unsubAckPacketEncoder(this);
    }

    @Override
    public Encoder<?, MqttUnsubAckPacket> encodeMqtt(OutputBuffer<?> output, MqttEncoder mqtt) {
        return mqtt.encodeUnsubAckPacket(output, this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttUnsubAckPacket) {
            MqttUnsubAckPacket that = (MqttUnsubAckPacket)other;
            return this.packetFlags == that.packetFlags && this.packetId == that.packetId;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttUnsubAckPacket.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.packetFlags), (int)this.packetId));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("MqttUnsubAckPacket").write(46).write("create").write(40).debug((Object)this.packetId).write(41);
        if (this.packetFlags != 0) {
            output = output.write(46).write("packetFlags").write(40).debug((Object)this.packetFlags).write(41);
        }
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static MqttUnsubAckPacket create(int packetFlags, int packetId) {
        return new MqttUnsubAckPacket(packetFlags, packetId);
    }

    public static MqttUnsubAckPacket create(int packetId) {
        return new MqttUnsubAckPacket(0, packetId);
    }
}

