/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttException;
import swim.mqtt.MqttUnsubAckPacket;

final class MqttUnsubAckPacketEncoder
extends Encoder<Object, MqttUnsubAckPacket> {
    final MqttEncoder mqtt;
    final MqttUnsubAckPacket packet;
    final int length;
    final int remaining;
    final int step;

    MqttUnsubAckPacketEncoder(MqttEncoder mqtt, MqttUnsubAckPacket packet, int length, int remaining, int step) {
        this.mqtt = mqtt;
        this.packet = packet;
        this.length = length;
        this.remaining = remaining;
        this.step = step;
    }

    MqttUnsubAckPacketEncoder(MqttEncoder mqtt, MqttUnsubAckPacket packet) {
        this(mqtt, packet, 0, 0, 1);
    }

    public Encoder<Object, MqttUnsubAckPacket> pull(OutputBuffer<?> output) {
        return MqttUnsubAckPacketEncoder.encode(output, this.mqtt, this.packet, this.length, this.remaining, this.step);
    }

    static Encoder<Object, MqttUnsubAckPacket> encode(OutputBuffer<?> output, MqttEncoder mqtt, MqttUnsubAckPacket packet, int length, int remaining, int step) {
        if (step == 1 && output.isCont()) {
            remaining = length = packet.variableHeaderSize(mqtt);
            output = output.write(packet.packetType() << 4 | packet.packetFlags & 0xF);
            step = 2;
        }
        while (step >= 2 && step <= 5 && output.isCont()) {
            int b = length & 0x7F;
            if ((length >>>= 7) > 0) {
                b |= 0x80;
            }
            output = output.write(b);
            if (length == 0) {
                step = 6;
                break;
            }
            if (step < 5) {
                ++step;
                continue;
            }
            return Encoder.error((Throwable)new MqttException("packet length too long: " + remaining));
        }
        if (step == 6 && remaining > 0 && output.isCont()) {
            output = output.write(packet.packetId >>> 8);
            --remaining;
            step = 7;
        }
        if (step == 7 && remaining > 0 && output.isCont()) {
            output = output.write(packet.packetId);
            --remaining;
            step = 8;
        }
        if (step == 8 && remaining == 0) {
            return Encoder.done((Object)packet);
        }
        if (remaining < 0) {
            return Encoder.error((Throwable)new MqttException("packet length too short"));
        }
        if (output.isDone()) {
            return Encoder.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return Encoder.error((Throwable)output.trap());
        }
        return new MqttUnsubAckPacketEncoder(mqtt, packet, length, remaining, step);
    }

    static Encoder<Object, MqttUnsubAckPacket> encode(OutputBuffer<?> output, MqttEncoder mqtt, MqttUnsubAckPacket packet) {
        return MqttUnsubAckPacketEncoder.encode(output, mqtt, packet, 0, 0, 1);
    }
}

