/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.collections.FingerTrieSeq;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttPacket;
import swim.util.Murmur3;

public final class MqttUnsubscribePacket
extends MqttPacket<Object>
implements Debug {
    final int packetFlags;
    final int packetId;
    final FingerTrieSeq<String> topicNames;
    private static int hashSeed;

    MqttUnsubscribePacket(int packetFlags, int packetId, FingerTrieSeq<String> topicNames) {
        this.packetFlags = packetFlags;
        this.packetId = packetId;
        this.topicNames = topicNames;
    }

    @Override
    public int packetType() {
        return 10;
    }

    @Override
    public int packetFlags() {
        return this.packetFlags;
    }

    public MqttUnsubscribePacket packetFlags(int packetFlags) {
        return new MqttUnsubscribePacket(packetFlags, this.packetId, this.topicNames);
    }

    public int packetId() {
        return this.packetId;
    }

    public MqttUnsubscribePacket packetId(int packetId) {
        return new MqttUnsubscribePacket(this.packetFlags, packetId, this.topicNames);
    }

    public FingerTrieSeq<String> topicNames() {
        return this.topicNames;
    }

    public MqttUnsubscribePacket topicNames(FingerTrieSeq<String> topicNames) {
        return new MqttUnsubscribePacket(this.packetFlags, this.packetId, topicNames);
    }

    public MqttUnsubscribePacket topicNames(String ... topicNames) {
        return new MqttUnsubscribePacket(this.packetFlags, this.packetId, (FingerTrieSeq<String>)FingerTrieSeq.of((Object[])topicNames));
    }

    public MqttUnsubscribePacket topicName(String topicName) {
        return new MqttUnsubscribePacket(this.packetFlags, this.packetId, (FingerTrieSeq<String>)this.topicNames.appended((Object)topicName));
    }

    @Override
    int variableHeaderSize(MqttEncoder mqtt) {
        int size = 2;
        int n = this.topicNames.size();
        for (int i = 0; i < n; ++i) {
            size += mqtt.sizeOfString((String)this.topicNames.get(i));
        }
        return size;
    }

    @Override
    public Encoder<?, MqttUnsubscribePacket> mqttEncoder(MqttEncoder mqtt) {
        return mqtt.unsubscribePacketEncoder(this);
    }

    @Override
    public Encoder<?, MqttUnsubscribePacket> encodeMqtt(OutputBuffer<?> output, MqttEncoder mqtt) {
        return mqtt.encodeUnsubscribePacket(output, this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttUnsubscribePacket) {
            MqttUnsubscribePacket that = (MqttUnsubscribePacket)other;
            return this.packetFlags == that.packetFlags && this.packetId == that.packetId && this.topicNames.equals(that.topicNames);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttUnsubscribePacket.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.packetFlags), (int)this.packetId), (int)this.topicNames.hashCode()));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("MqttUnsubscribePacket").write(46).write("create").write(40).debug((Object)this.packetId).write(41);
        if (this.packetFlags != 2) {
            output = output.write(46).write("packetFlags").write(40).debug((Object)this.packetFlags).write(41);
        }
        int n = this.topicNames.size();
        for (int i = 0; i < n; ++i) {
            output = output.write(46).write("topicName").write(40).debug(this.topicNames.get(i)).write(41);
        }
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static MqttUnsubscribePacket create(int packetFlags, int packetId, FingerTrieSeq<String> topicNames) {
        return new MqttUnsubscribePacket(packetFlags, packetId, topicNames);
    }

    public static MqttUnsubscribePacket create(int packetId, FingerTrieSeq<String> topicNames) {
        return new MqttUnsubscribePacket(2, packetId, topicNames);
    }

    public static MqttUnsubscribePacket create(int packetId, String ... topicNames) {
        return new MqttUnsubscribePacket(2, packetId, (FingerTrieSeq<String>)FingerTrieSeq.of((Object[])topicNames));
    }

    public static MqttUnsubscribePacket create(int packetId) {
        return new MqttUnsubscribePacket(2, packetId, (FingerTrieSeq<String>)FingerTrieSeq.empty());
    }
}

