/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import java.math.BigInteger;
import swim.codec.Input;
import swim.codec.Parser;
import swim.recon.ReconParser;

final class BigIntegerParser<I, V>
extends Parser<V> {
    final ReconParser<I, V> recon;
    final int sign;
    final BigInteger value;

    BigIntegerParser(ReconParser<I, V> recon, int sign, BigInteger value) {
        this.recon = recon;
        this.sign = sign;
        this.value = value;
    }

    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon, int sign, BigInteger value) {
        int c;
        while (input.isCont() && (c = input.head()) >= 48 && c <= 57) {
            input = input.step();
            value = BigInteger.TEN.multiply(value).add(BigInteger.valueOf(sign * (c - 48)));
        }
        if (!input.isEmpty()) {
            return BigIntegerParser.done(recon.num(value));
        }
        return new BigIntegerParser<I, V>(recon, sign, value);
    }

    public Parser<V> feed(Input input) {
        return BigIntegerParser.parse(input, this.recon, this.sign, this.value);
    }
}

