/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.recon.ReconWriter;

final class FilterSelectorWriter<I, V>
extends Writer<Object, Object> {
    final ReconWriter<I, V> recon;
    final V predicate;
    final V then;
    final Writer<?, ?> part;
    final int step;

    FilterSelectorWriter(ReconWriter<I, V> recon, V predicate, V then, Writer<?, ?> part, int step) {
        this.recon = recon;
        this.predicate = predicate;
        this.then = then;
        this.part = part;
        this.step = step;
    }

    static <I, V> int sizeOf(ReconWriter<I, V> recon, V predicate, V then) {
        int size = 2;
        size += recon.sizeOfValue(predicate);
        ++size;
        return size += recon.sizeOfThen(then);
    }

    static <I, V> int sizeOfThen(ReconWriter<I, V> recon, V predicate, V then) {
        int size = 1;
        size += recon.sizeOfValue(predicate);
        ++size;
        return size += recon.sizeOfThen(then);
    }

    static <I, V> Writer<Object, Object> write(Output<?> output, ReconWriter<I, V> recon, V predicate, V then, Writer<?, ?> part, int step) {
        if (step == 1 && output.isCont()) {
            output = output.write(36);
            step = 2;
        }
        if (step == 2 && output.isCont()) {
            output = output.write(91);
            step = 3;
        }
        if (step == 3) {
            if ((part = part == null ? recon.writeValue(predicate, output) : part.pull(output)).isDone()) {
                part = null;
                step = 4;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 4 && output.isCont()) {
            output = output.write(93);
            return recon.writeThen(then, output);
        }
        if (output.isDone()) {
            return FilterSelectorWriter.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return FilterSelectorWriter.error((Throwable)output.trap());
        }
        return new FilterSelectorWriter<I, V>(recon, predicate, then, part, step);
    }

    static <I, V> Writer<Object, Object> write(Output<?> output, ReconWriter<I, V> recon, V predicate, V then) {
        return FilterSelectorWriter.write(output, recon, predicate, then, null, 1);
    }

    static <I, V> Writer<Object, Object> writeThen(Output<?> output, ReconWriter<I, V> recon, V predicate, V then) {
        return FilterSelectorWriter.write(output, recon, predicate, then, null, 2);
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return FilterSelectorWriter.write(output, this.recon, this.predicate, this.then, this.part, this.step);
    }
}

