/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.recon.Recon;
import swim.recon.ReconParser;
import swim.util.Builder;

final class BitwiseOrOperatorParser<I, V>
extends Parser<V> {
    final ReconParser<I, V> recon;
    final Builder<I, V> builder;
    final Parser<V> lhsParser;
    final Parser<V> rhsParser;
    final int step;

    BitwiseOrOperatorParser(ReconParser<I, V> recon, Builder<I, V> builder, Parser<V> lhsParser, Parser<V> rhsParser, int step) {
        this.recon = recon;
        this.builder = builder;
        this.lhsParser = lhsParser;
        this.rhsParser = rhsParser;
        this.step = step;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon, Builder<I, V> builder, Parser<V> lhsParser, Parser<V> rhsParser, int step) {
        block20: {
            int c = 0;
            while (true) {
                if (step == 1) {
                    if (lhsParser == null) {
                        lhsParser = recon.parseBitwiseXorOperator(input, builder);
                    }
                    while (lhsParser.isCont() && !input.isEmpty()) {
                        lhsParser = lhsParser.feed(input);
                    }
                    if (lhsParser.isDone()) {
                        step = 2;
                    } else if (lhsParser.isError()) {
                        return lhsParser.asError();
                    }
                }
                if (step == 2) {
                    while (input.isCont() && Recon.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont()) {
                        if (c != 124) return lhsParser;
                        input = input.step();
                        step = 3;
                    } else if (input.isDone()) {
                        return lhsParser;
                    }
                }
                if (step == 3) {
                    if (input.isCont()) {
                        c = input.head();
                        if (c == 124) {
                            return lhsParser;
                        }
                        step = 4;
                    } else if (input.isDone()) {
                        return BitwiseOrOperatorParser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                    }
                }
                if (step != 4) break block20;
                if (rhsParser == null) {
                    rhsParser = recon.parseBitwiseXorOperator(input, builder);
                }
                while (rhsParser.isCont() && !input.isEmpty()) {
                    rhsParser = rhsParser.feed(input);
                }
                if (!rhsParser.isDone()) break;
                Object lhs = lhsParser.bind();
                Object rhs = rhsParser.bind();
                lhsParser = BitwiseOrOperatorParser.done((Object)recon.bitwiseOr(lhs, rhs));
                rhsParser = null;
                step = 2;
            }
            if (rhsParser.isError()) {
                return rhsParser.asError();
            }
        }
        if (!input.isError()) return new BitwiseOrOperatorParser<I, Object>(recon, builder, lhsParser, rhsParser, step);
        return BitwiseOrOperatorParser.error((Throwable)input.trap());
    }

    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon, Builder<I, V> builder) {
        return BitwiseOrOperatorParser.parse(input, recon, builder, null, null, 1);
    }

    public Parser<V> feed(Input input) {
        return BitwiseOrOperatorParser.parse(input, this.recon, this.builder, this.lhsParser, this.rhsParser, this.step);
    }
}

