/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.recon.Recon;
import swim.recon.ReconParser;
import swim.util.Builder;

final class ConditionalOperatorParser<I, V>
extends Parser<V> {
    final ReconParser<I, V> recon;
    final Builder<I, V> builder;
    final Parser<V> ifParser;
    final Parser<V> thenParser;
    final Parser<V> elseParser;
    final int step;

    ConditionalOperatorParser(ReconParser<I, V> recon, Builder<I, V> builder, Parser<V> ifParser, Parser<V> thenParser, Parser<V> elseParser, int step) {
        this.recon = recon;
        this.builder = builder;
        this.ifParser = ifParser;
        this.thenParser = thenParser;
        this.elseParser = elseParser;
        this.step = step;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon, Builder<I, V> builder, Parser<V> ifParser, Parser<V> thenParser, Parser<V> elseParser, int step) {
        int c = 0;
        if (step == 1) {
            if (ifParser == null) {
                ifParser = recon.parseOrOperator(input, builder);
            }
            while (ifParser.isCont() && !input.isEmpty()) {
                ifParser = ifParser.feed(input);
            }
            if (ifParser.isDone()) {
                step = 2;
            } else if (ifParser.isError()) {
                return ifParser.asError();
            }
        }
        if (step == 2) {
            while (input.isCont() && Recon.isSpace(c = input.head())) {
                input = input.step();
            }
            if (input.isCont()) {
                if (c != 63) return ifParser;
                input = input.step();
                step = 3;
            } else if (input.isDone()) {
                return ifParser;
            }
        }
        if (step == 3) {
            if (thenParser == null) {
                thenParser = recon.parseConditionalOperator(input, builder);
            }
            while (thenParser.isCont() && !input.isEmpty()) {
                thenParser = thenParser.feed(input);
            }
            if (thenParser.isDone()) {
                step = 4;
            } else if (thenParser.isError()) {
                return thenParser.asError();
            }
        }
        if (step == 4) {
            while (input.isCont() && Recon.isSpace(c = input.head())) {
                input = input.step();
            }
            if (input.isCont()) {
                if (c != 58) return ConditionalOperatorParser.error((Diagnostic)Diagnostic.expected((int)58, (Input)input));
                input = input.step();
                step = 5;
            } else if (input.isDone()) {
                return ConditionalOperatorParser.error((Diagnostic)Diagnostic.expected((int)58, (Input)input));
            }
        }
        if (step == 5) {
            if (elseParser == null) {
                elseParser = recon.parseConditionalOperator(input, builder);
            }
            while (elseParser.isCont() && !input.isEmpty()) {
                elseParser = elseParser.feed(input);
            }
            if (elseParser.isDone()) {
                Object ifTerm = ifParser.bind();
                Object thenTerm = thenParser.bind();
                Object elseTerm = elseParser.bind();
                return ConditionalOperatorParser.done((Object)recon.conditional(ifTerm, thenTerm, elseTerm));
            }
            if (elseParser.isError()) {
                return elseParser.asError();
            }
        }
        if (!input.isError()) return new ConditionalOperatorParser<I, Object>(recon, builder, ifParser, thenParser, elseParser, step);
        return ConditionalOperatorParser.error((Throwable)input.trap());
    }

    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon, Builder<I, V> builder) {
        return ConditionalOperatorParser.parse(input, recon, builder, null, null, null, 1);
    }

    public Parser<V> feed(Input input) {
        return ConditionalOperatorParser.parse(input, this.recon, this.builder, this.ifParser, this.thenParser, this.elseParser, this.step);
    }
}

