/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.recon.Recon;
import swim.recon.ReconParser;
import swim.util.Builder;

final class PrefixOperatorParser<I, V>
extends Parser<V> {
    final ReconParser<I, V> recon;
    final Builder<I, V> builder;
    final String operator;
    final Parser<V> rhsParser;
    final int step;

    PrefixOperatorParser(ReconParser<I, V> recon, Builder<I, V> builder, String operator, Parser<V> rhsParser, int step) {
        this.recon = recon;
        this.builder = builder;
        this.operator = operator;
        this.rhsParser = rhsParser;
        this.step = step;
    }

    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon, Builder<I, V> builder, String operator, Parser<V> rhsParser, int step) {
        int c = 0;
        if (step == 1) {
            while (input.isCont() && Recon.isSpace(c = input.head())) {
                input = input.step();
            }
            if (input.isCont()) {
                if (c == 33) {
                    input = input.step();
                    operator = "!";
                } else if (c == 126) {
                    input = input.step();
                    operator = "~";
                } else if (c == 45) {
                    input = input.step();
                    operator = "-";
                } else if (c == 43) {
                    input = input.step();
                    operator = "+";
                } else {
                    return recon.parseInvokeOperator(input, builder);
                }
                step = 2;
            } else if (input.isDone()) {
                return recon.parseInvokeOperator(input, builder);
            }
        }
        if (step == 2) {
            if (rhsParser == null) {
                rhsParser = recon.parsePrefixOperator(input, builder);
            }
            while (rhsParser.isCont() && !input.isEmpty()) {
                rhsParser = rhsParser.feed(input);
            }
            if (rhsParser.isDone()) {
                Object operand = rhsParser.bind();
                if (!recon.isDistinct(operand)) {
                    return PrefixOperatorParser.error((Diagnostic)Diagnostic.expected((String)"value", (Input)input));
                }
                if ("!".equals(operator)) {
                    return PrefixOperatorParser.done((Object)recon.not(operand));
                }
                if ("~".equals(operator)) {
                    return PrefixOperatorParser.done((Object)recon.bitwiseNot(operand));
                }
                if ("-".equals(operator)) {
                    return PrefixOperatorParser.done((Object)recon.negative(operand));
                }
                if ("+".equals(operator)) {
                    return PrefixOperatorParser.done((Object)recon.positive(operand));
                }
                return PrefixOperatorParser.error((Diagnostic)Diagnostic.message((String)operator, (Input)input));
            }
            if (rhsParser.isError()) {
                return rhsParser.asError();
            }
        }
        if (input.isError()) {
            return PrefixOperatorParser.error((Throwable)input.trap());
        }
        return new PrefixOperatorParser<I, V>(recon, builder, operator, rhsParser, step);
    }

    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon, Builder<I, V> builder) {
        return PrefixOperatorParser.parse(input, recon, builder, null, null, 1);
    }

    public Parser<V> feed(Input input) {
        return PrefixOperatorParser.parse(input, this.recon, this.builder, this.operator, this.rhsParser, this.step);
    }
}

