/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import swim.codec.Output;
import swim.codec.Unicode;
import swim.codec.Utf8;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.recon.ReconWriter;

final class PrefixOperatorWriter<I, V>
extends Writer<Object, Object> {
    final ReconWriter<I, V> recon;
    final String operator;
    final I rhs;
    final int precedence;
    final Writer<?, ?> part;
    final int step;

    PrefixOperatorWriter(ReconWriter<I, V> recon, String operator, I rhs, int precedence, Writer<?, ?> part, int step) {
        this.recon = recon;
        this.operator = operator;
        this.rhs = rhs;
        this.precedence = precedence;
        this.part = part;
        this.step = step;
    }

    static <I, V> int sizeOf(ReconWriter<I, V> recon, String operator, I rhs, int precedence) {
        int size = 0;
        size += Utf8.sizeOf((String)operator);
        if (recon.precedence(rhs) < precedence) {
            ++size;
            size += recon.sizeOfItem(rhs);
            ++size;
        } else {
            size += recon.sizeOfItem(rhs);
        }
        return size;
    }

    static <I, V> Writer<Object, Object> write(Output<?> output, ReconWriter<I, V> recon, String operator, I rhs, int precedence, Writer<?, ?> part, int step) {
        if (step == 1) {
            if ((part = part == null ? Unicode.writeString((Object)operator, output) : part.pull(output)).isDone()) {
                part = null;
                step = 2;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 2) {
            if (recon.precedence(rhs) < precedence) {
                if (output.isCont()) {
                    output = output.write(40);
                    step = 3;
                }
            } else {
                step = 3;
            }
        }
        if (step == 3) {
            if ((part = part == null ? recon.writeItem(rhs, output) : part.pull(output)).isDone()) {
                part = null;
                step = 4;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 4) {
            if (recon.precedence(rhs) < precedence) {
                if (output.isCont()) {
                    output = output.write(41);
                    return PrefixOperatorWriter.done();
                }
            } else {
                return PrefixOperatorWriter.done();
            }
        }
        if (output.isDone()) {
            return PrefixOperatorWriter.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return PrefixOperatorWriter.error((Throwable)output.trap());
        }
        return new PrefixOperatorWriter<I, V>(recon, operator, rhs, precedence, (Writer<?, ?>)part, step);
    }

    static <I, V> Writer<Object, Object> write(Output<?> output, ReconWriter<I, V> recon, String operator, I rhs, int precedence) {
        return PrefixOperatorWriter.write(output, recon, operator, rhs, precedence, null, 1);
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return PrefixOperatorWriter.write(output, this.recon, this.operator, this.rhs, this.precedence, this.part, this.step);
    }
}

