/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.recon.ReconWriter;

final class LiteralSelectorWriter<I, V>
extends Writer<Object, Object> {
    final ReconWriter<I, V> recon;
    final I item;
    final V then;
    final Writer<?, ?> part;
    final int step;

    LiteralSelectorWriter(ReconWriter<I, V> recon, I item, V then, Writer<?, ?> part, int step) {
        this.recon = recon;
        this.item = item;
        this.then = then;
        this.part = part;
        this.step = step;
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return LiteralSelectorWriter.write(output, this.recon, this.item, this.then, this.part, this.step);
    }

    static <I, V> int sizeOf(ReconWriter<I, V> recon, I item, V then) {
        int size = 0;
        if (recon.precedence(item) < recon.precedence(recon.item(then))) {
            ++size;
            size += recon.sizeOfItem(item);
            ++size;
        } else {
            size += recon.sizeOfItem(item);
        }
        return size += recon.sizeOfThen(then);
    }

    static <I, V> Writer<Object, Object> write(Output<?> output, ReconWriter<I, V> recon, I item, V then, Writer<?, ?> part, int step) {
        if (step == 1) {
            if (recon.precedence(item) < recon.precedence(recon.item(then))) {
                if (output.isCont()) {
                    output = output.write(40);
                    step = 2;
                }
            } else {
                step = 2;
            }
        }
        if (step == 2) {
            if ((part = part == null ? recon.writeItem(item, output) : part.pull(output)).isDone()) {
                part = null;
                step = 3;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 3) {
            if (recon.precedence(item) < recon.precedence(recon.item(then))) {
                if (output.isCont()) {
                    output = output.write(41);
                    step = 4;
                }
            } else {
                step = 4;
            }
        }
        if (step == 4) {
            return recon.writeThen(then, output);
        }
        if (output.isDone()) {
            return LiteralSelectorWriter.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return LiteralSelectorWriter.error((Throwable)output.trap());
        }
        return new LiteralSelectorWriter<I, V>(recon, item, then, part, step);
    }

    static <I, V> Writer<Object, Object> write(Output<?> output, ReconWriter<I, V> recon, I item, V then) {
        return LiteralSelectorWriter.write(output, recon, item, then, null, 1);
    }
}

