/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.recon.Recon;
import swim.recon.ReconParser;
import swim.util.Builder;

final class AdditiveOperatorParser<I, V>
extends Parser<V> {
    final ReconParser<I, V> recon;
    final Builder<I, V> builder;
    final Parser<V> lhsParser;
    final String operator;
    final Parser<V> rhsParser;
    final int step;

    AdditiveOperatorParser(ReconParser<I, V> recon, Builder<I, V> builder, Parser<V> lhsParser, String operator, Parser<V> rhsParser, int step) {
        this.recon = recon;
        this.builder = builder;
        this.lhsParser = lhsParser;
        this.operator = operator;
        this.rhsParser = rhsParser;
        this.step = step;
    }

    public Parser<V> feed(Input input) {
        return AdditiveOperatorParser.parse(input, this.recon, this.builder, this.lhsParser, this.operator, this.rhsParser, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon, Builder<I, V> builder, Parser<V> lhsParser, String operator, Parser<V> rhsParser, int step) {
        block19: {
            int c = 0;
            while (true) {
                if (step == 1) {
                    if (lhsParser == null) {
                        lhsParser = recon.parseMultiplicativeOperator(input, builder);
                    }
                    while (lhsParser.isCont() && !input.isEmpty()) {
                        lhsParser = lhsParser.feed(input);
                    }
                    if (lhsParser.isDone()) {
                        step = 2;
                    } else if (lhsParser.isError()) {
                        return lhsParser.asError();
                    }
                }
                if (step == 2) {
                    while (input.isCont() && Recon.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont()) {
                        if (c == 43) {
                            input = input.step();
                            operator = "+";
                            step = 3;
                        } else {
                            if (c != 45) return lhsParser;
                            input = input.step();
                            operator = "-";
                            step = 3;
                        }
                    } else if (input.isDone()) {
                        return lhsParser;
                    }
                }
                if (step != 3) break block19;
                if (rhsParser == null) {
                    rhsParser = recon.parseMultiplicativeOperator(input, builder);
                }
                while (rhsParser.isCont() && !input.isEmpty()) {
                    rhsParser = rhsParser.feed(input);
                }
                if (!rhsParser.isDone()) break;
                Object lhs = lhsParser.bind();
                Object rhs = rhsParser.bind();
                if ("+".equals(operator)) {
                    lhsParser = Parser.done((Object)recon.plus(lhs, rhs));
                } else {
                    if (!"-".equals(operator)) return Parser.error((Diagnostic)Diagnostic.message((String)operator, (Input)input));
                    lhsParser = Parser.done((Object)recon.minus(lhs, rhs));
                }
                rhsParser = null;
                operator = null;
                step = 2;
            }
            if (rhsParser.isError()) {
                return rhsParser.asError();
            }
        }
        if (!input.isError()) return new AdditiveOperatorParser<I, Object>(recon, builder, lhsParser, operator, rhsParser, step);
        return Parser.error((Throwable)input.trap());
    }

    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon, Builder<I, V> builder) {
        return AdditiveOperatorParser.parse(input, recon, builder, null, null, null, 1);
    }
}

