/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.recon.Recon;
import swim.recon.ReconParser;

final class AttrParser<I, V>
extends Parser<I> {
    final ReconParser<I, V> recon;
    final Parser<V> keyParser;
    final Parser<V> valueParser;
    final int step;

    AttrParser(ReconParser<I, V> recon, Parser<V> keyParser, Parser<V> valueParser, int step) {
        this.recon = recon;
        this.keyParser = keyParser;
        this.valueParser = valueParser;
        this.step = step;
    }

    public Parser<I> feed(Input input) {
        return AttrParser.parse(input, this.recon, this.keyParser, this.valueParser, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static <I, V> Parser<I> parse(Input input, ReconParser<I, V> recon, Parser<V> keyParser, Parser<V> valueParser, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (c != 64) return Parser.error((Diagnostic)Diagnostic.expected((int)64, (Input)input));
                input = input.step();
                step = 2;
            } else if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.expected((int)64, (Input)input));
            }
        }
        if (step == 2) {
            if (keyParser == null) {
                if (input.isCont()) {
                    c = input.head();
                    if (c == 34 || c == 39) {
                        keyParser = recon.parseString(input);
                    } else {
                        if (!Recon.isIdentStartChar(c)) return Parser.error((Diagnostic)Diagnostic.expected((String)"attribute name", (Input)input));
                        keyParser = recon.parseIdent(input);
                    }
                } else if (input.isDone()) {
                    return Parser.error((Diagnostic)Diagnostic.expected((String)"attribute name", (Input)input));
                }
            } else {
                keyParser = keyParser.feed(input);
            }
            if (keyParser != null) {
                if (keyParser.isDone()) {
                    step = 3;
                } else if (keyParser.isError()) {
                    return keyParser.asError();
                }
            }
        }
        if (step == 3) {
            if (input.isCont() && input.head() == 40) {
                input = input.step();
                step = 4;
            } else if (!input.isEmpty()) {
                return Parser.done(recon.attr(keyParser.bind()));
            }
        }
        if (step == 4) {
            while (input.isCont() && Recon.isWhitespace(c = input.head())) {
                input = input.step();
            }
            if (input.isCont()) {
                if (c == 41) {
                    input = input.step();
                    return Parser.done(recon.attr(keyParser.bind()));
                }
                step = 5;
            } else if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.expected((int)41, (Input)input));
            }
        }
        if (step == 5) {
            if (valueParser == null) {
                valueParser = recon.parseBlock(input);
            }
            while (valueParser.isCont() && !input.isEmpty()) {
                valueParser = valueParser.feed(input);
            }
            if (valueParser.isDone()) {
                step = 6;
            } else if (valueParser.isError()) {
                return valueParser.asError();
            }
        }
        if (step == 6) {
            while (input.isCont() && Recon.isWhitespace(c = input.head())) {
                input = input.step();
            }
            if (input.isCont()) {
                if (c != 41) return Parser.error((Diagnostic)Diagnostic.expected((int)41, (Input)input));
                input = input.step();
                return Parser.done(recon.attr(keyParser.bind(), valueParser.bind()));
            }
            if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.expected((int)41, (Input)input));
            }
        }
        if (!input.isError()) return new AttrParser<I, Object>(recon, keyParser, valueParser, step);
        return Parser.error((Throwable)input.trap());
    }

    static <I, V> Parser<I> parse(Input input, ReconParser<I, V> recon) {
        return AttrParser.parse(input, recon, null, null, 1);
    }
}

