/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import java.util.Iterator;
import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.recon.ReconWriter;

final class BlockWriter<I, V>
extends Writer<Object, Object> {
    final ReconWriter<I, V> recon;
    final Iterator<I> items;
    final boolean inBlock;
    final boolean inMarkup;
    final boolean inBraces;
    final boolean inBrackets;
    final boolean first;
    final boolean markupSafe;
    final I item;
    final I next;
    final Writer<?, ?> part;
    final int step;

    BlockWriter(ReconWriter<I, V> recon, Iterator<I> items, boolean inBlock, boolean inMarkup, boolean inBraces, boolean inBrackets, boolean first, boolean markupSafe, I item, I next, Writer<?, ?> part, int step) {
        this.recon = recon;
        this.items = items;
        this.inBlock = inBlock;
        this.inMarkup = inMarkup;
        this.inBraces = inBraces;
        this.inBrackets = inBrackets;
        this.first = first;
        this.markupSafe = markupSafe;
        this.item = item;
        this.next = next;
        this.part = part;
        this.step = step;
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return BlockWriter.write(output, this.recon, this.items, this.inBlock, this.inMarkup, this.inBraces, this.inBrackets, this.first, this.markupSafe, this.item, this.next, this.part, this.step);
    }

    static <I, V> int sizeOf(ReconWriter<I, V> recon, Iterator<I> items, boolean inBlock, boolean inMarkup) {
        int size = 0;
        boolean inBraces = false;
        boolean inBrackets = false;
        boolean first = true;
        boolean markupSafe = true;
        Object next = null;
        while (next != null || items.hasNext()) {
            Object item;
            if (next == null) {
                item = items.next();
            } else {
                item = next;
                next = null;
            }
            if (items.hasNext()) {
                next = items.next();
            }
            if (recon.isExpression(item)) {
                markupSafe = false;
            }
            if (inBrackets && recon.isAttr(item)) {
                if (inBraces) {
                    ++size;
                    inBraces = false;
                }
                ++size;
                inBrackets = false;
            }
            if (recon.isAttr(item)) {
                if (inBraces) {
                    ++size;
                    inBraces = false;
                } else if (inBrackets) {
                    ++size;
                    inBrackets = false;
                }
                size += recon.sizeOfItem(item);
                first = false;
                continue;
            }
            if (inBrackets && recon.isText(item)) {
                if (inBraces) {
                    ++size;
                    inBraces = false;
                }
                size += recon.sizeOfMarkupText(item);
                continue;
            }
            if (inBraces) {
                if (!first) {
                    ++size;
                } else {
                    first = false;
                }
                size += BlockWriter.sizeOfBlockItem(recon, item);
                continue;
            }
            if (inBrackets) {
                if (recon.isRecord(item) && recon.isMarkupSafe(recon.items(item))) {
                    size += recon.sizeOfBlock(recon.items(item), false, true);
                    if (next != null && recon.isText(next)) {
                        size += recon.sizeOfMarkupText(next);
                        next = null;
                        continue;
                    }
                    if (next != null && !recon.isAttr(next)) {
                        ++size;
                        inBraces = true;
                        first = true;
                        continue;
                    }
                    ++size;
                    inBrackets = false;
                    continue;
                }
                ++size;
                size += recon.sizeOfItem(item);
                inBraces = true;
                first = false;
                continue;
            }
            if (markupSafe && recon.isText(item) && next != null && !recon.isField(next) && !recon.isText(next) && !recon.isBool(next)) {
                ++size;
                size += recon.sizeOfMarkupText(item);
                inBrackets = true;
                continue;
            }
            if (inBlock && !inBraces) {
                if (!first) {
                    ++size;
                } else {
                    first = false;
                }
                size += BlockWriter.sizeOfBlockItem(recon, item);
                continue;
            }
            if (inMarkup && recon.isText(item) && next == null) {
                ++size;
                size += recon.sizeOfMarkupText(item);
                ++size;
                continue;
            }
            if (!inMarkup && recon.isValue(item) && !recon.isRecord(item) && (!first && next == null || next != null && recon.isAttr(next))) {
                if (!first && (recon.isText(item) && recon.isIdent(item) || recon.isNum(item) || recon.isBool(item))) {
                    ++size;
                }
                size += recon.sizeOfItem(item);
                continue;
            }
            ++size;
            size += recon.sizeOfItem(item);
            inBraces = true;
            first = false;
        }
        if (inBraces) {
            ++size;
        }
        if (inBrackets) {
            ++size;
        }
        return size;
    }

    static <I, V> int sizeOfBlockItem(ReconWriter<I, V> recon, I item) {
        int size = 0;
        size = recon.isField(item) ? (size += recon.sizeOfSlot(recon.key(item), recon.value(item))) : (size += recon.sizeOfItem(item));
        return size;
    }

    static <I, V> Writer<Object, Object> write(Output<?> output, ReconWriter<I, V> recon, Iterator<I> items, boolean inBlock, boolean inMarkup, boolean inBraces, boolean inBrackets, boolean first, boolean markupSafe, I item, I next, Writer<?, ?> part, int step) {
        while (true) {
            if (step == 1) {
                if (next == null && !items.hasNext()) {
                    step = 10;
                    break;
                }
                if (next == null) {
                    item = items.next();
                } else {
                    item = next;
                    next = null;
                }
                if (items.hasNext()) {
                    next = items.next();
                }
                if (recon.isExpression(item)) {
                    markupSafe = false;
                }
                step = 2;
            }
            if (step == 2 && output.isCont()) {
                if (inBrackets && recon.isAttr(item)) {
                    if (inBraces) {
                        output = output.write(125);
                        inBraces = false;
                    }
                    step = 3;
                } else {
                    step = 4;
                }
            }
            if (step == 3 && output.isCont()) {
                output = output.write(93);
                inBrackets = false;
                step = 4;
            }
            if (step == 4 && output.isCont()) {
                if (recon.isAttr(item)) {
                    if (inBraces) {
                        output = output.write(125);
                        inBraces = false;
                    } else if (inBrackets) {
                        output = output.write(93);
                        inBrackets = false;
                    }
                    part = recon.writeItem(output, item);
                    first = false;
                    step = 7;
                } else if (inBrackets && recon.isText(item)) {
                    if (inBraces) {
                        output = output.write(125);
                        inBraces = false;
                    }
                    part = recon.writeMarkupText(output, item);
                    step = 7;
                } else if (inBraces) {
                    if (!first) {
                        output = output.write(44);
                    } else {
                        first = false;
                    }
                    part = BlockWriter.writeItem(output, recon, item);
                    step = 7;
                } else if (inBrackets) {
                    if (recon.isRecord(item) && recon.isMarkupSafe(recon.items(item))) {
                        part = recon.writeBlock(output, recon.items(item), false, true);
                        step = 5;
                    } else {
                        output = output.write(123);
                        part = recon.writeItem(output, item);
                        inBraces = true;
                        first = false;
                        step = 7;
                    }
                } else if (markupSafe && recon.isText(item) && next != null && !recon.isField(next) && !recon.isText(next) && !recon.isBool(next)) {
                    output = output.write(91);
                    part = recon.writeMarkupText(output, item);
                    inBrackets = true;
                    step = 7;
                } else if (inBlock && !inBraces) {
                    if (!first) {
                        output = output.write(44);
                    } else {
                        first = false;
                    }
                    part = BlockWriter.writeItem(output, recon, item);
                    step = 7;
                } else if (inMarkup && recon.isText(item) && next == null) {
                    output = output.write(91);
                    part = recon.writeMarkupText(output, item);
                    step = 8;
                } else if (!inMarkup && recon.isValue(item) && !recon.isRecord(item) && (!first && next == null || next != null && recon.isAttr(next))) {
                    if (!first && (recon.isText(item) && recon.isIdent(item) || recon.isNum(item) || recon.isBool(item))) {
                        output = output.write(32);
                    }
                    part = recon.writeItem(output, item);
                    step = 7;
                } else {
                    output = output.write(123);
                    part = recon.writeItem(output, item);
                    inBraces = true;
                    first = false;
                    step = 7;
                }
            }
            if (step == 5) {
                if ((part = part.pull(output)).isDone()) {
                    part = null;
                    step = 6;
                } else if (part.isError()) {
                    return part.asError();
                }
            }
            if (step == 6 && output.isCont()) {
                if (next != null && recon.isText(next)) {
                    part = recon.writeMarkupText(output, next);
                    next = null;
                    step = 7;
                } else {
                    if (next != null && !recon.isAttr(next)) {
                        output = output.write(123);
                        inBraces = true;
                        first = true;
                        step = 1;
                        continue;
                    }
                    output = output.write(93);
                    inBrackets = false;
                    step = 1;
                    continue;
                }
            }
            if (step == 7) {
                if ((part = part.pull(output)).isDone()) {
                    part = null;
                    step = 1;
                    continue;
                }
                if (part.isError()) {
                    return part.asError();
                }
            }
            if (step == 8) {
                if ((part = part.pull(output)).isDone()) {
                    part = null;
                    step = 9;
                } else if (part.isError()) {
                    return part.asError();
                }
            }
            if (step != 9 || !output.isCont()) break;
            output = output.write(93);
            step = 1;
        }
        if (step == 10) {
            if (inBraces) {
                if (output.isCont()) {
                    output = output.write(125);
                    step = 11;
                }
            } else {
                step = 11;
            }
        }
        if (step == 11) {
            if (inBrackets) {
                if (output.isCont()) {
                    output = output.write(93);
                    return Writer.done();
                }
            } else {
                return Writer.done();
            }
        }
        if (output.isDone()) {
            return Writer.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return Writer.error((Throwable)output.trap());
        }
        return new BlockWriter<I, V>(recon, items, inBlock, inMarkup, inBraces, inBrackets, first, markupSafe, item, next, part, step);
    }

    static <I, V> Writer<Object, Object> write(Output<?> output, ReconWriter<I, V> recon, Iterator<I> items, boolean inBlock, boolean inMarkup) {
        return BlockWriter.write(output, recon, items, inBlock, inMarkup, false, false, true, true, null, null, null, 1);
    }

    static <I, V> Writer<?, ?> writeItem(Output<?> output, ReconWriter<I, V> recon, I item) {
        if (recon.isField(item)) {
            return recon.writeSlot(output, recon.key(item), recon.value(item));
        }
        return recon.writeItem(output, item);
    }
}

