/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.recon.ReconWriter;

final class ConditionalOperatorWriter<I, V>
extends Writer<Object, Object> {
    final ReconWriter<I, V> recon;
    final I ifTerm;
    final I thenTerm;
    final I elseTerm;
    final int precedence;
    final Writer<?, ?> part;
    final int step;

    ConditionalOperatorWriter(ReconWriter<I, V> recon, I ifTerm, I thenTerm, I elseTerm, int precedence, Writer<?, ?> part, int step) {
        this.recon = recon;
        this.ifTerm = ifTerm;
        this.thenTerm = thenTerm;
        this.elseTerm = elseTerm;
        this.precedence = precedence;
        this.part = part;
        this.step = step;
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return ConditionalOperatorWriter.write(output, this.recon, this.ifTerm, this.thenTerm, this.elseTerm, this.precedence, this.part, this.step);
    }

    static <I, V> int sizeOf(ReconWriter<I, V> recon, I ifTerm, I thenTerm, I elseTerm, int precedence) {
        int size = 0;
        if (recon.precedence(ifTerm) > 0 && recon.precedence(ifTerm) <= precedence) {
            ++size;
            size += recon.sizeOfItem(ifTerm);
            ++size;
        } else {
            size += recon.sizeOfItem(ifTerm);
        }
        size += 3;
        size += recon.sizeOfItem(thenTerm);
        size += 3;
        return size += recon.sizeOfItem(elseTerm);
    }

    static <I, V> Writer<Object, Object> write(Output<?> output, ReconWriter<I, V> recon, I ifTerm, I thenTerm, I elseTerm, int precedence, Writer<?, ?> part, int step) {
        if (step == 1) {
            if (recon.precedence(ifTerm) > 0 && recon.precedence(ifTerm) <= precedence) {
                if (output.isCont()) {
                    output = output.write(40);
                    step = 2;
                }
            } else {
                step = 2;
            }
        }
        if (step == 2) {
            if ((part = part == null ? recon.writeItem(output, ifTerm) : part.pull(output)).isDone()) {
                part = null;
                step = 3;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 3) {
            if (recon.precedence(ifTerm) > 0 && recon.precedence(ifTerm) <= precedence) {
                if (output.isCont()) {
                    output = output.write(41);
                    step = 4;
                }
            } else {
                step = 4;
            }
        }
        if (step == 4 && output.isCont()) {
            output = output.write(32);
            step = 5;
        }
        if (step == 5 && output.isCont()) {
            output = output.write(63);
            step = 6;
        }
        if (step == 6 && output.isCont()) {
            output = output.write(32);
            step = 7;
        }
        if (step == 7) {
            if ((part = part == null ? recon.writeItem(output, thenTerm) : part.pull(output)).isDone()) {
                part = null;
                step = 8;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 8 && output.isCont()) {
            output = output.write(32);
            step = 9;
        }
        if (step == 9 && output.isCont()) {
            output = output.write(58);
            step = 10;
        }
        if (step == 10 && output.isCont()) {
            output = output.write(32);
            step = 11;
        }
        if (step == 11) {
            if ((part = part == null ? recon.writeItem(output, elseTerm) : part.pull(output)).isDone()) {
                return Writer.done();
            }
            if (part.isError()) {
                return part.asError();
            }
        }
        if (output.isDone()) {
            return Writer.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return Writer.error((Throwable)output.trap());
        }
        return new ConditionalOperatorWriter<I, V>(recon, ifTerm, thenTerm, elseTerm, precedence, part, step);
    }

    static <I, V> Writer<Object, Object> write(Output<?> output, ReconWriter<I, V> recon, I ifTerm, I thenTerm, I elseTerm, int precedence) {
        return ConditionalOperatorWriter.write(output, recon, ifTerm, thenTerm, elseTerm, precedence, null, 1);
    }
}

