/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import swim.codec.Base64;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.recon.ReconParser;

final class DataParser<I, V>
extends Parser<V> {
    final ReconParser<I, V> recon;
    final Parser<V> base64Parser;
    final int step;

    DataParser(ReconParser<I, V> recon, Parser<V> base64Parser, int step) {
        this.recon = recon;
        this.base64Parser = base64Parser;
        this.step = step;
    }

    public Parser<V> feed(Input input) {
        return DataParser.parse(input, this.recon, this.base64Parser, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon, Parser<V> base64Parser, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (c != 37) return Parser.error((Diagnostic)Diagnostic.expected((int)37, (Input)input));
                input = input.step();
                step = 2;
            } else if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.expected((int)37, (Input)input));
            }
        }
        if (step == 2) {
            if (base64Parser == null) {
                base64Parser = Base64.standard().parse(input, recon.dataOutput());
            }
            while (base64Parser.isCont() && !input.isEmpty()) {
                base64Parser = base64Parser.feed(input);
            }
            if (base64Parser.isDone()) {
                return base64Parser;
            }
            if (base64Parser.isError()) {
                return base64Parser;
            }
        }
        if (!input.isError()) return new DataParser<I, V>(recon, base64Parser, step);
        return Parser.error((Throwable)input.trap());
    }

    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon) {
        return DataParser.parse(input, recon, null, 1);
    }
}

