/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.recon.ReconParser;

final class DecimalParser<I, V>
extends Parser<V> {
    final ReconParser<I, V> recon;
    final StringBuilder builder;
    final int mode;
    final int step;

    DecimalParser(ReconParser<I, V> recon, StringBuilder builder, int mode, int step) {
        this.recon = recon;
        this.builder = builder;
        this.mode = mode;
        this.step = step;
    }

    public Parser<V> feed(Input input) {
        return DecimalParser.parse(input, this.recon, this.builder, this.mode, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon, StringBuilder builder, int mode, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (c == 46) {
                    input = input.step();
                    builder.appendCodePoint(c);
                    step = 2;
                } else {
                    if (mode <= 1 || c != 69 && c != 101) return Parser.error((Diagnostic)Diagnostic.expected((String)"decimal or exponent", (Input)input));
                    input = input.step();
                    builder.appendCodePoint(c);
                    step = 5;
                }
            } else if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.expected((String)"decimal or exponent", (Input)input));
            }
        }
        if (step == 2) {
            if (input.isCont()) {
                c = input.head();
                if (c < 48 || c > 57) return Parser.error((Diagnostic)Diagnostic.expected((String)"digit", (Input)input));
                input = input.step();
                builder.appendCodePoint(c);
                step = 3;
            } else if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.expected((String)"digit", (Input)input));
            }
        }
        if (step == 3) {
            while (input.isCont() && (c = input.head()) >= 48 && c <= 57) {
                input = input.step();
                builder.appendCodePoint(c);
            }
            if (input.isCont()) {
                if (mode <= 1) return Parser.done(recon.num(builder.toString()));
                step = 4;
            } else if (input.isDone()) {
                return Parser.done(recon.num(builder.toString()));
            }
        }
        if (step == 4) {
            c = input.head();
            if (c != 69 && c != 101) return Parser.done(recon.num(builder.toString()));
            input = input.step();
            builder.appendCodePoint(c);
            step = 5;
        }
        if (step == 5) {
            if (input.isCont()) {
                c = input.head();
                if (c == 43 || c == 45) {
                    input = input.step();
                    builder.appendCodePoint(c);
                }
                step = 6;
            } else if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
            }
        }
        if (step == 6) {
            if (input.isCont()) {
                c = input.head();
                if (c < 48 || c > 57) return Parser.error((Diagnostic)Diagnostic.expected((String)"digit", (Input)input));
                input = input.step();
                builder.appendCodePoint(c);
                step = 7;
            } else if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.expected((String)"digit", (Input)input));
            }
        }
        if (step == 7) {
            while (input.isCont() && (c = input.head()) >= 48 && c <= 57) {
                input = input.step();
                builder.appendCodePoint(c);
            }
            if (!input.isEmpty()) {
                return Parser.done(recon.num(builder.toString()));
            }
        }
        if (!input.isError()) return new DecimalParser<I, V>(recon, builder, mode, step);
        return Parser.error((Throwable)input.trap());
    }

    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon, int sign, long value, int mode) {
        StringBuilder builder = new StringBuilder();
        if (sign < 0 && value == 0L) {
            builder.append('-').append('0');
        } else {
            builder.append(value);
        }
        return DecimalParser.parse(input, recon, builder, mode, 1);
    }
}

