/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import swim.codec.Base16;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.recon.ReconParser;

final class HexadecimalParser<I, V>
extends Parser<V> {
    final ReconParser<I, V> recon;
    final long value;
    final int size;

    HexadecimalParser(ReconParser<I, V> recon, long value, int size) {
        this.recon = recon;
        this.value = value;
        this.size = size;
    }

    public Parser<V> feed(Input input) {
        return HexadecimalParser.parse(input, this.recon, this.value, this.size);
    }

    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon, long value, int size) {
        int c = 0;
        while (input.isCont() && Base16.isDigit((int)(c = input.head()))) {
            input = input.step();
            value = value << 4 | (long)Base16.decodeDigit((int)c);
            ++size;
        }
        if (!input.isEmpty()) {
            if (size > 0) {
                if (size <= 8) {
                    return Parser.done(recon.uint32((int)value));
                }
                return Parser.done(recon.uint64(value));
            }
            return Parser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
        }
        if (input.isError()) {
            return Parser.error((Throwable)input.trap());
        }
        return new HexadecimalParser<I, V>(recon, value, size);
    }

    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon) {
        return HexadecimalParser.parse(input, recon, 0L, 0);
    }
}

