/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import swim.codec.Output;
import swim.codec.Utf8;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.recon.Recon;

final class IdentWriter
extends Writer<Object, Object> {
    final String ident;
    final int index;

    IdentWriter(String ident, int index) {
        this.ident = ident;
        this.index = index;
    }

    static int sizeOf(String ident) {
        return Utf8.sizeOf((String)ident);
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return IdentWriter.write(output, this.ident, this.index);
    }

    static Writer<Object, Object> write(Output<?> output, String ident, int index) {
        int c;
        int length = ident.length();
        if (length == 0) {
            return Writer.error((Throwable)new WriterException("empty identifier"));
        }
        if (index == 0 && output.isCont() && Recon.isIdentStartChar(c = ident.codePointAt(0))) {
            output = output.write(c);
            index = ident.offsetByCodePoints(0, 1);
        }
        while (index < length && output.isCont()) {
            c = ident.codePointAt(index);
            if (Recon.isIdentChar(c)) {
                output = output.write(c);
                index = ident.offsetByCodePoints(index, 1);
                continue;
            }
            return Writer.error((Throwable)new WriterException("invalid identifier"));
        }
        if (index >= length) {
            return Writer.done();
        }
        if (output.isDone()) {
            return Writer.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return Writer.error((Throwable)output.trap());
        }
        return new IdentWriter(ident, index);
    }

    static Writer<Object, Object> write(Output<?> output, String ident) {
        return IdentWriter.write(output, ident, 0);
    }
}

