/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import swim.codec.Input;
import swim.codec.Parser;
import swim.recon.ReconParser;
import swim.util.Builder;

final class LambdaFuncParser<I, V>
extends Parser<V> {
    final ReconParser<I, V> recon;
    final Builder<I, V> builder;
    final Parser<V> bindingsParser;
    final Parser<V> templateParser;
    final int step;

    LambdaFuncParser(ReconParser<I, V> recon, Builder<I, V> builder, Parser<V> bindingsParser, Parser<V> templateParser, int step) {
        this.recon = recon;
        this.builder = builder;
        this.bindingsParser = bindingsParser;
        this.templateParser = templateParser;
        this.step = step;
    }

    public Parser<V> feed(Input input) {
        return LambdaFuncParser.parse(input, this.recon, this.builder, this.bindingsParser, this.templateParser, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon, Builder<I, V> builder, Parser<V> bindingsParser, Parser<V> templateParser, int step) {
        int c = 0;
        if (step == 1) {
            if (bindingsParser == null) {
                bindingsParser = recon.parseConditionalOperator(input, builder);
            }
            while (bindingsParser.isCont() && !input.isEmpty()) {
                bindingsParser = bindingsParser.feed(input);
            }
            if (bindingsParser.isDone()) {
                step = 2;
            } else if (bindingsParser.isError()) {
                return bindingsParser.asError();
            }
        }
        if (step == 2) {
            if (input.isCont()) {
                c = input.head();
                if (c != 62) return bindingsParser;
                input = input.step();
                step = 3;
            } else if (input.isDone()) {
                return bindingsParser;
            }
        }
        if (step == 3) {
            if (templateParser == null) {
                templateParser = recon.parseConditionalOperator(input, null);
            }
            while (templateParser.isCont() && !input.isEmpty()) {
                templateParser = templateParser.feed(input);
            }
            if (templateParser.isDone()) {
                Object bindings = bindingsParser.bind();
                Object template = templateParser.bind();
                return Parser.done((Object)recon.lambda(bindings, template));
            }
            if (templateParser.isError()) {
                return templateParser.asError();
            }
        }
        if (!input.isError()) return new LambdaFuncParser(recon, builder, bindingsParser, templateParser, step);
        return Parser.error((Throwable)input.trap());
    }

    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon, Builder<I, V> builder) {
        return LambdaFuncParser.parse(input, recon, builder, null, null, 1);
    }
}

