/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.recon.Recon;
import swim.recon.ReconParser;
import swim.util.Builder;

final class LiteralParser<I, V>
extends Parser<V> {
    final ReconParser<I, V> recon;
    final Builder<I, V> builder;
    final Parser<V> valueParser;
    final int step;

    LiteralParser(ReconParser<I, V> recon, Builder<I, V> builder, Parser<V> valueParser, int step) {
        this.recon = recon;
        this.builder = builder;
        this.valueParser = valueParser;
        this.step = step;
    }

    public Parser<V> feed(Input input) {
        return LiteralParser.parse(input, this.recon, this.builder, this.valueParser, this.step);
    }

    /*
     * Enabled aggressive block sorting
     */
    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon, Builder<I, V> builder, Parser<V> valueParser, int step) {
        int c;
        block32: {
            block33: {
                block40: {
                    block39: {
                        block38: {
                            block37: {
                                block36: {
                                    block35: {
                                        block34: {
                                            c = 0;
                                            if (step != 1) break block32;
                                            while (input.isCont() && Recon.isSpace(c = input.head())) {
                                                input = input.step();
                                            }
                                            if (!input.isCont()) break block33;
                                            if (c != 40) break block34;
                                            input = input.step();
                                            step = 4;
                                            break block32;
                                        }
                                        if (c != 123) break block35;
                                        if (builder == null) {
                                            builder = recon.recordBuilder();
                                        }
                                        valueParser = recon.parseRecord(input, (Builder<I, Object>)builder);
                                        step = 3;
                                        break block32;
                                    }
                                    if (c != 91) break block36;
                                    if (builder == null) {
                                        builder = recon.recordBuilder();
                                    }
                                    valueParser = recon.parseMarkup(input, (Builder<I, Object>)builder);
                                    step = 3;
                                    break block32;
                                }
                                if (!Recon.isIdentStartChar(c)) break block37;
                                valueParser = recon.parseIdent(input);
                                step = 2;
                                break block32;
                            }
                            if (c != 34 && c != 39) break block38;
                            valueParser = recon.parseString(input);
                            step = 2;
                            break block32;
                        }
                        if (c != 96) break block39;
                        valueParser = recon.parseRawString(input);
                        step = 2;
                        break block32;
                    }
                    if (c != 45 && (c < 48 || c > 57)) break block40;
                    valueParser = recon.parseNumber(input);
                    step = 2;
                    break block32;
                }
                if (c == 37) {
                    valueParser = recon.parseData(input);
                    step = 2;
                    break block32;
                } else if (c == 36) {
                    valueParser = recon.parseSelector(input);
                    step = 2;
                    break block32;
                } else {
                    if (builder == null) {
                        return Parser.done((Object)recon.extant());
                    }
                    return Parser.done((Object)builder.bind());
                }
            }
            if (input.isDone()) {
                if (builder == null) {
                    return Parser.done((Object)recon.extant());
                }
                return Parser.done((Object)builder.bind());
            }
        }
        if (step == 2) {
            while (valueParser.isCont() && !input.isEmpty()) {
                valueParser = valueParser.feed(input);
            }
            if (valueParser.isDone()) {
                if (builder == null) {
                    builder = recon.valueBuilder();
                }
                builder.add(recon.item(valueParser.bind()));
                return Parser.done((Object)builder.bind());
            }
            if (valueParser.isError()) {
                return valueParser.asError();
            }
        }
        if (step == 3) {
            while (valueParser.isCont() && !input.isEmpty()) {
                valueParser = valueParser.feed(input);
            }
            if (valueParser.isDone()) {
                return Parser.done((Object)builder.bind());
            }
            if (valueParser.isError()) {
                return valueParser.asError();
            }
        }
        if (step == 4) {
            if (valueParser == null) {
                valueParser = recon.parseBlockExpression(input);
            }
            while (valueParser.isCont() && !input.isEmpty()) {
                valueParser = valueParser.feed(input);
            }
            if (valueParser.isDone()) {
                step = 5;
            } else if (valueParser.isError()) {
                return valueParser.asError();
            }
        }
        if (step == 5) {
            while (input.isCont() && Recon.isWhitespace(c = input.head())) {
                input = input.step();
            }
            if (input.isCont()) {
                if (c != 41) {
                    return Parser.error((Diagnostic)Diagnostic.expected((int)41, (Input)input));
                }
                input = input.step();
                if (builder == null) {
                    builder = recon.valueBuilder();
                }
                builder.add(recon.item(valueParser.bind()));
                return Parser.done((Object)builder.bind());
            }
            if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.expected((int)41, (Input)input));
            }
        }
        if (input.isError()) {
            return Parser.error((Throwable)input.trap());
        }
        return new LiteralParser<I, Object>(recon, builder, valueParser, step);
    }

    static <I, V> Parser<V> parse(Input input, ReconParser<I, V> recon, Builder<I, V> builder) {
        return LiteralParser.parse(input, recon, builder, null, 1);
    }
}

