/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import swim.codec.Output;
import swim.codec.Writer;
import swim.recon.ReconWriter;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;

final class ReconFormWriter<T>
extends Writer<T, T> {
    final ReconWriter<Item, Value> recon;
    final Form<T> form;
    final T object;
    final Writer<?, ?> part;

    ReconFormWriter(ReconWriter<Item, Value> recon, Form<T> form, T object, Writer<?, ?> part) {
        this.recon = recon;
        this.form = form;
        this.object = object;
        this.part = part;
    }

    ReconFormWriter(ReconWriter<Item, Value> recon, Form<T> form) {
        this(recon, form, null, null);
    }

    public Writer<T, T> feed(T object) {
        return new ReconFormWriter<T>(this.recon, this.form, object, null);
    }

    public Writer<T, T> pull(Output<?> output) {
        return ReconFormWriter.write(output, this.recon, this.form, this.object, this.part);
    }

    static <T> Writer<T, T> write(Output<?> output, ReconWriter<Item, Value> recon, Form<T> form, T object, Writer<?, ?> part) {
        if (output == null) {
            return Writer.done();
        }
        if (part == null) {
            Value value = form.mold(object).toValue();
            part = recon.writeValue(output, value);
        } else {
            part = part.pull(output);
        }
        if (part.isDone()) {
            return Writer.done(object);
        }
        if (part.isError()) {
            return part.asError();
        }
        return new ReconFormWriter<T>(recon, form, object, part);
    }

    static <T> Writer<T, T> write(Output<T> output, ReconWriter<Item, Value> recon, Form<T> form, T object) {
        return ReconFormWriter.write(output, recon, form, object, null);
    }
}

