/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import java.util.Iterator;
import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.recon.ReconWriter;
import swim.structure.Absent;
import swim.structure.Attr;
import swim.structure.Bool;
import swim.structure.Data;
import swim.structure.Expression;
import swim.structure.Extant;
import swim.structure.Field;
import swim.structure.Func;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Operator;
import swim.structure.Record;
import swim.structure.Selector;
import swim.structure.Slot;
import swim.structure.Text;
import swim.structure.Value;
import swim.structure.func.BridgeFunc;
import swim.structure.func.LambdaFunc;
import swim.structure.operator.BinaryOperator;
import swim.structure.operator.ConditionalOperator;
import swim.structure.operator.InvokeOperator;
import swim.structure.operator.UnaryOperator;
import swim.structure.selector.ChildrenSelector;
import swim.structure.selector.DescendantsSelector;
import swim.structure.selector.FilterSelector;
import swim.structure.selector.GetAttrSelector;
import swim.structure.selector.GetItemSelector;
import swim.structure.selector.GetSelector;
import swim.structure.selector.IdentitySelector;
import swim.structure.selector.KeysSelector;
import swim.structure.selector.LiteralSelector;
import swim.structure.selector.ValuesSelector;

public class ReconStructureWriter
extends ReconWriter<Item, Value> {
    @Override
    public boolean isField(Item item) {
        return item instanceof Field;
    }

    @Override
    public boolean isAttr(Item item) {
        return item instanceof Attr;
    }

    @Override
    public boolean isSlot(Item item) {
        return item instanceof Slot;
    }

    @Override
    public boolean isValue(Item item) {
        return item instanceof Value;
    }

    @Override
    public boolean isRecord(Item item) {
        return item instanceof Record;
    }

    @Override
    public boolean isText(Item item) {
        return item instanceof Text;
    }

    @Override
    public boolean isNum(Item item) {
        return item instanceof Num;
    }

    @Override
    public boolean isBool(Item item) {
        return item instanceof Bool;
    }

    @Override
    public boolean isExpression(Item item) {
        return item instanceof Expression;
    }

    @Override
    public boolean isExtant(Item item) {
        return item instanceof Extant;
    }

    @Override
    public Iterator<Item> items(Item item) {
        return item.iterator();
    }

    @Override
    public Item item(Value value) {
        return value;
    }

    @Override
    public Value key(Item item) {
        return item.key();
    }

    @Override
    public Value value(Item item) {
        return item.toValue();
    }

    @Override
    public String string(Item item) {
        return item.stringValue();
    }

    @Override
    public int precedence(Item item) {
        return item.precedence();
    }

    @Override
    public int sizeOfItem(Item item) {
        if (item instanceof Field) {
            if (item instanceof Attr) {
                Attr that = (Attr)item;
                return this.sizeOfAttr(that.key(), that.value());
            }
            if (item instanceof Slot) {
                Slot that = (Slot)item;
                return this.sizeOfSlot(that.key(), that.value());
            }
        } else if (item instanceof Value) {
            return this.sizeOfValue((Value)item);
        }
        throw new WriterException("No Recon serialization for " + item);
    }

    @Override
    public Writer<?, ?> writeItem(Output<?> output, Item item) {
        if (item instanceof Field) {
            if (item instanceof Attr) {
                Attr that = (Attr)item;
                return this.writeAttr(output, that.key(), that.value());
            }
            if (item instanceof Slot) {
                Slot that = (Slot)item;
                return this.writeSlot(output, that.key(), that.value());
            }
        } else if (item instanceof Value) {
            return this.writeValue(output, (Value)item);
        }
        return Writer.error((Throwable)new WriterException("No Recon serialization for " + item));
    }

    @Override
    public int sizeOfValue(Value value) {
        if (value instanceof Record) {
            Record that = (Record)value;
            return this.sizeOfRecord(that);
        }
        if (value instanceof Data) {
            Data that = (Data)value;
            return this.sizeOfData(that.size());
        }
        if (value instanceof Text) {
            Text that = (Text)value;
            return this.sizeOfText(that.stringValue());
        }
        if (value instanceof Num) {
            Num that = (Num)value;
            if (that.isUint32()) {
                return this.sizeOfUint32(that.intValue());
            }
            if (that.isUint64()) {
                return this.sizeOfUint64(that.longValue());
            }
            if (that.isValidInt()) {
                return this.sizeOfNum(that.intValue());
            }
            if (that.isValidLong()) {
                return this.sizeOfNum(that.longValue());
            }
            if (that.isValidFloat()) {
                return this.sizeOfNum(that.floatValue());
            }
            if (that.isValidDouble()) {
                return this.sizeOfNum(that.doubleValue());
            }
            if (that.isValidInteger()) {
                return this.sizeOfNum(that.integerValue());
            }
        } else {
            if (value instanceof Bool) {
                Bool that = (Bool)value;
                return this.sizeOfBool(that.booleanValue());
            }
            if (value instanceof Selector) {
                return this.sizeOfSelector((Selector)value);
            }
            if (value instanceof Operator) {
                return this.sizeOfOperator((Operator)value);
            }
            if (value instanceof Func) {
                return this.sizeOfFunc((Func)value);
            }
            if (value instanceof Extant) {
                return this.sizeOfExtant();
            }
            if (value instanceof Absent) {
                return this.sizeOfAbsent();
            }
        }
        throw new WriterException("No Recon serialization for " + value);
    }

    @Override
    public Writer<?, ?> writeValue(Output<?> output, Value value) {
        if (value instanceof Record) {
            Record that = (Record)value;
            return this.writeRecord(output, that);
        }
        if (value instanceof Data) {
            Data that = (Data)value;
            return this.writeData(output, that.asByteBuffer());
        }
        if (value instanceof Text) {
            Text that = (Text)value;
            return this.writeText(output, that.stringValue());
        }
        if (value instanceof Num) {
            Num that = (Num)value;
            if (that.isUint32()) {
                return this.writeUint32(output, that.intValue());
            }
            if (that.isUint64()) {
                return this.writeUint64(output, that.longValue());
            }
            if (that.isValidInt()) {
                return this.writeNum(output, that.intValue());
            }
            if (that.isValidLong()) {
                return this.writeNum(output, that.longValue());
            }
            if (that.isValidFloat()) {
                return this.writeNum(output, that.floatValue());
            }
            if (that.isValidDouble()) {
                return this.writeNum(output, that.doubleValue());
            }
            if (that.isValidInteger()) {
                return this.writeNum(output, that.integerValue());
            }
        } else {
            if (value instanceof Bool) {
                Bool that = (Bool)value;
                return this.writeBool(output, that.booleanValue());
            }
            if (value instanceof Selector) {
                return this.writeSelector(output, (Selector)value);
            }
            if (value instanceof Operator) {
                return this.writeOperator(output, (Operator)value);
            }
            if (value instanceof Func) {
                return this.writeFunc(output, (Func)value);
            }
            if (value instanceof Extant) {
                return this.writeExtant(output);
            }
            if (value instanceof Absent) {
                return this.writeAbsent(output);
            }
        }
        return Writer.error((Throwable)new WriterException("No Recon serialization for " + value));
    }

    public int sizeOfSelector(Selector selector) {
        if (selector instanceof IdentitySelector) {
            return this.sizeOfIdentitySelector();
        }
        if (selector instanceof LiteralSelector) {
            LiteralSelector that = (LiteralSelector)selector;
            return this.sizeOfLiteralSelector(that.item(), that.then());
        }
        if (selector instanceof GetSelector) {
            GetSelector that = (GetSelector)selector;
            return this.sizeOfGetSelector(that.accessor(), that.then());
        }
        if (selector instanceof GetAttrSelector) {
            GetAttrSelector that = (GetAttrSelector)selector;
            return this.sizeOfGetAttrSelector(that.accessor(), that.then());
        }
        if (selector instanceof GetItemSelector) {
            GetItemSelector that = (GetItemSelector)selector;
            return this.sizeOfGetItemSelector(that.accessor(), that.then());
        }
        if (selector instanceof KeysSelector) {
            KeysSelector that = (KeysSelector)selector;
            return this.sizeOfKeysSelector(that.then());
        }
        if (selector instanceof ValuesSelector) {
            ValuesSelector that = (ValuesSelector)selector;
            return this.sizeOfValuesSelector(that.then());
        }
        if (selector instanceof ChildrenSelector) {
            ChildrenSelector that = (ChildrenSelector)selector;
            return this.sizeOfChildrenSelector(that.then());
        }
        if (selector instanceof DescendantsSelector) {
            DescendantsSelector that = (DescendantsSelector)selector;
            return this.sizeOfDescendantsSelector(that.then());
        }
        if (selector instanceof FilterSelector) {
            FilterSelector that = (FilterSelector)selector;
            return this.sizeOfFilterSelector(that.predicate(), that.then());
        }
        throw new WriterException("No Recon serialization for " + selector);
    }

    public Writer<?, ?> writeSelector(Output<?> output, Selector selector) {
        if (selector instanceof IdentitySelector) {
            return this.writeIdentitySelector(output);
        }
        if (selector instanceof LiteralSelector) {
            LiteralSelector that = (LiteralSelector)selector;
            return this.writeLiteralSelector(output, that.item(), that.then());
        }
        if (selector instanceof GetSelector) {
            GetSelector that = (GetSelector)selector;
            return this.writeGetSelector(output, that.accessor(), that.then());
        }
        if (selector instanceof GetAttrSelector) {
            GetAttrSelector that = (GetAttrSelector)selector;
            return this.writeGetAttrSelector(output, that.accessor(), that.then());
        }
        if (selector instanceof GetItemSelector) {
            GetItemSelector that = (GetItemSelector)selector;
            return this.writeGetItemSelector(output, that.accessor(), that.then());
        }
        if (selector instanceof KeysSelector) {
            KeysSelector that = (KeysSelector)selector;
            return this.writeKeysSelector(output, that.then());
        }
        if (selector instanceof ValuesSelector) {
            ValuesSelector that = (ValuesSelector)selector;
            return this.writeValuesSelector(output, that.then());
        }
        if (selector instanceof ChildrenSelector) {
            ChildrenSelector that = (ChildrenSelector)selector;
            return this.writeChildrenSelector(output, that.then());
        }
        if (selector instanceof DescendantsSelector) {
            DescendantsSelector that = (DescendantsSelector)selector;
            return this.writeDescendantsSelector(output, that.then());
        }
        if (selector instanceof FilterSelector) {
            FilterSelector that = (FilterSelector)selector;
            return this.writeFilterSelector(output, that.predicate(), that.then());
        }
        return Writer.error((Throwable)new WriterException("No Recon serialization for " + selector));
    }

    public int sizeOfOperator(Operator operator) {
        if (operator instanceof BinaryOperator) {
            BinaryOperator that = (BinaryOperator)operator;
            return this.sizeOfInfixOperator(that.lhs(), that.operator(), that.rhs(), that.precedence());
        }
        if (operator instanceof UnaryOperator) {
            UnaryOperator that = (UnaryOperator)operator;
            return this.sizeOfPrefixOperator(that.operator(), that.operand(), that.precedence());
        }
        if (operator instanceof InvokeOperator) {
            InvokeOperator that = (InvokeOperator)operator;
            return this.sizeOfInvokeOperator(that.func(), that.args());
        }
        if (operator instanceof ConditionalOperator) {
            ConditionalOperator that = (ConditionalOperator)operator;
            return this.sizeOfConditionalOperator(that.ifTerm(), that.thenTerm(), that.elseTerm(), that.precedence());
        }
        throw new WriterException("No Recon serialization for " + operator);
    }

    public Writer<?, ?> writeOperator(Output<?> output, Operator operator) {
        if (operator instanceof BinaryOperator) {
            BinaryOperator that = (BinaryOperator)operator;
            return this.writeInfixOperator(output, that.lhs(), that.operator(), that.rhs(), that.precedence());
        }
        if (operator instanceof UnaryOperator) {
            UnaryOperator that = (UnaryOperator)operator;
            return this.writePrefixOperator(output, that.operator(), that.operand(), that.precedence());
        }
        if (operator instanceof InvokeOperator) {
            InvokeOperator that = (InvokeOperator)operator;
            return this.writeInvokeOperator(output, that.func(), that.args());
        }
        if (operator instanceof ConditionalOperator) {
            ConditionalOperator that = (ConditionalOperator)operator;
            return this.writeConditionalOperator(output, that.ifTerm(), that.thenTerm(), that.elseTerm(), that.precedence());
        }
        return Writer.error((Throwable)new WriterException("No Recon serialization for " + operator));
    }

    public int sizeOfFunc(Func func) {
        if (func instanceof LambdaFunc) {
            LambdaFunc that = (LambdaFunc)func;
            return this.sizeOfLambdaFunc(that.bindings(), that.template());
        }
        if (func instanceof BridgeFunc) {
            return 0;
        }
        throw new WriterException("No Recon serialization for " + func);
    }

    public Writer<?, ?> writeFunc(Output<?> output, Func func) {
        if (func instanceof LambdaFunc) {
            LambdaFunc that = (LambdaFunc)func;
            return this.writeLambdaFunc(output, that.bindings(), that.template());
        }
        if (func instanceof BridgeFunc) {
            return Writer.done();
        }
        return Writer.error((Throwable)new WriterException("No Recon serialization for " + func));
    }

    @Override
    public int sizeOfBlockItem(Item item) {
        if (item instanceof Field) {
            return this.sizeOfItem(item);
        }
        if (item instanceof Value) {
            return this.sizeOfBlockValue((Value)item);
        }
        throw new WriterException("No Recon serialization for " + item);
    }

    @Override
    public Writer<?, ?> writeBlockItem(Output<?> output, Item item) {
        if (item instanceof Field) {
            return this.writeItem(output, item);
        }
        if (item instanceof Value) {
            return this.writeBlockValue(output, (Value)item);
        }
        return Writer.error((Throwable)new WriterException("No Recon serialization for " + item));
    }

    @Override
    public int sizeOfBlockValue(Value value) {
        if (value instanceof Record) {
            return this.sizeOfBlock((Record)value);
        }
        return this.sizeOfValue(value);
    }

    @Override
    public Writer<?, ?> writeBlockValue(Output<?> output, Value value) {
        if (value instanceof Record) {
            return this.writeBlock(output, (Record)value);
        }
        return this.writeValue(output, value);
    }

    @Override
    public int sizeOfThen(Value then) {
        if (then instanceof Selector) {
            Selector selector = (Selector)then;
            if (selector instanceof IdentitySelector) {
                return this.sizeOfThenIdentitySelector();
            }
            if (selector instanceof LiteralSelector) {
                LiteralSelector that = (LiteralSelector)selector;
                return this.sizeOfThenLiteralSelector(that.item(), that.then());
            }
            if (selector instanceof GetSelector) {
                GetSelector that = (GetSelector)selector;
                return this.sizeOfThenGetSelector(that.accessor(), that.then());
            }
            if (selector instanceof GetAttrSelector) {
                GetAttrSelector that = (GetAttrSelector)selector;
                return this.sizeOfThenGetAttrSelector(that.accessor(), that.then());
            }
            if (selector instanceof GetItemSelector) {
                GetItemSelector that = (GetItemSelector)selector;
                return this.sizeOfThenGetItemSelector(that.accessor(), that.then());
            }
            if (selector instanceof KeysSelector) {
                KeysSelector that = (KeysSelector)selector;
                return this.sizeOfThenKeysSelector(that.then());
            }
            if (selector instanceof ValuesSelector) {
                ValuesSelector that = (ValuesSelector)selector;
                return this.sizeOfThenValuesSelector(that.then());
            }
            if (selector instanceof ChildrenSelector) {
                ChildrenSelector that = (ChildrenSelector)selector;
                return this.sizeOfThenChildrenSelector(that.then());
            }
            if (selector instanceof DescendantsSelector) {
                DescendantsSelector that = (DescendantsSelector)selector;
                return this.sizeOfThenDescendantsSelector(that.then());
            }
            if (selector instanceof FilterSelector) {
                FilterSelector that = (FilterSelector)selector;
                return this.sizeOfThenFilterSelector(that.predicate(), that.then());
            }
        }
        throw new WriterException("No Recon serialization for " + then);
    }

    @Override
    public Writer<?, ?> writeThen(Output<?> output, Value then) {
        if (then instanceof Selector) {
            Selector selector = (Selector)then;
            if (selector instanceof IdentitySelector) {
                return this.writeThenIdentitySelector(output);
            }
            if (selector instanceof LiteralSelector) {
                LiteralSelector that = (LiteralSelector)selector;
                return this.writeThenLiteralSelector(output, that.item(), that.then());
            }
            if (selector instanceof GetSelector) {
                GetSelector that = (GetSelector)selector;
                return this.writeThenGetSelector(output, that.accessor(), that.then());
            }
            if (selector instanceof GetAttrSelector) {
                GetAttrSelector that = (GetAttrSelector)selector;
                return this.writeThenGetAttrSelector(output, that.accessor(), that.then());
            }
            if (selector instanceof GetItemSelector) {
                GetItemSelector that = (GetItemSelector)selector;
                return this.writeThenGetItemSelector(output, that.accessor(), that.then());
            }
            if (selector instanceof KeysSelector) {
                KeysSelector that = (KeysSelector)selector;
                return this.writeThenKeysSelector(output, that.then());
            }
            if (selector instanceof ValuesSelector) {
                ValuesSelector that = (ValuesSelector)selector;
                return this.writeThenValuesSelector(output, that.then());
            }
            if (selector instanceof ChildrenSelector) {
                ChildrenSelector that = (ChildrenSelector)selector;
                return this.writeThenChildrenSelector(output, that.then());
            }
            if (selector instanceof DescendantsSelector) {
                DescendantsSelector that = (DescendantsSelector)selector;
                return this.writeThenDescendantsSelector(output, that.then());
            }
            if (selector instanceof FilterSelector) {
                FilterSelector that = (FilterSelector)selector;
                return this.writeThenFilterSelector(output, that.predicate(), that.then());
            }
        }
        return Writer.error((Throwable)new WriterException("No Recon serialization for " + then));
    }
}

