/*
 * Decompiled with CFR 0.152.
 */
package swim.remote;

import swim.concurrent.Cont;
import swim.concurrent.PullContext;
import swim.concurrent.PullRequest;
import swim.concurrent.Stay;
import swim.concurrent.StayContext;
import swim.remote.RemoteHost;
import swim.warp.CommandMessage;
import swim.warp.Envelope;
import swim.warp.EventMessage;

final class RemoteHostPull<E extends Envelope>
implements PullRequest<E> {
    final RemoteHost host;
    final float prio;
    final E envelope;
    final Cont<E> cont;

    RemoteHostPull(RemoteHost host, float prio, E envelope, Cont<E> cont) {
        this.host = host;
        this.prio = prio;
        this.envelope = envelope;
        this.cont = cont;
    }

    public float prio() {
        return this.prio;
    }

    public void pull(PullContext<? super E> context) {
        Throwable failure = null;
        E envelope = this.envelope;
        try {
            context.push(this.envelope);
            if (envelope instanceof EventMessage) {
                RemoteHost.DOWNLINK_EVENT_DELTA.incrementAndGet(this.host);
                this.host.didUpdateMetrics();
            } else if (envelope instanceof CommandMessage) {
                RemoteHost.UPLINK_COMMAND_DELTA.incrementAndGet(this.host);
                this.host.didUpdateMetrics();
            }
        }
        catch (Throwable cause) {
            if (!Cont.isNonFatal((Throwable)cause)) {
                throw cause;
            }
            failure = cause;
        }
        if (this.cont != null) {
            if (failure == null) {
                this.cont.bind(envelope);
            } else {
                this.cont.trap(failure);
            }
        }
        if (failure instanceof RuntimeException) {
            throw (RuntimeException)failure;
        }
        if (failure instanceof Error) {
            throw (Error)failure;
        }
    }

    public void drop(Throwable reason) {
        if (this.cont != null) {
            this.cont.trap(reason);
        }
    }

    public boolean stay(StayContext context, int backlog) {
        if (this.cont instanceof Stay) {
            return ((Stay)this.cont).stay((StayContext)this.host, backlog);
        }
        return backlog < RemoteHost.MAX_SEND_BACKLOG;
    }
}

