/*
 * Decompiled with CFR 0.152.
 */
package swim.remote;

import swim.io.IpInterface;
import swim.io.IpSettings;
import swim.io.http.HttpSettings;
import swim.io.warp.WarpSettings;
import swim.io.ws.WsSettings;
import swim.kernel.KernelProxy;
import swim.remote.RemoteHostClient;
import swim.structure.Item;
import swim.structure.Value;
import swim.system.HostAddress;
import swim.system.HostBinding;
import swim.system.HostDef;
import swim.system.PartBinding;
import swim.uri.Uri;

public class RemoteKernel
extends KernelProxy {
    final double kernelPriority;
    WarpSettings warpSettings;
    private static final double KERNEL_PRIORITY = 0.25;

    public RemoteKernel(double kernelPriority, WarpSettings warpSettings) {
        this.kernelPriority = kernelPriority;
        this.warpSettings = warpSettings;
    }

    public RemoteKernel(double kernelPriority) {
        this(kernelPriority, null);
    }

    public RemoteKernel() {
        this(0.25);
    }

    public final double kernelPriority() {
        return this.kernelPriority;
    }

    public HttpSettings httpSettings() {
        return HttpSettings.create((IpSettings)this.ipSettings());
    }

    public WsSettings wsSettings() {
        return WsSettings.create((HttpSettings)this.httpSettings());
    }

    public final WarpSettings warpSettings() {
        if (this.warpSettings == null) {
            this.warpSettings = WarpSettings.create((WsSettings)this.wsSettings());
        }
        return this.warpSettings;
    }

    public HostBinding createHost(HostAddress hostAddress) {
        if (hostAddress.hostUri().host().isDefined() && !"swim".equals(hostAddress.partKey().stringValue(null))) {
            IpInterface endpoint = (IpInterface)this.kernelWrapper().unwrapKernel(IpInterface.class);
            return new RemoteHostClient(hostAddress.hostUri(), endpoint, this.warpSettings());
        }
        return super.createHost(hostAddress);
    }

    public HostBinding createHost(PartBinding part, HostDef hostDef) {
        Uri hostUri = hostDef.hostUri();
        if (hostUri != null && hostUri.host().isDefined() && !"swim".equals(part.partKey().stringValue(null))) {
            IpInterface endpoint = (IpInterface)this.kernelWrapper().unwrapKernel(IpInterface.class);
            return new RemoteHostClient(hostUri, endpoint, this.warpSettings());
        }
        return super.createHost(part, hostDef);
    }

    public static RemoteKernel fromValue(Value moduleConfig) {
        Value header = moduleConfig.getAttr("kernel");
        String kernelClassName = header.get("class").stringValue(null);
        if (kernelClassName == null || RemoteKernel.class.getName().equals(kernelClassName)) {
            double kernelPriority = header.get("priority").doubleValue(0.25);
            WarpSettings warpSettings = (WarpSettings)WarpSettings.form().cast((Item)moduleConfig);
            return new RemoteKernel(kernelPriority, warpSettings);
        }
        return null;
    }
}

