/*
 * Decompiled with CFR 0.152.
 */
package swim.remote;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.Downlink;
import swim.api.auth.Credentials;
import swim.api.auth.Identity;
import swim.api.lane.DemandLane;
import swim.api.policy.Policy;
import swim.api.policy.PolicyDirective;
import swim.collections.FingerTrieSeq;
import swim.collections.HashTrieMap;
import swim.collections.HashTrieSet;
import swim.concurrent.Cont;
import swim.concurrent.PullRequest;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.concurrent.StayContext;
import swim.http.Cookie;
import swim.http.HttpRequest;
import swim.http.HttpResponse;
import swim.io.FlowModifier;
import swim.io.IpSocket;
import swim.io.warp.WarpSocket;
import swim.io.warp.WarpSocketContext;
import swim.remote.RemoteCredentials;
import swim.remote.RemoteHostMessageCont;
import swim.remote.RemoteHostPull;
import swim.remote.RemoteHostPulseController;
import swim.remote.RemoteWarpDownlink;
import swim.remote.RemoteWarpUplink;
import swim.remote.Unauthenticated;
import swim.store.StoreBinding;
import swim.structure.Item;
import swim.structure.Text;
import swim.structure.Value;
import swim.system.AbstractTierBinding;
import swim.system.HostAddress;
import swim.system.HostBinding;
import swim.system.HostContext;
import swim.system.HostException;
import swim.system.LaneBinding;
import swim.system.LinkBinding;
import swim.system.LinkContext;
import swim.system.Metric;
import swim.system.NodeBinding;
import swim.system.PartBinding;
import swim.system.Push;
import swim.system.TierContext;
import swim.system.UplinkError;
import swim.system.WarpBinding;
import swim.system.WarpContext;
import swim.system.agent.AgentNode;
import swim.system.profile.HostProfile;
import swim.system.reflect.AgentPulse;
import swim.system.reflect.HostPulse;
import swim.system.reflect.SystemPulse;
import swim.system.reflect.WarpDownlinkPulse;
import swim.system.reflect.WarpUplinkPulse;
import swim.uri.Uri;
import swim.uri.UriAuthority;
import swim.uri.UriFragment;
import swim.uri.UriHost;
import swim.uri.UriMapper;
import swim.uri.UriPath;
import swim.uri.UriPort;
import swim.uri.UriQuery;
import swim.uri.UriScheme;
import swim.util.HashGenCacheMap;
import swim.warp.AuthRequest;
import swim.warp.AuthedResponse;
import swim.warp.CommandMessage;
import swim.warp.DeauthRequest;
import swim.warp.DeauthedResponse;
import swim.warp.Envelope;
import swim.warp.EventMessage;
import swim.warp.LaneAddressed;
import swim.warp.LinkAddressed;
import swim.warp.LinkRequest;
import swim.warp.LinkedResponse;
import swim.warp.SyncRequest;
import swim.warp.SyncedResponse;
import swim.warp.UnlinkRequest;
import swim.warp.UnlinkedResponse;
import swim.ws.WsCloseFrame;
import swim.ws.WsControlFrame;
import swim.ws.WsPingFrame;
import swim.ws.WsPongFrame;

public class RemoteHost
extends AbstractTierBinding
implements HostBinding,
WarpSocket,
StayContext {
    protected HostContext hostContext = null;
    protected WarpSocketContext warpSocketContext = null;
    final Uri requestUri;
    final Uri baseUri;
    final HashTrieMap<String, Cookie> cookies;
    Uri remoteUri;
    volatile int flags;
    volatile Identity remoteIdentity;
    volatile HashTrieMap<Uri, HashTrieMap<Uri, RemoteWarpDownlink>> downlinks;
    volatile HashTrieMap<Uri, HashTrieMap<Uri, HashTrieSet<RemoteWarpUplink>>> uplinks;
    volatile int receiveBacklog;
    RemoteHostMessageCont messageCont;
    final HashGenCacheMap<Uri, Uri> resolveCache;
    volatile int downlinkOpenDelta;
    volatile long downlinkOpenCount;
    volatile int downlinkCloseDelta;
    volatile long downlinkCloseCount;
    volatile int downlinkEventDelta;
    volatile long downlinkEventCount;
    volatile int downlinkCommandDelta;
    volatile long downlinkCommandCount;
    volatile int uplinkOpenDelta;
    volatile long uplinkOpenCount;
    volatile int uplinkCloseDelta;
    volatile long uplinkCloseCount;
    volatile int uplinkEventDelta;
    volatile long uplinkEventCount;
    volatile int uplinkCommandDelta;
    volatile long uplinkCommandCount;
    volatile long lastReportTime;
    HostPulse pulse;
    AgentNode metaNode;
    DemandLane<HostPulse> metaPulse;
    static final int PRIMARY = 1;
    static final int REPLICA = 2;
    static final int MASTER = 4;
    static final int SLAVE = 8;
    static final int MAX_SEND_BACKLOG;
    static final int MAX_RECEIVE_BACKLOG;
    static final int URI_RESOLUTION_CACHE_SIZE;
    static final AtomicIntegerFieldUpdater<RemoteHost> FLAGS;
    static final AtomicReferenceFieldUpdater<RemoteHost, Identity> REMOTE_IDENTITY;
    static final AtomicIntegerFieldUpdater<RemoteHost> RECEIVE_BACKLOG;
    static final AtomicReferenceFieldUpdater<RemoteHost, HashTrieMap<Uri, HashTrieMap<Uri, RemoteWarpDownlink>>> DOWNLINKS;
    static final AtomicReferenceFieldUpdater<RemoteHost, HashTrieMap<Uri, HashTrieMap<Uri, HashTrieSet<RemoteWarpUplink>>>> UPLINKS;
    static final AtomicIntegerFieldUpdater<RemoteHost> DOWNLINK_OPEN_DELTA;
    static final AtomicLongFieldUpdater<RemoteHost> DOWNLINK_OPEN_COUNT;
    static final AtomicIntegerFieldUpdater<RemoteHost> DOWNLINK_CLOSE_DELTA;
    static final AtomicLongFieldUpdater<RemoteHost> DOWNLINK_CLOSE_COUNT;
    static final AtomicIntegerFieldUpdater<RemoteHost> DOWNLINK_EVENT_DELTA;
    static final AtomicLongFieldUpdater<RemoteHost> DOWNLINK_EVENT_COUNT;
    static final AtomicIntegerFieldUpdater<RemoteHost> DOWNLINK_COMMAND_DELTA;
    static final AtomicLongFieldUpdater<RemoteHost> DOWNLINK_COMMAND_COUNT;
    static final AtomicIntegerFieldUpdater<RemoteHost> UPLINK_OPEN_DELTA;
    static final AtomicLongFieldUpdater<RemoteHost> UPLINK_OPEN_COUNT;
    static final AtomicIntegerFieldUpdater<RemoteHost> UPLINK_CLOSE_DELTA;
    static final AtomicLongFieldUpdater<RemoteHost> UPLINK_CLOSE_COUNT;
    static final AtomicIntegerFieldUpdater<RemoteHost> UPLINK_EVENT_DELTA;
    static final AtomicLongFieldUpdater<RemoteHost> UPLINK_EVENT_COUNT;
    static final AtomicIntegerFieldUpdater<RemoteHost> UPLINK_COMMAND_DELTA;
    static final AtomicLongFieldUpdater<RemoteHost> UPLINK_COMMAND_COUNT;
    static final AtomicLongFieldUpdater<RemoteHost> LAST_REPORT_TIME;

    public RemoteHost(Uri requestUri, Uri baseUri) {
        this(requestUri, baseUri, (HashTrieMap<String, Cookie>)HashTrieMap.empty());
    }

    public RemoteHost(Uri requestUri, Uri baseUri, HashTrieMap<String, Cookie> cookies) {
        this.cookies = cookies;
        this.requestUri = requestUri;
        this.baseUri = baseUri;
        this.remoteUri = null;
        this.flags = 0;
        this.remoteIdentity = null;
        this.downlinks = HashTrieMap.empty();
        this.uplinks = HashTrieMap.empty();
        this.receiveBacklog = 0;
        this.messageCont = null;
        this.resolveCache = new HashGenCacheMap(URI_RESOLUTION_CACHE_SIZE);
        this.downlinkOpenDelta = 0;
        this.downlinkOpenCount = 0L;
        this.downlinkCloseDelta = 0;
        this.downlinkCloseCount = 0L;
        this.downlinkEventDelta = 0;
        this.downlinkEventCount = 0L;
        this.downlinkCommandDelta = 0;
        this.downlinkCommandCount = 0L;
        this.uplinkOpenDelta = 0;
        this.uplinkOpenCount = 0L;
        this.uplinkCloseDelta = 0;
        this.uplinkCloseCount = 0L;
        this.uplinkEventDelta = 0;
        this.uplinkEventCount = 0L;
        this.uplinkCommandDelta = 0;
        this.uplinkCommandCount = 0L;
        this.lastReportTime = 0L;
        this.pulse = null;
        this.metaNode = null;
        this.metaPulse = null;
    }

    public RemoteHost(Uri baseUri) {
        this(Uri.empty(), baseUri);
    }

    public final TierContext tierContext() {
        return this.hostContext;
    }

    public final PartBinding part() {
        return this.hostContext.part();
    }

    public final HostBinding hostWrapper() {
        return this;
    }

    public <T> T unwrapHost(Class<T> hostClass) {
        if (hostClass.isAssignableFrom(((Object)((Object)this)).getClass())) {
            return (T)((Object)this);
        }
        return (T)this.hostContext.unwrapHost(hostClass);
    }

    public <T> T bottomHost(Class<T> hostClass) {
        Object host = this.hostContext.bottomHost(hostClass);
        if (host == null && hostClass.isAssignableFrom(((Object)((Object)this)).getClass())) {
            host = this;
        }
        return (T)host;
    }

    public final HostContext hostContext() {
        return this.hostContext;
    }

    public void setHostContext(HostContext hostContext) {
        this.hostContext = hostContext;
    }

    public WarpSocketContext warpSocketContext() {
        return this.warpSocketContext;
    }

    public void setWarpSocketContext(WarpSocketContext warpSocketContext) {
        this.warpSocketContext = warpSocketContext;
    }

    public long idleTimeout() {
        return -1L;
    }

    public HostAddress cellAddress() {
        return this.hostContext.cellAddress();
    }

    public String edgeName() {
        return this.hostContext.edgeName();
    }

    public Uri meshUri() {
        return this.hostContext.meshUri();
    }

    public Value partKey() {
        return this.hostContext.partKey();
    }

    public Uri hostUri() {
        return this.hostContext.hostUri();
    }

    public Policy policy() {
        return this.hostContext.policy();
    }

    public Schedule schedule() {
        return this.hostContext.schedule();
    }

    public Stage stage() {
        return this.hostContext.stage();
    }

    public StoreBinding store() {
        return this.hostContext.store();
    }

    public boolean isConnected() {
        WarpSocketContext warpSocketContext = this.warpSocketContext;
        return warpSocketContext != null && warpSocketContext.isConnected();
    }

    public boolean isRemote() {
        return true;
    }

    public boolean isSecure() {
        WarpSocketContext warpSocketContext = this.warpSocketContext;
        return warpSocketContext != null && warpSocketContext.isSecure();
    }

    public String securityProtocol() {
        WarpSocketContext warpSocketContext = this.warpSocketContext;
        if (warpSocketContext != null) {
            return warpSocketContext.securityProtocol();
        }
        return null;
    }

    public String cipherSuite() {
        WarpSocketContext warpSocketContext = this.warpSocketContext;
        if (warpSocketContext != null) {
            return warpSocketContext.cipherSuite();
        }
        return null;
    }

    public InetSocketAddress localAddress() {
        WarpSocketContext warpSocketContext = this.warpSocketContext;
        if (warpSocketContext != null) {
            return warpSocketContext.localAddress();
        }
        return null;
    }

    public Identity localIdentity() {
        return null;
    }

    public Principal localPrincipal() {
        WarpSocketContext warpSocketContext = this.warpSocketContext;
        if (warpSocketContext != null) {
            return warpSocketContext.localPrincipal();
        }
        return null;
    }

    public Collection<Certificate> localCertificates() {
        WarpSocketContext warpSocketContext = this.warpSocketContext;
        if (warpSocketContext != null) {
            return warpSocketContext.localCertificates();
        }
        return FingerTrieSeq.empty();
    }

    public InetSocketAddress remoteAddress() {
        WarpSocketContext warpSocketContext = this.warpSocketContext;
        if (warpSocketContext != null) {
            return warpSocketContext.remoteAddress();
        }
        return null;
    }

    public Identity remoteIdentity() {
        return this.remoteIdentity;
    }

    public Principal remotePrincipal() {
        WarpSocketContext warpSocketContext = this.warpSocketContext;
        if (warpSocketContext != null) {
            return warpSocketContext.remotePrincipal();
        }
        return null;
    }

    public Collection<Certificate> remoteCertificates() {
        WarpSocketContext warpSocketContext = this.warpSocketContext;
        if (warpSocketContext != null) {
            return warpSocketContext.remoteCertificates();
        }
        return FingerTrieSeq.empty();
    }

    public boolean isPrimary() {
        return (FLAGS.get(this) & 1) != 0;
    }

    public void setPrimary(boolean isPrimary) {
        int newFlags;
        int oldFlags;
        while (!FLAGS.compareAndSet(this, oldFlags = FLAGS.get(this), newFlags = oldFlags | 1)) {
        }
    }

    public boolean isReplica() {
        return (FLAGS.get(this) & 2) != 0;
    }

    public void setReplica(boolean isReplica) {
        int newFlags;
        int oldFlags;
        while (!FLAGS.compareAndSet(this, oldFlags = FLAGS.get(this), newFlags = oldFlags | 2)) {
        }
    }

    public boolean isMaster() {
        return (FLAGS.get(this) & 4) != 0;
    }

    public boolean isSlave() {
        return (FLAGS.get(this) & 8) != 0;
    }

    public void didBecomeMaster() {
        int newFlags;
        int oldFlags;
        while (!FLAGS.compareAndSet(this, oldFlags = FLAGS.get(this), newFlags = oldFlags & 0xFFFFFFF7 | 4)) {
        }
    }

    public void didBecomeSlave() {
        int newFlags;
        int oldFlags;
        while (!FLAGS.compareAndSet(this, oldFlags = FLAGS.get(this), newFlags = oldFlags & 0xFFFFFFFB | 8)) {
        }
    }

    RemoteWarpDownlink createWarpDownlink(Uri remoteNodeUri, Uri nodeUri, Uri laneUri, float prio, float rate, Value body) {
        return new RemoteWarpDownlink(this, remoteNodeUri, nodeUri, laneUri, prio, rate, body);
    }

    RemoteWarpUplink createWarpUplink(WarpBinding link, Uri remoteNodeUri) {
        return new RemoteWarpUplink(this, link, remoteNodeUri);
    }

    <E extends Envelope> PullRequest<E> createPull(float prio, E envelope, Cont<E> cont) {
        return new RemoteHostPull<E>(this, prio, envelope, cont);
    }

    protected Uri resolve(Uri relativeUri) {
        Uri absoluteUri = (Uri)this.resolveCache.get((Object)relativeUri);
        if (absoluteUri == null) {
            absoluteUri = this.baseUri.resolve(relativeUri);
            if (!relativeUri.authority().isDefined()) {
                absoluteUri = Uri.create((UriScheme)relativeUri.scheme(), (UriAuthority)UriAuthority.undefined(), (UriPath)absoluteUri.path(), (UriQuery)absoluteUri.query(), (UriFragment)absoluteUri.fragment());
            }
            absoluteUri = (Uri)this.resolveCache.put((Object)relativeUri, (Object)absoluteUri);
        }
        return absoluteUri;
    }

    public UriMapper<NodeBinding> nodes() {
        return UriMapper.empty();
    }

    public NodeBinding getNode(Uri nodeUri) {
        return null;
    }

    public NodeBinding openNode(Uri nodeUri) {
        return null;
    }

    public NodeBinding openNode(Uri nodeUri, NodeBinding node) {
        return null;
    }

    public void openUplink(LinkBinding link) {
        if (link instanceof WarpBinding) {
            this.openWarpUplink((WarpBinding)link);
        } else {
            UplinkError.rejectUnsupported((LinkBinding)link);
        }
    }

    protected void openWarpUplink(WarpBinding link) {
        block3: {
            HashTrieSet laneUplinks;
            HashTrieMap nodeUplinks;
            HashTrieMap newUplinks;
            HashTrieMap<Uri, HashTrieMap<Uri, HashTrieSet<RemoteWarpUplink>>> oldUplinks;
            Uri laneUri = link.laneUri();
            Uri remoteNodeUri = this.resolve(link.nodeUri());
            RemoteWarpUplink uplink = this.createWarpUplink(link, remoteNodeUri);
            link.setLinkContext((LinkContext)uplink);
            do {
                if ((nodeUplinks = (HashTrieMap)(oldUplinks = UPLINKS.get(this)).get((Object)remoteNodeUri)) == null) {
                    nodeUplinks = HashTrieMap.empty();
                }
                if ((laneUplinks = (HashTrieSet)nodeUplinks.get((Object)laneUri)) != null) continue;
                laneUplinks = HashTrieSet.empty();
            } while (!UPLINKS.compareAndSet(this, oldUplinks, (HashTrieMap<Uri, HashTrieMap<Uri, HashTrieSet<RemoteWarpUplink>>>)(newUplinks = oldUplinks.updated((Object)remoteNodeUri, (Object)(nodeUplinks = nodeUplinks.updated((Object)laneUri, (Object)(laneUplinks = laneUplinks.added((Object)uplink))))))));
            if (oldUplinks != newUplinks) {
                this.didOpenUplink(uplink);
            }
            if (!this.isConnected()) break block3;
            uplink.didConnect();
        }
    }

    void closeUplink(RemoteWarpUplink uplink) {
        HashTrieSet laneUplinks;
        HashTrieMap<Uri, HashTrieMap<Uri, HashTrieSet<RemoteWarpUplink>>> oldUplinks;
        HashTrieMap nodeUplinks;
        Uri laneUri = uplink.laneUri();
        Uri remoteNodeUri = uplink.remoteNodeUri;
        while ((nodeUplinks = (HashTrieMap)(oldUplinks = UPLINKS.get(this)).get((Object)remoteNodeUri)) != null && (laneUplinks = (HashTrieSet)nodeUplinks.get((Object)laneUri)) != null) {
            HashTrieMap newUplinks;
            if ((laneUplinks = laneUplinks.removed((Object)uplink)).isEmpty()) {
                newUplinks = (nodeUplinks = nodeUplinks.removed((Object)laneUri)).isEmpty() ? oldUplinks.removed((Object)remoteNodeUri) : oldUplinks.updated((Object)remoteNodeUri, (Object)nodeUplinks);
            } else {
                nodeUplinks = nodeUplinks.updated((Object)laneUri, (Object)laneUplinks);
                newUplinks = oldUplinks.updated((Object)remoteNodeUri, (Object)nodeUplinks);
            }
            if (!UPLINKS.compareAndSet(this, oldUplinks, (HashTrieMap<Uri, HashTrieMap<Uri, HashTrieSet<RemoteWarpUplink>>>)newUplinks)) continue;
            if (oldUplinks == newUplinks) break;
            uplink.didCloseUp();
            this.didCloseUplink(uplink);
            break;
        }
    }

    public void pushUp(Push<?> push) {
        Object message = push.message();
        if (message instanceof Envelope) {
            Envelope envelope = (Envelope)message;
            Uri remoteNodeUri = this.resolve(envelope.nodeUri());
            Envelope remoteEnvelope = envelope.nodeUri(remoteNodeUri);
            PullRequest<Envelope> pull = this.createPull(push.prio(), remoteEnvelope, push.cont());
            this.warpSocketContext.feed(pull);
        } else {
            push.trap((Throwable)new HostException("unsupported message: " + message));
        }
    }

    public void willConnect() {
    }

    public void didConnect() {
        this.messageCont = new RemoteHostMessageCont(this);
        InetSocketAddress remoteAddress = this.warpSocketContext.remoteAddress();
        UriAuthority remoteAuthority = UriAuthority.create((UriHost)UriHost.inetAddress((InetAddress)remoteAddress.getAddress()), (UriPort)UriPort.create((int)remoteAddress.getPort()));
        this.remoteUri = Uri.create((UriScheme)UriScheme.create((String)"warp"), (UriAuthority)remoteAuthority, (UriPath)UriPath.slash());
        REMOTE_IDENTITY.set(this, new Unauthenticated(this.requestUri, this.remoteUri, Value.absent()));
        this.connectUplinks();
        this.hostContext.didConnect();
    }

    public void willSecure() {
    }

    public void didSecure() {
    }

    public void willBecome(IpSocket socket) {
    }

    public void didBecome(IpSocket socket) {
    }

    public void didUpgrade(HttpRequest<?> request, HttpResponse<?> response) {
        this.start();
    }

    public void doRead() {
    }

    public void didRead(Envelope envelope) {
        if (envelope instanceof EventMessage) {
            this.onEventMessage((EventMessage)envelope);
        } else if (envelope instanceof CommandMessage) {
            this.onCommandMessage((CommandMessage)envelope);
        } else if (envelope instanceof LinkRequest) {
            this.onLinkRequest((LinkRequest)envelope);
        } else if (envelope instanceof LinkedResponse) {
            this.onLinkedResponse((LinkedResponse)envelope);
        } else if (envelope instanceof SyncRequest) {
            this.onSyncRequest((SyncRequest)envelope);
        } else if (envelope instanceof SyncedResponse) {
            this.onSyncedResponse((SyncedResponse)envelope);
        } else if (envelope instanceof UnlinkRequest) {
            this.onUnlinkRequest((UnlinkRequest)envelope);
        } else if (envelope instanceof UnlinkedResponse) {
            this.onUnlinkedResponse((UnlinkedResponse)envelope);
        } else if (envelope instanceof AuthRequest) {
            this.onAuthRequest((AuthRequest)envelope);
        } else if (envelope instanceof AuthedResponse) {
            this.onAuthedResponse((AuthedResponse)envelope);
        } else if (envelope instanceof DeauthRequest) {
            this.onDeauthRequest((DeauthRequest)envelope);
        } else if (envelope instanceof DeauthedResponse) {
            this.onDeauthedResponse((DeauthedResponse)envelope);
        } else {
            this.onUnknownEnvelope(envelope);
        }
    }

    public void didRead(WsControlFrame<?, ?> frame) {
        WarpSocketContext warpSocketContext = this.warpSocketContext;
        if (frame instanceof WsCloseFrame) {
            if (warpSocketContext != null) {
                warpSocketContext.write((WsControlFrame)WsCloseFrame.create((int)1000));
            } else {
                this.didReadClose((WsCloseFrame)frame);
            }
        } else if (frame instanceof WsPingFrame && warpSocketContext != null) {
            warpSocketContext.write((WsControlFrame)WsPongFrame.create((Object)frame.payloadValue()));
        }
    }

    protected void didReadClose(WsCloseFrame<?, ?> frame) {
        this.close();
    }

    protected void onEventMessage(EventMessage message) {
        HashTrieSet laneUplinks;
        Uri nodeUri = this.resolve(message.nodeUri());
        Uri laneUri = message.laneUri();
        HashTrieMap nodeUplinks = (HashTrieMap)UPLINKS.get(this).get((Object)nodeUri);
        if (nodeUplinks != null && (laneUplinks = (HashTrieSet)nodeUplinks.get((Object)laneUri)) != null) {
            EventMessage resolvedMessage = message.nodeUri(nodeUri);
            Iterator uplinksIterator = laneUplinks.iterator();
            while (uplinksIterator.hasNext()) {
                this.willPushMessage((Envelope)resolvedMessage);
                RemoteWarpUplink uplink = (RemoteWarpUplink)uplinksIterator.next();
                uplink.queueDown((Push<Envelope>)new Push(Uri.empty(), Uri.empty(), uplink.nodeUri(), uplink.laneUri(), uplink.prio(), this.remoteIdentity(), (Object)resolvedMessage, (Cont)this.messageCont));
            }
        }
        UPLINK_EVENT_DELTA.incrementAndGet(this);
        this.didUpdateMetrics();
    }

    protected void onCommandMessage(CommandMessage message) {
        Policy policy = this.policy();
        PolicyDirective directive = policy != null ? policy.canDownlink(message, this.remoteIdentity) : PolicyDirective.allow();
        if (directive.isAllowed()) {
            RemoteWarpDownlink laneDownlink;
            CommandMessage newMessage = (CommandMessage)directive.get();
            if (newMessage != null) {
                message = newMessage;
            }
            Uri nodeUri = this.resolve(message.nodeUri());
            Uri laneUri = message.laneUri();
            CommandMessage resolvedMessage = message.nodeUri(nodeUri);
            HashTrieMap nodeDownlinks = (HashTrieMap)DOWNLINKS.get(this).get((Object)nodeUri);
            RemoteWarpDownlink remoteWarpDownlink = laneDownlink = nodeDownlinks != null ? (RemoteWarpDownlink)nodeDownlinks.get((Object)laneUri) : null;
            if (laneDownlink != null) {
                laneDownlink.queueUp((Envelope)resolvedMessage);
            } else {
                this.willPushMessage((Envelope)resolvedMessage);
                this.hostContext.pushDown(new Push(Uri.empty(), Uri.empty(), nodeUri, laneUri, 0.0f, null, (Object)resolvedMessage, (Cont)this.messageCont));
            }
        } else if (directive.isForbidden()) {
            this.forbid();
        }
        DOWNLINK_COMMAND_DELTA.incrementAndGet(this);
        this.didUpdateMetrics();
    }

    protected void willPushMessage(Envelope envelope) {
    }

    protected void didPushMessage(Envelope envelope) {
    }

    protected void reconcileReceiveBacklog() {
        int receiveBacklog;
        do {
            if ((receiveBacklog = this.receiveBacklog) < MAX_RECEIVE_BACKLOG) {
                this.warpSocketContext.flowControl(FlowModifier.ENABLE_READ);
                continue;
            }
            this.warpSocketContext.flowControl(FlowModifier.DISABLE_READ);
        } while (receiveBacklog != this.receiveBacklog);
    }

    protected void routeDownlink(LinkAddressed envelope) {
        RemoteWarpDownlink downlink;
        Uri nodeUri;
        block4: {
            HashTrieMap nodeDownlinks;
            HashTrieMap newDownlinks;
            HashTrieMap<Uri, HashTrieMap<Uri, RemoteWarpDownlink>> oldDownlinks;
            Uri remoteNodeUri = envelope.nodeUri();
            nodeUri = this.resolve(remoteNodeUri);
            Uri laneUri = envelope.laneUri();
            float prio = envelope.prio();
            float rate = envelope.rate();
            Value body = envelope.body();
            downlink = null;
            do {
                RemoteWarpDownlink laneDownlink;
                if ((nodeDownlinks = (HashTrieMap)(oldDownlinks = DOWNLINKS.get(this)).get((Object)nodeUri)) == null) {
                    nodeDownlinks = HashTrieMap.empty();
                }
                if ((laneDownlink = (RemoteWarpDownlink)nodeDownlinks.get((Object)laneUri)) != null) {
                    if (downlink != null) {
                        downlink.closeDown();
                    }
                    downlink = laneDownlink;
                    break block4;
                }
                if (downlink != null) continue;
                downlink = this.createWarpDownlink(remoteNodeUri, nodeUri, laneUri, prio, rate, body);
                this.hostContext.openDownlink((LinkBinding)downlink);
            } while (!DOWNLINKS.compareAndSet(this, oldDownlinks, (HashTrieMap<Uri, HashTrieMap<Uri, RemoteWarpDownlink>>)(newDownlinks = oldDownlinks.updated((Object)nodeUri, (Object)(nodeDownlinks = nodeDownlinks.updated((Object)laneUri, (Object)downlink))))));
            downlink.openDown();
            this.didOpenDownlink(downlink);
        }
        LinkAddressed resolvedEnvelope = envelope.nodeUri(nodeUri);
        downlink.queueUp((Envelope)resolvedEnvelope);
    }

    protected void didOpenDownlink(WarpBinding downlink) {
        DOWNLINK_OPEN_DELTA.incrementAndGet(this);
        this.flushMetrics();
    }

    protected void didCloseDownlink(WarpBinding downlink) {
        DOWNLINK_CLOSE_DELTA.incrementAndGet(this);
        this.flushMetrics();
    }

    protected void routeUplink(LaneAddressed envelope) {
        HashTrieSet laneUplinks;
        Uri nodeUri = this.resolve(envelope.nodeUri());
        Uri laneUri = envelope.laneUri();
        HashTrieMap nodeUplinks = (HashTrieMap)UPLINKS.get(this).get((Object)nodeUri);
        if (nodeUplinks != null && (laneUplinks = (HashTrieSet)nodeUplinks.get((Object)laneUri)) != null) {
            LaneAddressed resolvedEnvelope = envelope.nodeUri(nodeUri);
            for (RemoteWarpUplink uplink : laneUplinks) {
                uplink.queueDown((Push<Envelope>)new Push(Uri.empty(), Uri.empty(), uplink.nodeUri(), uplink.laneUri(), uplink.prio(), this.remoteIdentity(), (Object)resolvedEnvelope, null));
            }
        }
    }

    protected void didOpenUplink(WarpContext uplink) {
        UPLINK_OPEN_DELTA.incrementAndGet(this);
        this.flushMetrics();
    }

    protected void didCloseUplink(WarpContext uplink) {
        UPLINK_CLOSE_DELTA.incrementAndGet(this);
        this.flushMetrics();
    }

    protected void onLinkRequest(LinkRequest request) {
        Policy policy = this.policy();
        if (policy != null) {
            PolicyDirective directive = policy.canLink(request, this.remoteIdentity);
            if (directive.isAllowed()) {
                LinkRequest newRequest = (LinkRequest)directive.get();
                if (newRequest != null) {
                    request = newRequest;
                }
            } else {
                if (directive.isDenied()) {
                    UnlinkedResponse response = new UnlinkedResponse(request.nodeUri(), request.laneUri());
                    this.warpSocketContext.feed((Envelope)response, 1.0f);
                    return;
                }
                this.forbid();
                return;
            }
        }
        this.routeDownlink((LinkAddressed)request);
    }

    protected void onLinkedResponse(LinkedResponse response) {
        this.routeUplink((LaneAddressed)response);
    }

    protected void onSyncRequest(SyncRequest request) {
        Policy policy = this.policy();
        if (policy != null) {
            PolicyDirective directive = policy.canSync(request, this.remoteIdentity);
            if (directive.isAllowed()) {
                SyncRequest newRequest = (SyncRequest)directive.get();
                if (newRequest != null) {
                    request = newRequest;
                }
            } else {
                if (directive.isDenied()) {
                    UnlinkedResponse response = new UnlinkedResponse(request.nodeUri(), request.laneUri());
                    this.warpSocketContext.feed((Envelope)response, 1.0f);
                    return;
                }
                this.forbid();
                return;
            }
        }
        this.routeDownlink((LinkAddressed)request);
    }

    protected void onSyncedResponse(SyncedResponse response) {
        this.routeUplink((LaneAddressed)response);
    }

    protected void onUnlinkRequest(UnlinkRequest request) {
        RemoteWarpDownlink downlink;
        HashTrieMap<Uri, HashTrieMap<Uri, RemoteWarpDownlink>> oldDownlinks;
        HashTrieMap nodeDownlinks;
        Uri nodeUri = this.resolve(request.nodeUri());
        Uri laneUri = request.laneUri();
        while ((nodeDownlinks = (HashTrieMap)(oldDownlinks = DOWNLINKS.get(this)).get((Object)nodeUri)) != null && (downlink = (RemoteWarpDownlink)nodeDownlinks.get((Object)laneUri)) != null) {
            HashTrieMap newDownlinks = (nodeDownlinks = nodeDownlinks.removed((Object)laneUri)).isEmpty() ? oldDownlinks.removed((Object)nodeUri) : oldDownlinks.updated((Object)nodeUri, (Object)nodeDownlinks);
            if (!DOWNLINKS.compareAndSet(this, oldDownlinks, (HashTrieMap<Uri, HashTrieMap<Uri, RemoteWarpDownlink>>)newDownlinks)) continue;
            UnlinkRequest resolvedRequest = request.nodeUri(nodeUri);
            downlink.queueUp((Envelope)resolvedRequest);
            this.didCloseDownlink(downlink);
            break;
        }
    }

    protected void onUnlinkedResponse(UnlinkedResponse response) {
        HashTrieSet laneUplinks;
        HashTrieMap<Uri, HashTrieMap<Uri, HashTrieSet<RemoteWarpUplink>>> oldUplinks;
        HashTrieMap nodeUplinks;
        Uri nodeUri = this.resolve(response.nodeUri());
        Uri laneUri = response.laneUri();
        while ((nodeUplinks = (HashTrieMap)(oldUplinks = UPLINKS.get(this)).get((Object)nodeUri)) != null && (laneUplinks = (HashTrieSet)nodeUplinks.get((Object)laneUri)) != null) {
            HashTrieMap newUplinks = (nodeUplinks = nodeUplinks.removed((Object)laneUri)).isEmpty() ? oldUplinks.removed((Object)nodeUri) : oldUplinks.updated((Object)nodeUri, (Object)nodeUplinks);
            if (!UPLINKS.compareAndSet(this, oldUplinks, (HashTrieMap<Uri, HashTrieMap<Uri, HashTrieSet<RemoteWarpUplink>>>)newUplinks)) continue;
            UnlinkedResponse resolvedResponse = response.nodeUri(nodeUri);
            for (RemoteWarpUplink uplink : laneUplinks) {
                uplink.queueDown((Push<Envelope>)new Push(Uri.empty(), Uri.empty(), uplink.nodeUri(), uplink.laneUri(), uplink.prio(), this.remoteIdentity(), (Object)resolvedResponse, null));
                this.didCloseUplink(uplink);
            }
        }
    }

    protected void onAuthRequest(AuthRequest request) {
        DeauthedResponse response;
        Value claims = request.body().branch();
        for (int i = 0; i < claims.length(); ++i) {
            Cookie authCookie;
            Item claim = claims.getItem(i);
            Value claimKey = claim.key();
            Value claimValue = claims.getField(claimKey).value();
            if (!claimValue.containsKey("cookie") || (authCookie = (Cookie)this.cookies.get((Object)claimValue.get("cookie").stringValue())) == null) continue;
            claims.updated(claimKey, (Value)Text.from((String)authCookie.getValue()));
        }
        RemoteCredentials credentials = new RemoteCredentials(this.requestUri, this.remoteUri, claims);
        PolicyDirective directive = this.hostContext.authenticate((Credentials)credentials);
        if (directive != null && directive.isAllowed()) {
            REMOTE_IDENTITY.set(this, (Identity)directive.get());
            response = new AuthedResponse();
            this.warpSocketContext.feed((Envelope)response, 1.0f);
        } else {
            response = new DeauthedResponse();
            this.warpSocketContext.feed((Envelope)response, 1.0f);
        }
        if (directive != null && directive.isForbidden()) {
            WarpSocketContext warpSocketContext = this.warpSocketContext;
            if (warpSocketContext != null) {
                warpSocketContext.write((WsControlFrame)WsCloseFrame.create((int)1008, (String)"Unauthorized"));
            } else {
                this.close();
            }
        }
    }

    protected void onAuthedResponse(AuthedResponse response) {
    }

    protected void onDeauthRequest(DeauthRequest request) {
        REMOTE_IDENTITY.set(this, null);
        DeauthedResponse response = new DeauthedResponse();
        this.warpSocketContext.feed((Envelope)response, 1.0f);
    }

    protected void onDeauthedResponse(DeauthedResponse response) {
    }

    protected void onUnknownEnvelope(Envelope envelope) {
    }

    protected void forbid() {
        WarpSocketContext warpSocketContext = this.warpSocketContext;
        if (warpSocketContext != null) {
            warpSocketContext.write((WsControlFrame)WsCloseFrame.create((int)1008, (String)"Forbidden"));
        } else {
            this.close();
        }
    }

    public void doWrite() {
    }

    public void didWrite(Envelope envelope) {
    }

    public void didWrite(WsControlFrame<?, ?> frame) {
    }

    public void didTimeout() {
    }

    public void didDisconnect() {
        RemoteHostMessageCont messageCont = this.messageCont;
        if (messageCont != null) {
            messageCont.host = null;
            this.messageCont = null;
        }
        RECEIVE_BACKLOG.set(this, 0);
        Throwable failure = null;
        try {
            this.disconnectUplinks();
        }
        catch (Throwable cause) {
            if (!Cont.isNonFatal((Throwable)cause)) {
                throw cause;
            }
            failure = cause;
        }
        try {
            this.hostContext.didDisconnect();
        }
        catch (Throwable cause) {
            if (!Cont.isNonFatal((Throwable)cause)) {
                throw cause;
            }
            failure = cause;
        }
        this.reconnect();
        if (failure instanceof RuntimeException) {
            throw (RuntimeException)failure;
        }
        if (failure instanceof Error) {
            throw (Error)failure;
        }
    }

    protected void willClose() {
        super.willClose();
        Throwable failure = null;
        try {
            this.closeDownlinks();
        }
        catch (Throwable cause) {
            if (!Cont.isNonFatal((Throwable)cause)) {
                throw cause;
            }
            failure = cause;
        }
        try {
            this.closeUplinks();
        }
        catch (Throwable cause) {
            if (!Cont.isNonFatal((Throwable)cause)) {
                throw cause;
            }
            failure = cause;
        }
        try {
            HostContext hostContext = this.hostContext;
            if (hostContext != null) {
                hostContext.close();
            }
        }
        catch (Throwable cause) {
            if (!Cont.isNonFatal((Throwable)cause)) {
                throw cause;
            }
            failure = cause;
        }
        try {
            WarpSocketContext warpSocketContext = this.warpSocketContext;
            if (warpSocketContext != null) {
                warpSocketContext.close();
            }
        }
        catch (Throwable cause) {
            if (!Cont.isNonFatal((Throwable)cause)) {
                throw cause;
            }
            failure = cause;
        }
        if (failure instanceof RuntimeException) {
            throw (RuntimeException)failure;
        }
        if (failure instanceof Error) {
            throw (Error)failure;
        }
    }

    public void didClose() {
        super.didClose();
        AgentNode metaNode = this.metaNode;
        if (metaNode != null) {
            metaNode.close();
            this.metaNode = null;
        }
        this.flushMetrics();
    }

    public void didFail(Throwable error) {
        Throwable failure = null;
        try {
            WarpSocketContext warpSocketContext = this.warpSocketContext;
            if (warpSocketContext != null) {
                this.warpSocketContext = null;
                warpSocketContext.close();
            }
        }
        catch (Throwable cause) {
            if (!Cont.isNonFatal((Throwable)cause)) {
                throw cause;
            }
            failure = cause;
        }
        this.hostContext.close();
        if (failure instanceof RuntimeException) {
            throw (RuntimeException)failure;
        }
        if (failure instanceof Error) {
            throw (Error)failure;
        }
    }

    public void openMetaHost(HostBinding host, NodeBinding metaHost) {
        if (metaHost instanceof AgentNode) {
            this.metaNode = (AgentNode)metaHost;
            this.openMetaLanes(host, (AgentNode)metaHost);
        }
        this.hostContext.openMetaHost(host, metaHost);
    }

    protected void openMetaLanes(HostBinding host, AgentNode metaHost) {
        this.openReflectLanes(host, metaHost);
    }

    protected void openReflectLanes(HostBinding host, AgentNode metaHost) {
        this.metaPulse = this.metaNode.demandLane().valueForm(HostPulse.form()).observe((Object)new RemoteHostPulseController(this));
        this.metaNode.openLane(HostPulse.PULSE_URI, this.metaPulse);
    }

    public void openMetaNode(NodeBinding node, NodeBinding metaNode) {
        this.hostContext.openMetaNode(node, metaNode);
    }

    public void openMetaLane(LaneBinding lane, NodeBinding metaLane) {
        this.hostContext.openMetaLane(lane, metaLane);
    }

    public void openMetaUplink(LinkBinding uplink, NodeBinding metaUplink) {
        this.hostContext.openMetaUplink(uplink, metaUplink);
    }

    public void openMetaDownlink(LinkBinding downlink, NodeBinding metaDownlink) {
        this.hostContext.openMetaDownlink(downlink, metaDownlink);
    }

    public LinkBinding bindDownlink(Downlink downlink) {
        return this.hostContext.bindDownlink(downlink);
    }

    public void openDownlink(LinkBinding link) {
        this.hostContext.openDownlink(link);
    }

    public void closeDownlink(LinkBinding link) {
        this.hostContext.closeDownlink(link);
    }

    public void pushDown(Push<?> push) {
        this.hostContext.pushDown(push);
    }

    public void reportDown(Metric metric) {
        this.hostContext.reportDown(metric);
    }

    protected void reconnect() {
        this.close();
    }

    protected void closeDownlinks() {
        HashTrieMap newDownlinks;
        HashTrieMap<Uri, HashTrieMap<Uri, RemoteWarpDownlink>> oldDownlinks;
        while (!DOWNLINKS.compareAndSet(this, oldDownlinks = DOWNLINKS.get(this), (HashTrieMap<Uri, HashTrieMap<Uri, RemoteWarpDownlink>>)(newDownlinks = HashTrieMap.empty()))) {
        }
        Iterator nodeDownlinksIterator = oldDownlinks.valueIterator();
        while (nodeDownlinksIterator.hasNext()) {
            HashTrieMap nodeDownlinks = (HashTrieMap)nodeDownlinksIterator.next();
            Iterator laneDownlinks = nodeDownlinks.valueIterator();
            while (laneDownlinks.hasNext()) {
                RemoteWarpDownlink downlink = (RemoteWarpDownlink)laneDownlinks.next();
                downlink.closeDown();
                this.didCloseDownlink(downlink);
            }
        }
    }

    protected void closeUplinks() {
        HashTrieMap newUplinks;
        HashTrieMap<Uri, HashTrieMap<Uri, HashTrieSet<RemoteWarpUplink>>> oldUplinks;
        while (!UPLINKS.compareAndSet(this, oldUplinks = UPLINKS.get(this), (HashTrieMap<Uri, HashTrieMap<Uri, HashTrieSet<RemoteWarpUplink>>>)(newUplinks = HashTrieMap.empty()))) {
        }
        Iterator nodeUplinksIterator = oldUplinks.valueIterator();
        while (nodeUplinksIterator.hasNext()) {
            HashTrieMap nodeUplinks = (HashTrieMap)nodeUplinksIterator.next();
            Iterator laneUplinksIterator = nodeUplinks.valueIterator();
            while (laneUplinksIterator.hasNext()) {
                HashTrieSet laneUplinks = (HashTrieSet)laneUplinksIterator.next();
                for (RemoteWarpUplink uplink : laneUplinks) {
                    uplink.closeUp();
                    this.didCloseUplink(uplink);
                }
            }
        }
    }

    protected void connectUplinks() {
        Iterator nodeUplinksIterator = UPLINKS.get(this).valueIterator();
        while (nodeUplinksIterator.hasNext()) {
            HashTrieMap nodeUplinks = (HashTrieMap)nodeUplinksIterator.next();
            Iterator laneUplinksIterator = nodeUplinks.valueIterator();
            while (laneUplinksIterator.hasNext()) {
                HashTrieSet laneUplinks = (HashTrieSet)laneUplinksIterator.next();
                for (RemoteWarpUplink uplink : laneUplinks) {
                    uplink.didConnect();
                }
            }
        }
    }

    protected void disconnectUplinks() {
        Iterator nodeUplinksIterator = UPLINKS.get(this).valueIterator();
        while (nodeUplinksIterator.hasNext()) {
            HashTrieMap nodeUplinks = (HashTrieMap)nodeUplinksIterator.next();
            Iterator laneUplinksIterator = nodeUplinks.valueIterator();
            while (laneUplinksIterator.hasNext()) {
                HashTrieSet laneUplinks = (HashTrieSet)laneUplinksIterator.next();
                for (RemoteWarpUplink uplink : laneUplinks) {
                    uplink.didDisconnect();
                }
            }
        }
    }

    public void trace(Object message) {
        this.hostContext.trace(message);
    }

    public void debug(Object message) {
        this.hostContext.debug(message);
    }

    public void info(Object message) {
        this.hostContext.info(message);
    }

    public void warn(Object message) {
        this.hostContext.warn(message);
    }

    public void error(Object message) {
        this.hostContext.error(message);
    }

    public void fail(Object message) {
        this.hostContext.fail(message);
    }

    protected void didUpdateMetrics() {
        long oldReportTime;
        long newReportTime;
        long dt;
        while ((dt = (newReportTime = System.currentTimeMillis()) - (oldReportTime = LAST_REPORT_TIME.get(this))) >= 1000L) {
            if (!LAST_REPORT_TIME.compareAndSet(this, oldReportTime, newReportTime)) continue;
            try {
                this.reportMetrics(dt);
                break;
            }
            catch (Throwable error) {
                if (Cont.isNonFatal((Throwable)error)) {
                    this.didFail(error);
                    break;
                }
                throw error;
            }
        }
    }

    protected void flushMetrics() {
        long newReportTime = System.currentTimeMillis();
        long oldReportTime = LAST_REPORT_TIME.getAndSet(this, newReportTime);
        long dt = newReportTime - oldReportTime;
        try {
            this.reportMetrics(dt);
        }
        catch (Throwable error) {
            if (Cont.isNonFatal((Throwable)error)) {
                this.didFail(error);
            }
            throw error;
        }
    }

    protected void reportMetrics(long dt) {
        HostProfile profile = this.collectProfile(dt);
        this.hostContext.reportDown((Metric)profile);
    }

    protected HostProfile collectProfile(long dt) {
        boolean nodeOpenDelta = false;
        long nodeOpenCount = 0L;
        boolean nodeCloseDelta = false;
        long nodeCloseCount = 0L;
        boolean agentOpenDelta = false;
        long agentOpenCount = 0L;
        boolean agentCloseDelta = false;
        long agentCloseCount = 0L;
        long agentExecDelta = 0L;
        long agentExecRate = 0L;
        long agentExecTime = 0L;
        boolean timerEventDelta = false;
        boolean timerEventRate = false;
        long timerEventCount = 0L;
        int downlinkOpenDelta = DOWNLINK_OPEN_DELTA.getAndSet(this, 0);
        long downlinkOpenCount = DOWNLINK_OPEN_COUNT.addAndGet(this, downlinkOpenDelta);
        int downlinkCloseDelta = DOWNLINK_CLOSE_DELTA.getAndSet(this, 0);
        long downlinkCloseCount = DOWNLINK_CLOSE_COUNT.addAndGet(this, downlinkCloseDelta);
        int downlinkEventDelta = DOWNLINK_EVENT_DELTA.getAndSet(this, 0);
        int downlinkEventRate = (int)Math.ceil(1000.0 * (double)downlinkEventDelta / (double)dt);
        long downlinkEventCount = DOWNLINK_EVENT_COUNT.addAndGet(this, downlinkEventDelta);
        int downlinkCommandDelta = DOWNLINK_COMMAND_DELTA.getAndSet(this, 0);
        int downlinkCommandRate = (int)Math.ceil(1000.0 * (double)downlinkCommandDelta / (double)dt);
        long downlinkCommandCount = DOWNLINK_COMMAND_COUNT.addAndGet(this, downlinkCommandDelta);
        int uplinkOpenDelta = UPLINK_OPEN_DELTA.getAndSet(this, 0);
        long uplinkOpenCount = UPLINK_OPEN_COUNT.addAndGet(this, uplinkOpenDelta);
        int uplinkCloseDelta = UPLINK_CLOSE_DELTA.getAndSet(this, 0);
        long uplinkCloseCount = UPLINK_CLOSE_COUNT.addAndGet(this, uplinkCloseDelta);
        int uplinkEventDelta = UPLINK_EVENT_DELTA.getAndSet(this, 0);
        int uplinkEventRate = (int)Math.ceil(1000.0 * (double)uplinkEventDelta / (double)dt);
        long uplinkEventCount = UPLINK_EVENT_COUNT.addAndGet(this, uplinkEventDelta);
        int uplinkCommandDelta = UPLINK_COMMAND_DELTA.getAndSet(this, 0);
        int uplinkCommandRate = (int)Math.ceil(1000.0 * (double)uplinkCommandDelta / (double)dt);
        long uplinkCommandCount = UPLINK_COMMAND_COUNT.addAndGet(this, uplinkCommandDelta);
        long nodeCount = 0L;
        long agentCount = 0L;
        AgentPulse agentPulse = new AgentPulse(0L, 0L, 0L, 0, 0L);
        long downlinkCount = downlinkOpenCount - downlinkCloseCount;
        WarpDownlinkPulse downlinkPulse = new WarpDownlinkPulse(downlinkCount, downlinkEventRate, downlinkEventCount, downlinkCommandRate, downlinkCommandCount);
        long uplinkCount = uplinkOpenCount - uplinkCloseCount;
        WarpUplinkPulse uplinkPulse = new WarpUplinkPulse(uplinkCount, uplinkEventRate, uplinkEventCount, uplinkCommandRate, uplinkCommandCount);
        this.pulse = new HostPulse(0L, agentPulse, downlinkPulse, uplinkPulse, SystemPulse.latest());
        DemandLane<HostPulse> metaPulse = this.metaPulse;
        if (metaPulse != null) {
            metaPulse.cue();
        }
        return new HostProfile(this.cellAddress(), 0, 0L, 0, 0L, 0, 0L, 0, 0L, 0L, 0L, 0L, 0, 0, 0L, downlinkOpenDelta, downlinkOpenCount, downlinkCloseDelta, downlinkCloseCount, downlinkEventDelta, downlinkEventRate, downlinkEventCount, downlinkCommandDelta, downlinkCommandRate, downlinkCommandCount, uplinkOpenDelta, uplinkOpenCount, uplinkCloseDelta, uplinkCloseCount, uplinkEventDelta, uplinkEventRate, uplinkEventCount, uplinkCommandDelta, uplinkCommandRate, uplinkCommandCount);
    }

    static {
        int uriResolutionCacheSize;
        int maxReceiveBacklog;
        int maxSendBacklog;
        FLAGS = AtomicIntegerFieldUpdater.newUpdater(RemoteHost.class, "flags");
        REMOTE_IDENTITY = AtomicReferenceFieldUpdater.newUpdater(RemoteHost.class, Identity.class, "remoteIdentity");
        RECEIVE_BACKLOG = AtomicIntegerFieldUpdater.newUpdater(RemoteHost.class, "receiveBacklog");
        DOWNLINKS = AtomicReferenceFieldUpdater.newUpdater(RemoteHost.class, HashTrieMap.class, "downlinks");
        UPLINKS = AtomicReferenceFieldUpdater.newUpdater(RemoteHost.class, HashTrieMap.class, "uplinks");
        DOWNLINK_OPEN_DELTA = AtomicIntegerFieldUpdater.newUpdater(RemoteHost.class, "downlinkOpenDelta");
        DOWNLINK_OPEN_COUNT = AtomicLongFieldUpdater.newUpdater(RemoteHost.class, "downlinkOpenCount");
        DOWNLINK_CLOSE_DELTA = AtomicIntegerFieldUpdater.newUpdater(RemoteHost.class, "downlinkCloseDelta");
        DOWNLINK_CLOSE_COUNT = AtomicLongFieldUpdater.newUpdater(RemoteHost.class, "downlinkCloseCount");
        DOWNLINK_EVENT_DELTA = AtomicIntegerFieldUpdater.newUpdater(RemoteHost.class, "downlinkEventDelta");
        DOWNLINK_EVENT_COUNT = AtomicLongFieldUpdater.newUpdater(RemoteHost.class, "downlinkEventCount");
        DOWNLINK_COMMAND_DELTA = AtomicIntegerFieldUpdater.newUpdater(RemoteHost.class, "downlinkCommandDelta");
        DOWNLINK_COMMAND_COUNT = AtomicLongFieldUpdater.newUpdater(RemoteHost.class, "downlinkCommandCount");
        UPLINK_OPEN_DELTA = AtomicIntegerFieldUpdater.newUpdater(RemoteHost.class, "uplinkOpenDelta");
        UPLINK_OPEN_COUNT = AtomicLongFieldUpdater.newUpdater(RemoteHost.class, "uplinkOpenCount");
        UPLINK_CLOSE_DELTA = AtomicIntegerFieldUpdater.newUpdater(RemoteHost.class, "uplinkCloseDelta");
        UPLINK_CLOSE_COUNT = AtomicLongFieldUpdater.newUpdater(RemoteHost.class, "uplinkCloseCount");
        UPLINK_EVENT_DELTA = AtomicIntegerFieldUpdater.newUpdater(RemoteHost.class, "uplinkEventDelta");
        UPLINK_EVENT_COUNT = AtomicLongFieldUpdater.newUpdater(RemoteHost.class, "uplinkEventCount");
        UPLINK_COMMAND_DELTA = AtomicIntegerFieldUpdater.newUpdater(RemoteHost.class, "uplinkCommandDelta");
        UPLINK_COMMAND_COUNT = AtomicLongFieldUpdater.newUpdater(RemoteHost.class, "uplinkCommandCount");
        LAST_REPORT_TIME = AtomicLongFieldUpdater.newUpdater(RemoteHost.class, "lastReportTime");
        try {
            maxSendBacklog = Integer.parseInt(System.getProperty("swim.remote.max.send.backlog"));
        }
        catch (NumberFormatException e) {
            maxSendBacklog = Math.max(512, 128 * Runtime.getRuntime().availableProcessors());
        }
        MAX_SEND_BACKLOG = maxSendBacklog;
        try {
            maxReceiveBacklog = Integer.parseInt(System.getProperty("swim.remote.max.receive.backlog"));
        }
        catch (NumberFormatException e) {
            maxReceiveBacklog = Math.max(512, 128 * Runtime.getRuntime().availableProcessors());
        }
        MAX_RECEIVE_BACKLOG = maxReceiveBacklog;
        try {
            uriResolutionCacheSize = Integer.parseInt(System.getProperty("swim.remote.uri.resolution.cache.size"));
        }
        catch (NumberFormatException e) {
            uriResolutionCacheSize = 8;
        }
        URI_RESOLUTION_CACHE_SIZE = uriResolutionCacheSize;
    }
}

