/*
 * Decompiled with CFR 0.152.
 */
package swim.remote;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import swim.api.LinkException;
import swim.api.auth.Identity;
import swim.concurrent.Cont;
import swim.concurrent.PullContext;
import swim.concurrent.PullRequest;
import swim.concurrent.StayContext;
import swim.io.warp.WarpSocketContext;
import swim.remote.RemoteHost;
import swim.structure.Value;
import swim.system.CellContext;
import swim.system.LinkAddress;
import swim.system.LinkBinding;
import swim.system.LinkContext;
import swim.system.NodeBinding;
import swim.system.Push;
import swim.system.WarpBinding;
import swim.system.WarpContext;
import swim.uri.Uri;
import swim.warp.Envelope;
import swim.warp.EventMessage;
import swim.warp.LinkRequest;
import swim.warp.SyncRequest;

class RemoteWarpDownlink
implements WarpBinding,
PullRequest<Envelope> {
    final RemoteHost host;
    Uri hostUri;
    final Uri remoteNodeUri;
    Uri nodeUri;
    final Uri laneUri;
    final float prio;
    final float rate;
    final Value body;
    final ConcurrentLinkedQueue<Envelope> upQueue;
    WarpContext linkContext;
    PullContext<? super Envelope> pullContext;
    volatile int status;
    static final int FEEDING_DOWN = 1;
    static final int PULLING_DOWN = 2;
    static final int FEEDING_UP = 4;
    static final int SYNC = 8;
    static final AtomicIntegerFieldUpdater<RemoteWarpDownlink> STATUS = AtomicIntegerFieldUpdater.newUpdater(RemoteWarpDownlink.class, "status");

    RemoteWarpDownlink(RemoteHost host, Uri remoteNodeUri, Uri nodeUri, Uri laneUri, float prio, float rate, Value body) {
        this.host = host;
        this.hostUri = Uri.empty();
        this.remoteNodeUri = remoteNodeUri;
        this.nodeUri = nodeUri;
        this.laneUri = laneUri;
        this.prio = prio;
        this.rate = rate;
        this.body = body;
        this.upQueue = new ConcurrentLinkedQueue();
        this.linkContext = null;
        this.pullContext = null;
        this.status = 0;
    }

    public final WarpBinding linkWrapper() {
        return this;
    }

    public final WarpContext linkContext() {
        return this.linkContext;
    }

    public void setLinkContext(LinkContext linkContext) {
        this.linkContext = (WarpContext)linkContext;
    }

    public CellContext cellContext() {
        return null;
    }

    public void setCellContext(CellContext cellContext) {
    }

    public <T> T unwrapLink(Class<T> linkClass) {
        if (linkClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (this.linkContext != null) {
            return (T)this.linkContext.unwrapLink(linkClass);
        }
        return null;
    }

    public <T> T bottomLink(Class<T> linkClass) {
        Object link = null;
        if (this.linkContext != null) {
            link = this.linkContext.bottomLink(linkClass);
        }
        if (link == null && linkClass.isAssignableFrom(this.getClass())) {
            link = this;
        }
        return (T)link;
    }

    public final Uri meshUri() {
        return Uri.empty();
    }

    public final Uri hostUri() {
        return this.hostUri;
    }

    public void setHostUri(Uri hostUri) {
        this.hostUri = hostUri;
    }

    public final Uri nodeUri() {
        return this.nodeUri;
    }

    public void setNodeUri(Uri nodeUri) {
        this.nodeUri = nodeUri;
    }

    public final Uri laneUri() {
        return this.laneUri;
    }

    public Value linkKey() {
        return this.linkContext.linkKey();
    }

    public LinkAddress cellAddressDown() {
        return this.host.cellAddress().nodeUri(this.nodeUri).laneUri(this.laneUri).linkKey(this.linkKey());
    }

    public final float prio() {
        return this.prio;
    }

    public final float rate() {
        return this.rate;
    }

    public final Value body() {
        return this.body;
    }

    public boolean keepLinked() {
        return false;
    }

    public boolean keepSynced() {
        return false;
    }

    public boolean isConnectedDown() {
        return this.host.isConnected();
    }

    public boolean isRemoteDown() {
        return this.host.isRemote();
    }

    public boolean isSecureDown() {
        return this.host.isSecure();
    }

    public String securityProtocolDown() {
        return this.host.securityProtocol();
    }

    public String cipherSuiteDown() {
        return this.host.cipherSuite();
    }

    public InetSocketAddress localAddressDown() {
        return this.host.localAddress();
    }

    public Identity localIdentityDown() {
        return this.host.localIdentity();
    }

    public Principal localPrincipalDown() {
        return this.host.localPrincipal();
    }

    public Collection<Certificate> localCertificatesDown() {
        return this.host.localCertificates();
    }

    public InetSocketAddress remoteAddressDown() {
        return this.host.remoteAddress();
    }

    public Identity remoteIdentityDown() {
        return this.host.remoteIdentity();
    }

    public Principal remotePrincipalDown() {
        return this.host.remotePrincipal();
    }

    public Collection<Certificate> remoteCertificatesDown() {
        return this.host.remoteCertificates();
    }

    public void feedDown() {
        block1: {
            WarpSocketContext warpSocketContext;
            int newStatus;
            int oldStatus;
            while (!STATUS.compareAndSet(this, oldStatus, newStatus = ((oldStatus = STATUS.get(this)) & 2) == 0 ? oldStatus & 0xFFFFFFFE | 2 : oldStatus | 1)) {
            }
            if ((oldStatus & 2) != 0 || (warpSocketContext = this.host.warpSocketContext) == null) break block1;
            warpSocketContext.feed((PullRequest)this);
        }
    }

    public void pull(PullContext<? super Envelope> pullContext) {
        this.pullContext = pullContext;
        this.linkContext.pullDown();
    }

    public void drop(Throwable reason) {
    }

    public boolean stay(StayContext context, int backlog) {
        return true;
    }

    public void pushDown(Push<?> push) {
        Object message = push.message();
        if (message instanceof Envelope) {
            int newStatus;
            int oldStatus;
            while (!STATUS.compareAndSet(this, oldStatus = STATUS.get(this), newStatus = oldStatus & 0xFFFFFFFD)) {
            }
            if (oldStatus != newStatus) {
                Envelope remoteEnvelope = ((Envelope)message).nodeUri(this.remoteNodeUri);
                PullContext<? super Envelope> pullContext = this.pullContext;
                if (pullContext != null) {
                    pullContext.push((Object)remoteEnvelope);
                    this.pullContext = null;
                    if (remoteEnvelope instanceof EventMessage) {
                        RemoteHost.DOWNLINK_EVENT_DELTA.incrementAndGet(this.host);
                        this.host.didUpdateMetrics();
                    }
                }
            }
        } else {
            push.trap((Throwable)new LinkException("unsupported message: " + message));
        }
    }

    public void skipDown() {
        block1: {
            PullContext<? super Envelope> pullContext;
            int newStatus;
            int oldStatus;
            while (!STATUS.compareAndSet(this, oldStatus = STATUS.get(this), newStatus = oldStatus & 0xFFFFFFFD)) {
            }
            if (oldStatus == newStatus || (pullContext = this.pullContext) == null) break block1;
            pullContext.skip();
            this.pullContext = null;
        }
    }

    public void queueUp(Envelope envelope) {
        block1: {
            int newStatus;
            int oldStatus;
            this.upQueue.add(envelope);
            do {
                oldStatus = STATUS.get(this);
                newStatus = oldStatus | 4;
                if (!(envelope instanceof SyncRequest)) continue;
                newStatus |= 8;
            } while (!STATUS.compareAndSet(this, oldStatus, newStatus));
            if ((oldStatus & 4) == (newStatus & 4)) break block1;
            this.linkContext.feedUp();
        }
    }

    public void pullUp() {
        int newStatus;
        int oldStatus;
        Envelope envelope = this.upQueue.poll();
        while (!STATUS.compareAndSet(this, oldStatus = STATUS.get(this), newStatus = oldStatus & 0xFFFFFFFB)) {
        }
        try {
            if (envelope != null) {
                this.linkContext.pushUp(new Push(Uri.empty(), Uri.empty(), this.nodeUri, this.laneUri, this.prio, this.host.remoteIdentity(), (Object)envelope, null));
            }
            this.feedUpQueue();
        }
        catch (Throwable error) {
            if (Cont.isNonFatal((Throwable)error)) {
                this.linkContext.didFailDown(error);
            }
            throw error;
        }
    }

    void feedUpQueue() {
        int newStatus;
        int oldStatus;
        while (!STATUS.compareAndSet(this, oldStatus = STATUS.get(this), newStatus = !this.upQueue.isEmpty() ? oldStatus | 4 : oldStatus)) {
        }
        if (oldStatus != newStatus) {
            try {
                this.linkContext.feedUp();
            }
            catch (Throwable error) {
                if (Cont.isNonFatal((Throwable)error)) {
                    this.linkContext.didFailDown(error);
                }
                throw error;
            }
        }
    }

    public void openMetaDownlink(LinkBinding downlink, NodeBinding metaDownlink) {
        this.host.openMetaDownlink(downlink, metaDownlink);
    }

    public void reopen() {
        int newStatus;
        int oldStatus;
        this.linkContext.closeUp();
        while (!STATUS.compareAndSet(this, oldStatus = STATUS.get(this), newStatus = oldStatus & 0xFFFFFFFB)) {
        }
        this.host.hostContext.openDownlink((LinkBinding)this);
        this.linkContext.didOpenDown();
        Object request = (oldStatus & 8) != 0 ? new SyncRequest(this.nodeUri, this.laneUri, this.prio, this.rate, this.body) : new LinkRequest(this.nodeUri, this.laneUri, this.prio, this.rate, this.body);
        this.queueUp((Envelope)request);
    }

    public void openDown() {
        this.linkContext.didOpenDown();
    }

    public void closeDown() {
        this.linkContext.didCloseDown();
    }

    public void didConnect() {
    }

    public void didDisconnect() {
    }

    public void didCloseUp() {
    }

    public void didFailUp(Throwable error) {
        try {
            this.didFail(error);
        }
        finally {
            this.closeDown();
        }
    }

    public void didFail(Throwable error) {
        error.printStackTrace();
    }

    public void traceDown(Object message) {
        this.host.trace(message);
    }

    public void debugDown(Object message) {
        this.host.debug(message);
    }

    public void infoDown(Object message) {
        this.host.info(message);
    }

    public void warnDown(Object message) {
        this.host.warn(message);
    }

    public void errorDown(Object message) {
        this.host.error(message);
    }

    public void failDown(Object message) {
        this.host.fail(message);
    }
}

