/*
 * Decompiled with CFR 0.152.
 */
package swim.remote;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import swim.api.LinkException;
import swim.api.auth.Identity;
import swim.concurrent.Cont;
import swim.concurrent.PullContext;
import swim.concurrent.PullRequest;
import swim.concurrent.StayContext;
import swim.io.warp.WarpSocketContext;
import swim.remote.RemoteHost;
import swim.remote.RemoteHostException;
import swim.structure.Value;
import swim.system.CellAddress;
import swim.system.DownlinkAddress;
import swim.system.LinkAddress;
import swim.system.LinkBinding;
import swim.system.LinkKeys;
import swim.system.NodeBinding;
import swim.system.Push;
import swim.system.WarpBinding;
import swim.system.WarpContext;
import swim.uri.Uri;
import swim.warp.CommandMessage;
import swim.warp.Envelope;

class RemoteWarpUplink
implements WarpContext,
PullRequest<Envelope> {
    final RemoteHost host;
    final WarpBinding link;
    final Uri remoteNodeUri;
    final Value linkKey;
    final ConcurrentLinkedQueue<Push<Envelope>> downQueue;
    PullContext<? super Envelope> pullContext;
    volatile long lastFeedDownTime;
    volatile int status;
    static final int FEEDING_DOWN = 1;
    static final int FEEDING_UP = 2;
    static final int PULLING_UP = 4;
    static final long MAX_PULL_DOWN_DELAY;
    static final long MAX_FEED_UP_DELAY;
    static final AtomicLongFieldUpdater<RemoteWarpUplink> LAST_FEED_DOWN_TIME;
    static final AtomicIntegerFieldUpdater<RemoteWarpUplink> STATUS;

    RemoteWarpUplink(RemoteHost host, WarpBinding link, Uri remoteNodeUri, Value linkKey) {
        this.host = host;
        this.link = link;
        this.remoteNodeUri = remoteNodeUri;
        this.linkKey = linkKey.commit();
        this.downQueue = new ConcurrentLinkedQueue();
        this.pullContext = null;
        this.lastFeedDownTime = 0L;
        this.status = 0;
    }

    RemoteWarpUplink(RemoteHost host, WarpBinding link, Uri remoteNodeUri) {
        this(host, link, remoteNodeUri, LinkKeys.generateLinkKey());
    }

    public final WarpBinding linkWrapper() {
        return this.link.linkWrapper();
    }

    public final WarpBinding linkBinding() {
        return this.link;
    }

    public <T> T unwrapLink(Class<T> linkClass) {
        if (linkClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    public <T> T bottomLink(Class<T> linkClass) {
        if (linkClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    public final Uri nodeUri() {
        return this.link.nodeUri();
    }

    public final Uri laneUri() {
        return this.link.laneUri();
    }

    public final Value linkKey() {
        return this.linkKey;
    }

    public LinkAddress cellAddressUp() {
        return new DownlinkAddress((CellAddress)this.host.cellAddress(), this.linkKey());
    }

    public final float prio() {
        return this.link.prio();
    }

    public boolean isConnectedUp() {
        return this.host.isConnected();
    }

    public boolean isRemoteUp() {
        return this.host.isRemote();
    }

    public boolean isSecureUp() {
        return this.host.isSecure();
    }

    public String securityProtocolUp() {
        return this.host.securityProtocol();
    }

    public String cipherSuiteUp() {
        return this.host.cipherSuite();
    }

    public InetSocketAddress localAddressUp() {
        return this.host.localAddress();
    }

    public Identity localIdentityUp() {
        return this.host.localIdentity();
    }

    public Principal localPrincipalUp() {
        return this.host.localPrincipal();
    }

    public Collection<Certificate> localCertificatesUp() {
        return this.host.localCertificates();
    }

    public InetSocketAddress remoteAddressUp() {
        return this.host.remoteAddress();
    }

    public Identity remoteIdentityUp() {
        return this.host.remoteIdentity();
    }

    public Principal remotePrincipalUp() {
        return this.host.remotePrincipal();
    }

    public Collection<Certificate> remoteCertificatesUp() {
        return this.host.remoteCertificates();
    }

    public void queueDown(Push<Envelope> push) {
        block2: {
            long pullDownDelay;
            block1: {
                int newStatus;
                int oldStatus;
                this.downQueue.add(push);
                while (!STATUS.compareAndSet(this, oldStatus = STATUS.get(this), newStatus = oldStatus | 1)) {
                }
                if (oldStatus == newStatus) break block1;
                LAST_FEED_DOWN_TIME.set(this, System.currentTimeMillis());
                this.link.feedDown();
                break block2;
            }
            long lastFeedDownTime = LAST_FEED_DOWN_TIME.get(this);
            if (lastFeedDownTime == 0L || (pullDownDelay = System.currentTimeMillis() - lastFeedDownTime) < MAX_PULL_DOWN_DELAY) break block2;
            this.link.didFailUp((Throwable)new RemoteHostException("exceeded maximum pull down delay"));
        }
    }

    public void pullDown() {
        int newStatus;
        int oldStatus;
        Push<Envelope> push = this.downQueue.poll();
        while (!STATUS.compareAndSet(this, oldStatus = STATUS.get(this), newStatus = oldStatus & 0xFFFFFFFE)) {
        }
        try {
            if (push != null) {
                this.link.pushDown(push);
                long feedDownTime = LAST_FEED_DOWN_TIME.getAndSet(this, 0L);
                this.didPullDown(System.currentTimeMillis() - feedDownTime);
            }
            this.feedDownQueue();
        }
        catch (Throwable error) {
            if (Cont.isNonFatal((Throwable)error)) {
                this.link.didFailUp(error);
            }
            throw error;
        }
    }

    void didPullDown(long pullDownLatency) {
    }

    void feedDownQueue() {
        int newStatus;
        int oldStatus;
        while (!STATUS.compareAndSet(this, oldStatus = STATUS.get(this), newStatus = !this.downQueue.isEmpty() ? oldStatus | 1 : oldStatus)) {
        }
        if (oldStatus != newStatus) {
            LAST_FEED_DOWN_TIME.set(this, System.currentTimeMillis());
            try {
                this.link.feedDown();
            }
            catch (Throwable error) {
                if (Cont.isNonFatal((Throwable)error)) {
                    this.link.didFailUp(error);
                }
                throw error;
            }
        }
    }

    public void feedUp() {
        block3: {
            int newStatus;
            int oldStatus;
            while (!STATUS.compareAndSet(this, oldStatus, newStatus = ((oldStatus = STATUS.get(this)) & 4) == 0 ? oldStatus & 0xFFFFFFFD | 4 : oldStatus | 2)) {
            }
            if ((oldStatus & 4) == 0) {
                long t0 = System.currentTimeMillis();
                do {
                    WarpSocketContext warpSocketContext;
                    if ((warpSocketContext = this.host.warpSocketContext) == null) continue;
                    warpSocketContext.feed((PullRequest)this);
                    break block3;
                } while (System.currentTimeMillis() - t0 <= MAX_FEED_UP_DELAY);
                throw new RemoteHostException("exceeded maximum feed up delay");
            }
        }
    }

    public void pull(PullContext<? super Envelope> pullContext) {
        this.pullContext = pullContext;
        this.link.pullUp();
    }

    public void drop(Throwable reason) {
    }

    public boolean stay(StayContext context, int backlog) {
        return true;
    }

    public void pushUp(Push<?> push) {
        Object message = push.message();
        if (message instanceof Envelope) {
            int newStatus;
            int oldStatus;
            while (!STATUS.compareAndSet(this, oldStatus = STATUS.get(this), newStatus = oldStatus & 0xFFFFFFFB)) {
            }
            if (oldStatus != newStatus && this.pullContext != null) {
                Envelope remoteEnvelope = ((Envelope)message).nodeUri(this.remoteNodeUri);
                this.pullContext.push((Object)remoteEnvelope);
                this.pullContext = null;
                push.bind();
                if (remoteEnvelope instanceof CommandMessage) {
                    RemoteHost.UPLINK_COMMAND_DELTA.incrementAndGet(this.host);
                    this.host.didUpdateMetrics();
                }
            }
        } else {
            push.trap((Throwable)new LinkException("unsupported message: " + message));
        }
    }

    public void skipUp() {
        block1: {
            int newStatus;
            int oldStatus;
            while (!STATUS.compareAndSet(this, oldStatus = STATUS.get(this), newStatus = oldStatus & 0xFFFFFFFB)) {
            }
            if (oldStatus == newStatus || this.pullContext == null) break block1;
            this.pullContext.skip();
            this.pullContext = null;
        }
    }

    public void openMetaUplink(LinkBinding uplink, NodeBinding metaUplink) {
        this.host.openMetaUplink(uplink, metaUplink);
    }

    public void closeUp() {
        this.host.closeUplink(this);
    }

    public void didOpenDown() {
    }

    public void didConnect() {
        this.link.didConnect();
    }

    public void didDisconnect() {
        this.link.didDisconnect();
        STATUS.set(this, 0);
        LAST_FEED_DOWN_TIME.set(this, 0L);
    }

    public void didCloseDown() {
        this.host.closeUplink(this);
    }

    public void didCloseUp() {
        this.downQueue.clear();
        this.link.didCloseUp();
    }

    public void didFailDown(Throwable error) {
        this.closeUp();
    }

    public void traceUp(Object message) {
        this.host.trace(message);
    }

    public void debugUp(Object message) {
        this.host.debug(message);
    }

    public void infoUp(Object message) {
        this.host.info(message);
    }

    public void warnUp(Object message) {
        this.host.warn(message);
    }

    public void errorUp(Object message) {
        this.host.error(message);
    }

    public void failUp(Object message) {
        this.host.fail(message);
    }

    static {
        long maxFeedUpDelay;
        long maxPullDownDelay;
        LAST_FEED_DOWN_TIME = AtomicLongFieldUpdater.newUpdater(RemoteWarpUplink.class, "lastFeedDownTime");
        STATUS = AtomicIntegerFieldUpdater.newUpdater(RemoteWarpUplink.class, "status");
        try {
            maxPullDownDelay = Long.parseLong(System.getProperty("swim.remote.max.pull.down.delay"));
        }
        catch (NumberFormatException e) {
            maxPullDownDelay = 60000L;
        }
        MAX_PULL_DOWN_DELAY = maxPullDownDelay;
        try {
            maxFeedUpDelay = Long.parseLong(System.getProperty("swim.remote.max.feed.up.delay"));
        }
        catch (NumberFormatException e) {
            maxFeedUpDelay = 1000L;
        }
        MAX_FEED_UP_DELAY = maxFeedUpDelay;
    }
}

