/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.agent;

import swim.api.Downlink;
import swim.api.auth.Identity;
import swim.api.policy.Policy;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.runtime.LaneBinding;
import swim.runtime.LaneContext;
import swim.runtime.LinkBinding;
import swim.runtime.NodeBinding;
import swim.runtime.PushRequest;
import swim.runtime.agent.AgentNode;
import swim.store.StoreBinding;
import swim.structure.Value;
import swim.uri.Uri;

public class AgentLane
implements LaneContext {
    protected final AgentNode node;
    protected final LaneBinding lane;
    protected final Uri laneUri;

    public AgentLane(AgentNode node, LaneBinding lane, Uri laneUri) {
        this.node = node;
        this.lane = lane;
        this.laneUri = laneUri;
    }

    @Override
    public final NodeBinding node() {
        return this.node;
    }

    @Override
    public final LaneBinding laneWrapper() {
        return this.lane.laneWrapper();
    }

    @Override
    public <T> T unwrapLane(Class<T> laneClass) {
        if (laneClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    @Override
    public final Uri meshUri() {
        return this.node.meshUri();
    }

    @Override
    public final Value partKey() {
        return this.node.partKey();
    }

    @Override
    public final Uri hostUri() {
        return this.node.hostUri();
    }

    @Override
    public final Uri nodeUri() {
        return this.node.nodeUri();
    }

    @Override
    public final Uri laneUri() {
        return this.laneUri;
    }

    @Override
    public final Identity identity() {
        return this.node.nodeContext().identity();
    }

    @Override
    public Policy policy() {
        return this.node.policy();
    }

    @Override
    public Schedule schedule() {
        return this.node;
    }

    @Override
    public Stage stage() {
        return this.node;
    }

    @Override
    public StoreBinding store() {
        return this.node.store();
    }

    @Override
    public LinkBinding bindDownlink(Downlink downlink) {
        return this.node.bindDownlink(downlink);
    }

    @Override
    public void openDownlink(LinkBinding link) {
        this.node.openDownlink(link);
    }

    @Override
    public void closeDownlink(LinkBinding link) {
    }

    @Override
    public void pushDown(PushRequest pushRequest) {
        this.node.pushDown(pushRequest);
    }

    public void trace(Object message) {
        this.node.trace(message);
    }

    public void debug(Object message) {
        this.node.debug(message);
    }

    public void info(Object message) {
        this.node.info(message);
    }

    public void warn(Object message) {
        this.node.warn(message);
    }

    public void error(Object message) {
        this.node.error(message);
    }

    @Override
    public void close() {
        this.node.closeLane(this.laneUri);
    }

    @Override
    public void willOpen() {
        this.lane.open();
    }

    @Override
    public void didOpen() {
    }

    @Override
    public void willLoad() {
        this.lane.load();
    }

    @Override
    public void didLoad() {
    }

    @Override
    public void willStart() {
        this.lane.start();
    }

    @Override
    public void didStart() {
    }

    @Override
    public void willStop() {
        this.lane.stop();
    }

    @Override
    public void didStop() {
    }

    @Override
    public void willUnload() {
        this.lane.unload();
    }

    @Override
    public void didUnload() {
    }

    @Override
    public void willClose() {
        this.lane.close();
    }
}

