/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import swim.api.Lane;
import swim.api.Link;
import swim.api.SwimContext;
import swim.api.agent.AgentContext;
import swim.api.data.ListData;
import swim.api.lane.ListLane;
import swim.api.warp.function.DidCommand;
import swim.api.warp.function.DidEnter;
import swim.api.warp.function.DidLeave;
import swim.api.warp.function.DidUplink;
import swim.api.warp.function.WillCommand;
import swim.api.warp.function.WillEnter;
import swim.api.warp.function.WillLeave;
import swim.api.warp.function.WillUplink;
import swim.concurrent.Conts;
import swim.observable.function.DidClear;
import swim.observable.function.DidDrop;
import swim.observable.function.DidMoveIndex;
import swim.observable.function.DidRemoveIndex;
import swim.observable.function.DidTake;
import swim.observable.function.DidUpdateIndex;
import swim.observable.function.WillClear;
import swim.observable.function.WillDrop;
import swim.observable.function.WillMoveIndex;
import swim.observable.function.WillRemoveIndex;
import swim.observable.function.WillTake;
import swim.observable.function.WillUpdateIndex;
import swim.runtime.lane.ListLaneModel;
import swim.runtime.warp.WarpLaneView;
import swim.structure.Form;
import swim.util.KeyedList;

public class ListLaneView<V>
extends WarpLaneView
implements ListLane<V> {
    protected final AgentContext agentContext;
    protected Form<V> valueForm;
    protected int flags;
    protected ListLaneModel laneBinding;
    protected ListData<V> dataView;
    static final int RESIDENT = 1;
    static final int TRANSIENT = 2;
    static final int SIGNED = 4;

    ListLaneView(AgentContext agentContext, Form<V> valueForm, int flags, Object observers) {
        super(observers);
        this.agentContext = agentContext;
        this.valueForm = valueForm;
        this.flags = flags;
    }

    public ListLaneView(AgentContext agentContext, Form<V> valueForm) {
        this(agentContext, valueForm, 0, null);
    }

    @Override
    public AgentContext agentContext() {
        return this.agentContext;
    }

    @Override
    public ListLaneModel laneBinding() {
        return this.laneBinding;
    }

    void setLaneBinding(ListLaneModel laneBinding) {
        this.laneBinding = laneBinding;
    }

    @Override
    public ListLaneModel createLaneBinding() {
        return new ListLaneModel(this.flags);
    }

    public final Form<V> valueForm() {
        return this.valueForm;
    }

    public <V2> ListLaneView<V2> valueForm(Form<V2> valueForm) {
        return new ListLaneView<V2>(this.agentContext, valueForm, this.flags, this.typesafeObservers(this.observers));
    }

    public <V2> ListLaneView<V2> valueClass(Class<V2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    public void setValueForm(Form<V> valueForm) {
        this.valueForm = valueForm;
    }

    protected Object typesafeObservers(Object observers) {
        return observers;
    }

    public final boolean isResident() {
        return (this.flags & 1) != 0;
    }

    public ListLaneView<V> isResident(boolean isResident) {
        this.flags = isResident ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        ListLaneModel laneBinding = this.laneBinding;
        if (laneBinding != null) {
            laneBinding.isResident(isResident);
        }
        return this;
    }

    void didSetResident(boolean isResident) {
        this.flags = isResident ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public final boolean isTransient() {
        return (this.flags & 2) != 0;
    }

    public ListLaneView<V> isTransient(boolean isTransient) {
        this.flags = isTransient ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
        ListLaneModel laneBinding = this.laneBinding;
        if (laneBinding != null) {
            laneBinding.isTransient(isTransient);
        }
        return this;
    }

    void didSetTransient(boolean isTransient) {
        this.flags = isTransient ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    @Override
    protected void willLoad() {
        this.dataView = this.laneBinding.data.valueForm(this.valueForm);
        super.willLoad();
    }

    @Override
    public void close() {
        this.laneBinding.closeLaneView(this);
    }

    @Override
    public ListLaneView<V> observe(Object observer) {
        super.observe(observer);
        return this;
    }

    @Override
    public ListLaneView<V> unobserve(Object observer) {
        super.unobserve(observer);
        return this;
    }

    public ListLaneView<V> willUpdate(WillUpdateIndex<V> willUpdate) {
        return this.observe(willUpdate);
    }

    public ListLaneView<V> didUpdate(DidUpdateIndex<V> didUpdate) {
        return this.observe(didUpdate);
    }

    public ListLaneView<V> willMove(WillMoveIndex<V> willMove) {
        return this.observe(willMove);
    }

    public ListLaneView<V> didMove(DidMoveIndex<V> didMove) {
        return this.observe(didMove);
    }

    public ListLaneView<V> willRemove(WillRemoveIndex willRemove) {
        return this.observe(willRemove);
    }

    public ListLaneView<V> didRemove(DidRemoveIndex<V> didRemove) {
        return this.observe(didRemove);
    }

    public ListLaneView<V> willDrop(WillDrop willDrop) {
        return this.observe(willDrop);
    }

    public ListLaneView<V> didDrop(DidDrop didDrop) {
        return this.observe(didDrop);
    }

    public ListLaneView<V> willTake(WillTake willTake) {
        return this.observe(willTake);
    }

    public ListLaneView<V> didTake(DidTake didTake) {
        return this.observe(didTake);
    }

    public ListLaneView<V> willClear(WillClear willClear) {
        return this.observe(willClear);
    }

    public ListLaneView<V> didClear(DidClear didClear) {
        return this.observe(didClear);
    }

    @Override
    public ListLaneView<V> willCommand(WillCommand willCommand) {
        return this.observe(willCommand);
    }

    @Override
    public ListLaneView<V> didCommand(DidCommand didCommand) {
        return this.observe(didCommand);
    }

    @Override
    public ListLaneView<V> willUplink(WillUplink willUplink) {
        return this.observe(willUplink);
    }

    @Override
    public ListLaneView<V> didUplink(DidUplink didUplink) {
        return this.observe(didUplink);
    }

    @Override
    public ListLaneView<V> willEnter(WillEnter willEnter) {
        return this.observe(willEnter);
    }

    @Override
    public ListLaneView<V> didEnter(DidEnter didEnter) {
        return this.observe(didEnter);
    }

    @Override
    public ListLaneView<V> willLeave(WillLeave willLeave) {
        return this.observe(willLeave);
    }

    @Override
    public ListLaneView<V> didLeave(DidLeave didLeave) {
        return this.observe(didLeave);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry<Boolean, V> dispatchWillUpdate(Link link, int index, V newValue, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillUpdateIndex) {
                if (((WillUpdateIndex)observers).isPreemptive() == preemptive) {
                    try {
                        newValue = ((WillUpdateIndex)observers).willUpdate(index, newValue);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillUpdateIndex)) continue;
                    if (((WillUpdateIndex)observer).isPreemptive() == preemptive) {
                        try {
                            newValue = ((WillUpdateIndex)observer).willUpdate(index, newValue);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            AbstractMap.SimpleImmutableEntry<Boolean, V> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<Boolean, V>(complete, newValue);
            return simpleImmutableEntry;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidUpdate(Link link, int index, V newValue, V oldValue, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidUpdateIndex) {
                if (((DidUpdateIndex)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidUpdateIndex)observers).didUpdate(index, newValue, oldValue);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidUpdateIndex)) continue;
                    if (((DidUpdateIndex)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidUpdateIndex)observer).didUpdate(index, newValue, oldValue);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchWillMove(Link link, int fromIndex, int toIndex, V value, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillMoveIndex) {
                if (((WillMoveIndex)observers).isPreemptive() == preemptive) {
                    try {
                        ((WillMoveIndex)observers).willMove(fromIndex, toIndex, value);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillMoveIndex)) continue;
                    if (((WillMoveIndex)observer).isPreemptive() == preemptive) {
                        try {
                            ((WillMoveIndex)observer).willMove(fromIndex, toIndex, value);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidMove(Link link, int fromIndex, int toIndex, V value, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidMoveIndex) {
                if (((DidMoveIndex)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidMoveIndex)observers).didMove(fromIndex, toIndex, value);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidMoveIndex)) continue;
                    if (((DidMoveIndex)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidMoveIndex)observer).didMove(fromIndex, toIndex, value);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchWillRemove(Link link, int index, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillRemoveIndex) {
                if (((WillRemoveIndex)observers).isPreemptive() == preemptive) {
                    try {
                        ((WillRemoveIndex)observers).willRemove(index);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillRemoveIndex)) continue;
                    if (((WillRemoveIndex)observer).isPreemptive() == preemptive) {
                        try {
                            ((WillRemoveIndex)observer).willRemove(index);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidRemove(Link link, int index, V oldValue, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidRemoveIndex) {
                if (((DidRemoveIndex)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidRemoveIndex)observers).didRemove(index, oldValue);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidRemoveIndex)) continue;
                    if (((DidRemoveIndex)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidRemoveIndex)observer).didRemove(index, oldValue);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchWillDrop(Link link, int lower, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillDrop) {
                if (((WillDrop)observers).isPreemptive() == preemptive) {
                    try {
                        ((WillDrop)observers).willDrop(lower);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillDrop)) continue;
                    if (((WillDrop)observer).isPreemptive() == preemptive) {
                        try {
                            ((WillDrop)observer).willDrop(lower);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidDrop(Link link, int lower, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidDrop) {
                if (((DidDrop)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidDrop)observers).didDrop(lower);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidDrop)) continue;
                    if (((DidDrop)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidDrop)observer).didDrop(lower);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchWillTake(Link link, int upper, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillTake) {
                if (((WillTake)observers).isPreemptive() == preemptive) {
                    try {
                        ((WillTake)observers).willTake(upper);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillTake)) continue;
                    if (((WillTake)observer).isPreemptive() == preemptive) {
                        try {
                            ((WillTake)observer).willTake(upper);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidTake(Link link, int upper, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidTake) {
                if (((DidTake)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidTake)observers).didTake(upper);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidTake)) continue;
                    if (((DidTake)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidTake)observer).didTake(upper);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchWillClear(Link link, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof WillClear) {
                if (((WillClear)observers).isPreemptive() == preemptive) {
                    try {
                        ((WillClear)observers).willClear();
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof WillClear)) continue;
                    if (((WillClear)observer).isPreemptive() == preemptive) {
                        try {
                            ((WillClear)observer).willClear();
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidClear(Link link, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLane((Lane)this);
            SwimContext.setLink((Link)link);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidClear) {
                if (((DidClear)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidClear)observers).didClear();
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidClear)) continue;
                    if (((DidClear)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidClear)observer).didClear();
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    public V laneWillInsert(int index, V newValue) {
        return newValue;
    }

    public void laneDidInsert(int index, V newValue) {
    }

    public V laneWillUpdate(int index, V newValue) {
        return newValue;
    }

    public void laneDidUpdate(int index, V newValue, V oldValue) {
    }

    public void laneWillMove(int fromIndex, int toIndex, V value) {
    }

    public void laneDidMove(int fromIndex, int toIndex, V value) {
    }

    public void laneWillRemove(int index) {
    }

    public void laneDidRemove(int index, V oldValue) {
    }

    public void laneWillDrop(int lower) {
    }

    public void laneDidDrop(int lower) {
    }

    public void laneWillTake(int upper) {
    }

    public void laneDidTake(int upper) {
    }

    public void laneWillClear() {
    }

    public void laneDidClear() {
    }

    public boolean isEmpty() {
        return this.dataView.isEmpty();
    }

    public boolean contains(Object o) {
        return this.dataView.contains(o);
    }

    public Iterator<V> iterator() {
        return this.dataView.iterator();
    }

    public Object[] toArray() {
        return this.dataView.toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.dataView.toArray((Object[])a);
    }

    public boolean add(V v) {
        return this.laneBinding.add(this, this.size(), v);
    }

    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index != -1) {
            Object oldObject = this.laneBinding.remove(this, index);
            return oldObject != null && oldObject != this.valueForm.unit();
        }
        return false;
    }

    public boolean containsAll(Collection<?> elements) {
        return this.dataView.containsAll(elements);
    }

    public boolean addAll(Collection<? extends V> elements) {
        boolean added = false;
        for (V element : elements) {
            added = added || this.add(element);
        }
        return added;
    }

    public boolean addAll(int index, Collection<? extends V> elements) {
        int position = index;
        for (V element : elements) {
            this.add(position++, element);
        }
        return elements.isEmpty();
    }

    public boolean removeAll(Collection<?> elements) {
        boolean didRemove = false;
        for (Object element : elements) {
            int index = this.indexOf(element);
            if (index == -1) continue;
            didRemove = didRemove || this.remove(element);
        }
        return didRemove;
    }

    public boolean retainAll(Collection<?> elements) {
        boolean modified = false;
        for (Object element : elements) {
            if (elements.contains(element)) continue;
            modified = modified || this.remove(element);
        }
        return modified;
    }

    public int size() {
        return this.dataView.size();
    }

    public void drop(int lower) {
        this.laneBinding.drop(this, lower);
    }

    public void take(int upper) {
        this.laneBinding.take(this, upper);
    }

    public void clear() {
        this.laneBinding.clear(this);
    }

    public V get(int index) {
        return (V)this.dataView.get(index);
    }

    public V set(int index, V element) {
        return this.laneBinding.set(this, index, element);
    }

    public void add(int index, V element) {
        this.laneBinding.add(this, index, element);
    }

    public V remove(int index) {
        return this.laneBinding.remove(this, index);
    }

    public int indexOf(Object o) {
        return this.dataView.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.dataView.lastIndexOf(o);
    }

    public ListIterator<V> listIterator() {
        return this.dataView.listIterator();
    }

    public ListIterator<V> listIterator(int index) {
        return this.dataView.listIterator(index);
    }

    public List<V> subList(int fromIndex, int toIndex) {
        return this.dataView.subList(fromIndex, toIndex);
    }

    public KeyedList<V> snapshot() {
        return this.dataView.snapshot();
    }

    public V get(int index, Object key) {
        return (V)this.dataView.get(index, key);
    }

    public Map.Entry<Object, V> getEntry(int index) {
        return this.dataView.getEntry(index);
    }

    public Map.Entry<Object, V> getEntry(int index, Object key) {
        return this.dataView.getEntry(index, key);
    }

    public V set(int index, V element, Object key) {
        return this.laneBinding.set(this, index, element, key);
    }

    public boolean add(V element, Object key) {
        return this.laneBinding.add(this, this.size(), element, key);
    }

    public void add(int index, V element, Object key) {
        this.laneBinding.add(this, index, element, key);
    }

    public V remove(int index, Object key) {
        return this.laneBinding.remove(this, index, key);
    }

    public void move(int fromIndex, int toIndex) {
        this.laneBinding.move(fromIndex, toIndex);
    }

    public void move(int fromIndex, int toIndex, Object key) {
        this.laneBinding.move(fromIndex, toIndex, key);
    }

    public ListIterator<Object> keyIterator() {
        return this.dataView.keyIterator();
    }

    public ListIterator<Map.Entry<Object, V>> entryIterator() {
        return this.dataView.entryIterator();
    }
}

