/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import swim.api.Link;
import swim.concurrent.Stage;
import swim.runtime.LaneRelay;
import swim.runtime.lane.MapLaneModel;
import swim.runtime.lane.MapLaneView;
import swim.structure.Record;
import swim.structure.Value;
import swim.warp.CommandMessage;

final class MapLaneRelayClear
extends LaneRelay<MapLaneModel, MapLaneView<?, ?>> {
    final Link link;
    final CommandMessage message;

    MapLaneRelayClear(MapLaneModel model, CommandMessage message) {
        super(model, 4);
        this.link = null;
        this.message = message;
    }

    MapLaneRelayClear(MapLaneModel model, Link link) {
        super(model, 1, 3, null);
        this.link = link;
        this.message = null;
    }

    MapLaneRelayClear(MapLaneModel model, Stage stage) {
        super(model, 1, 3, stage);
        this.link = null;
        this.message = null;
    }

    @Override
    protected void beginPhase(int phase) {
        if (phase == 2) {
            ((MapLaneModel)this.model).data.clear();
        }
    }

    @Override
    protected boolean runPhase(MapLaneView<?, ?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.laneWillCommand(this.message);
            }
            return view.dispatchWillCommand(this.message.body(), preemptive);
        }
        if (phase == 1) {
            if (preemptive) {
                view.laneWillClear();
            }
            return view.dispatchWillClear(this.link, preemptive);
        }
        if (phase == 2) {
            if (preemptive) {
                view.laneDidClear();
            }
            return view.dispatchDidClear(this.link, preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.laneDidCommand(this.message);
            }
            return view.dispatchDidCommand(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    protected void done() {
        ((MapLaneModel)this.model).sendDown((Value)Record.create((int)1).attr("clear"));
    }
}

