/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import java.util.Map;
import swim.api.Link;
import swim.concurrent.Stage;
import swim.math.Z2Form;
import swim.runtime.LaneRelay;
import swim.runtime.lane.SpatialLaneModel;
import swim.runtime.lane.SpatialLaneView;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;
import swim.warp.CommandMessage;

final class SpatialLaneRelayUpdate<S>
extends LaneRelay<SpatialLaneModel<S>, SpatialLaneView<?, S, ?>> {
    final Link link;
    final CommandMessage message;
    Form<Object> keyForm;
    Z2Form<Object> shapeForm;
    Form<Object> valueForm;
    final Value key;
    Object keyObject;
    final S shapeObject;
    Value oldValue;
    Object oldObject;
    Value newValue;
    Object newObject;

    SpatialLaneRelayUpdate(SpatialLaneModel<S> model, CommandMessage message, Value key, S shapeObject, Value newValue) {
        super(model, 4);
        this.link = null;
        this.message = message;
        this.key = key;
        this.shapeObject = shapeObject;
        this.newValue = newValue;
    }

    SpatialLaneRelayUpdate(SpatialLaneModel<S> model, Link link, Value key, S shapeObject, Value newValue) {
        super(model, 1, 3, null);
        this.link = link;
        this.message = null;
        this.key = key;
        this.shapeObject = shapeObject;
        this.newValue = newValue;
    }

    SpatialLaneRelayUpdate(SpatialLaneModel<S> model, Stage stage, Value key, S shapeObject, Value newValue) {
        super(model, 1, 3, stage);
        this.link = null;
        this.message = null;
        this.key = key;
        this.shapeObject = shapeObject;
        this.newValue = newValue;
    }

    @Override
    protected void beginPhase(int phase) {
        if (phase == 2) {
            this.oldValue = (Value)((SpatialLaneModel)this.model).data.put((Object)this.key, this.shapeObject, (Object)this.newValue);
            if (this.valueForm != null) {
                this.oldObject = this.valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = this.valueForm.unit();
                }
            }
        }
    }

    @Override
    protected boolean runPhase(SpatialLaneView<?, S, ?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.laneWillCommand(this.message);
            }
            return view.dispatchWillCommand(this.message.body(), preemptive);
        }
        if (phase == 1) {
            Form valueForm;
            Form keyForm = view.keyForm;
            if (this.keyForm != keyForm && keyForm != null) {
                this.keyForm = keyForm;
                this.keyObject = keyForm.cast((Item)this.key);
                if (this.keyObject == null) {
                    this.keyObject = keyForm.unit();
                }
            }
            if (this.valueForm != (valueForm = view.valueForm) && valueForm != null) {
                this.valueForm = valueForm;
                this.oldObject = valueForm.cast((Item)this.newValue);
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
            }
            if (preemptive) {
                this.newObject = view.laneWillUpdate(this.keyObject, this.shapeObject, this.oldObject);
            }
            Map.Entry<Boolean, Object> result = view.dispatchWillUpdate(this.link, this.keyObject, this.shapeObject, this.oldObject, preemptive);
            this.newObject = result.getValue();
            if (this.oldObject != this.newObject) {
                this.oldObject = this.newObject;
                this.oldValue = this.newValue = valueForm.mold(this.newObject).toValue();
            }
            return result.getKey();
        }
        if (phase == 2) {
            Form valueForm;
            Form keyForm = view.keyForm;
            if (this.keyForm != keyForm && keyForm != null) {
                this.keyForm = keyForm;
                this.keyObject = keyForm.cast((Item)this.key);
                if (this.keyObject == null) {
                    this.keyObject = keyForm.unit();
                }
            }
            if (this.valueForm != (valueForm = view.valueForm) && valueForm != null) {
                this.valueForm = valueForm;
                this.oldObject = valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
                this.newObject = valueForm.cast((Item)this.newValue);
                if (this.newObject == null) {
                    this.newObject = valueForm.unit();
                }
            }
            if (preemptive) {
                view.laneDidUpdate(this.keyObject, this.shapeObject, this.newObject, this.oldObject);
            }
            return view.dispatchDidUpdate(this.link, this.keyObject, this.shapeObject, this.newObject, this.oldObject, preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.laneDidCommand(this.message);
            }
            return view.dispatchDidCommand(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    protected void done() {
        ((SpatialLaneModel)this.model).cueDownKey(this.key);
    }
}

