/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.router;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.Downlink;
import swim.api.policy.Policy;
import swim.collections.HashTrieMap;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.runtime.AbstractTierBinding;
import swim.runtime.HostBinding;
import swim.runtime.HostContext;
import swim.runtime.LinkBinding;
import swim.runtime.NodeBinding;
import swim.runtime.NodeContext;
import swim.runtime.PartBinding;
import swim.runtime.PushRequest;
import swim.runtime.TierBinding;
import swim.runtime.TierContext;
import swim.runtime.UplinkError;
import swim.runtime.router.HostTableNode;
import swim.store.StoreBinding;
import swim.structure.Value;
import swim.uri.Uri;

public class HostTable
extends AbstractTierBinding
implements HostBinding {
    protected HostContext hostContext;
    volatile HashTrieMap<Uri, NodeBinding> nodes = HashTrieMap.empty();
    volatile int flags;
    static final int PRIMARY = 1;
    static final int REPLICA = 2;
    static final int MASTER = 4;
    static final int SLAVE = 8;
    static final AtomicReferenceFieldUpdater<HostTable, HashTrieMap<Uri, NodeBinding>> NODES = AtomicReferenceFieldUpdater.newUpdater(HostTable.class, HashTrieMap.class, "nodes");
    static final AtomicIntegerFieldUpdater<HostTable> FLAGS = AtomicIntegerFieldUpdater.newUpdater(HostTable.class, "flags");

    @Override
    public final TierContext tierContext() {
        return this.hostContext;
    }

    @Override
    public final PartBinding part() {
        return this.hostContext.part();
    }

    @Override
    public final HostBinding hostWrapper() {
        return this;
    }

    @Override
    public final HostContext hostContext() {
        return this.hostContext;
    }

    @Override
    public void setHostContext(HostContext hostContext) {
        this.hostContext = hostContext;
    }

    @Override
    public <T> T unwrapHost(Class<T> hostClass) {
        if (hostClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return this.hostContext.unwrapHost(hostClass);
    }

    protected NodeContext createNodeContext(NodeBinding node, Uri nodeUri) {
        return new HostTableNode(this, node, nodeUri);
    }

    @Override
    public final Uri meshUri() {
        return this.hostContext.meshUri();
    }

    @Override
    public final Value partKey() {
        return this.hostContext.partKey();
    }

    @Override
    public final Uri hostUri() {
        return this.hostContext.hostUri();
    }

    @Override
    public Policy policy() {
        return this.hostContext.policy();
    }

    @Override
    public Schedule schedule() {
        return this.hostContext.schedule();
    }

    @Override
    public Stage stage() {
        return this.hostContext.stage();
    }

    @Override
    public StoreBinding store() {
        return this.hostContext.store();
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    public boolean isPrimary() {
        return (this.flags & 1) != 0;
    }

    @Override
    public void setPrimary(boolean isPrimary) {
        int newFlags;
        int oldFlags;
        while ((oldFlags = this.flags) != (newFlags = oldFlags | 1) && !FLAGS.compareAndSet(this, oldFlags, newFlags)) {
        }
    }

    @Override
    public boolean isReplica() {
        return (this.flags & 2) != 0;
    }

    @Override
    public void setReplica(boolean isReplica) {
        int newFlags;
        int oldFlags;
        while ((oldFlags = this.flags) != (newFlags = oldFlags | 2) && !FLAGS.compareAndSet(this, oldFlags, newFlags)) {
        }
    }

    @Override
    public boolean isMaster() {
        return (this.flags & 4) != 0;
    }

    @Override
    public boolean isSlave() {
        return (this.flags & 8) != 0;
    }

    @Override
    public void didBecomeMaster() {
        int newFlags;
        int oldFlags;
        while ((oldFlags = this.flags) != (newFlags = oldFlags & 0xFFFFFFF7 | 4) && !FLAGS.compareAndSet(this, oldFlags, newFlags)) {
        }
    }

    @Override
    public void didBecomeSlave() {
        int newFlags;
        int oldFlags;
        while ((oldFlags = this.flags) != (newFlags = oldFlags & 0xFFFFFFFB | 8) && !FLAGS.compareAndSet(this, oldFlags, newFlags)) {
        }
        if (oldFlags != newFlags) {
            this.closeNodes();
        }
    }

    @Override
    public HashTrieMap<Uri, NodeBinding> nodes() {
        return this.nodes;
    }

    @Override
    public NodeBinding getNode(Uri nodeUri) {
        return (NodeBinding)this.nodes.get((Object)nodeUri);
    }

    @Override
    public NodeBinding openNode(Uri nodeUri) {
        HashTrieMap newNodes;
        HashTrieMap oldNodes;
        TierBinding nodeBinding = null;
        do {
            NodeBinding node;
            if ((node = (NodeBinding)(oldNodes = this.nodes).get((Object)nodeUri)) != null) {
                if (nodeBinding != null) {
                    nodeBinding.close();
                }
                nodeBinding = node;
                newNodes = oldNodes;
                break;
            }
            if (nodeBinding == null) {
                nodeBinding = this.hostContext.createNode(nodeUri);
                if (nodeBinding != null) {
                    nodeBinding = this.hostContext.injectNode(nodeUri, (NodeBinding)nodeBinding);
                    NodeContext nodeContext = this.createNodeContext((NodeBinding)nodeBinding, nodeUri);
                    nodeBinding.setNodeContext(nodeContext);
                    nodeBinding = nodeBinding.nodeWrapper();
                    nodeBinding.openLanes((NodeBinding)nodeBinding);
                    nodeBinding.openAgents((NodeBinding)nodeBinding);
                    newNodes = oldNodes.updated((Object)nodeUri, (Object)nodeBinding);
                    continue;
                }
                newNodes = oldNodes;
                break;
            }
            newNodes = oldNodes.updated((Object)nodeUri, (Object)nodeBinding);
        } while (oldNodes != newNodes && !NODES.compareAndSet(this, (HashTrieMap<Uri, NodeBinding>)oldNodes, (HashTrieMap<Uri, NodeBinding>)newNodes));
        if (oldNodes != newNodes) {
            this.activate(nodeBinding);
        }
        return nodeBinding;
    }

    @Override
    public NodeBinding openNode(Uri nodeUri, NodeBinding node) {
        HashTrieMap newNodes;
        HashTrieMap oldNodes;
        NodeBinding nodeBinding = null;
        do {
            if ((oldNodes = this.nodes).containsKey((Object)nodeUri)) {
                nodeBinding = null;
                newNodes = oldNodes;
                break;
            }
            if (nodeBinding != null) continue;
            nodeBinding = this.hostContext.injectNode(nodeUri, node);
            NodeContext nodeContext = this.createNodeContext(nodeBinding, nodeUri);
            nodeBinding.setNodeContext(nodeContext);
            nodeBinding = nodeBinding.nodeWrapper();
            nodeBinding.openLanes(nodeBinding);
            nodeBinding.openAgents(nodeBinding);
        } while (oldNodes != (newNodes = oldNodes.updated((Object)nodeUri, nodeBinding)) && !NODES.compareAndSet(this, (HashTrieMap<Uri, NodeBinding>)oldNodes, (HashTrieMap<Uri, NodeBinding>)newNodes));
        if (nodeBinding != null) {
            this.activate(nodeBinding);
        }
        return nodeBinding;
    }

    public void closeNode(Uri nodeUri) {
        HashTrieMap newNodes;
        HashTrieMap oldNodes;
        NodeBinding nodeBinding = null;
        do {
            NodeBinding node;
            if ((node = (NodeBinding)(oldNodes = this.nodes).get((Object)nodeUri)) == null) {
                nodeBinding = null;
                newNodes = oldNodes;
                break;
            }
            nodeBinding = node;
            newNodes = oldNodes.removed((Object)nodeUri);
        } while (oldNodes != newNodes && !NODES.compareAndSet(this, (HashTrieMap<Uri, NodeBinding>)oldNodes, (HashTrieMap<Uri, NodeBinding>)newNodes));
        if (nodeBinding != null) {
            nodeBinding.didClose();
        }
    }

    public void closeNodes() {
        HashTrieMap<Uri, NodeBinding> oldNodes;
        HashTrieMap newNodes = HashTrieMap.empty();
        while ((oldNodes = this.nodes) != newNodes && !NODES.compareAndSet(this, oldNodes, (HashTrieMap<Uri, NodeBinding>)newNodes)) {
        }
        for (NodeBinding nodeBinding : oldNodes.values()) {
            nodeBinding.close();
            nodeBinding.didClose();
        }
    }

    @Override
    public LinkBinding bindDownlink(Downlink downlink) {
        return this.hostContext.bindDownlink(downlink);
    }

    @Override
    public void openDownlink(LinkBinding link) {
        this.hostContext.openDownlink(link);
    }

    @Override
    public void closeDownlink(LinkBinding link) {
        this.hostContext.closeDownlink(link);
    }

    @Override
    public void pushDown(PushRequest pushRequest) {
        this.hostContext.pushDown(pushRequest);
    }

    @Override
    public void openUplink(LinkBinding link) {
        NodeBinding nodeBinding = this.openNode(link.nodeUri());
        if (nodeBinding != null) {
            nodeBinding.openUplink(link);
        } else {
            UplinkError.rejectNodeNotFound(link);
        }
    }

    @Override
    public void pushUp(PushRequest pushRequest) {
        NodeBinding nodeBinding = this.openNode(pushRequest.envelope().nodeUri());
        if (nodeBinding != null) {
            nodeBinding.pushUp(pushRequest);
        } else {
            pushRequest.didDecline();
        }
    }

    public void trace(Object message) {
        this.hostContext.trace(message);
    }

    public void debug(Object message) {
        this.hostContext.debug(message);
    }

    public void info(Object message) {
        this.hostContext.info(message);
    }

    public void warn(Object message) {
        this.hostContext.warn(message);
    }

    public void error(Object message) {
        this.hostContext.error(message);
    }

    @Override
    protected void willOpen() {
        super.willOpen();
        Iterator nodesIterator = this.nodes.valueIterator();
        while (nodesIterator.hasNext()) {
            ((NodeBinding)nodesIterator.next()).open();
        }
    }

    @Override
    protected void willLoad() {
        super.willLoad();
        Iterator nodesIterator = this.nodes.valueIterator();
        while (nodesIterator.hasNext()) {
            ((NodeBinding)nodesIterator.next()).load();
        }
    }

    @Override
    protected void willStart() {
        super.willStart();
        Iterator nodesIterator = this.nodes.valueIterator();
        while (nodesIterator.hasNext()) {
            ((NodeBinding)nodesIterator.next()).start();
        }
    }

    @Override
    protected void willStop() {
        super.willStop();
        Iterator nodesIterator = this.nodes.valueIterator();
        while (nodesIterator.hasNext()) {
            ((NodeBinding)nodesIterator.next()).stop();
        }
    }

    @Override
    protected void willUnload() {
        super.willUnload();
        Iterator nodesIterator = this.nodes.valueIterator();
        while (nodesIterator.hasNext()) {
            ((NodeBinding)nodesIterator.next()).unload();
        }
    }

    @Override
    protected void willClose() {
        super.willClose();
        Iterator nodesIterator = this.nodes.valueIterator();
        while (nodesIterator.hasNext()) {
            ((NodeBinding)nodesIterator.next()).close();
        }
    }

    @Override
    public void didClose() {
    }

    @Override
    public void didFail(Throwable error) {
        error.printStackTrace();
    }
}

