/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.router;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.Downlink;
import swim.api.policy.Policy;
import swim.collections.FingerTrieSeq;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.runtime.AbstractTierBinding;
import swim.runtime.EdgeBinding;
import swim.runtime.LinkBinding;
import swim.runtime.MeshBinding;
import swim.runtime.MeshContext;
import swim.runtime.PartBinding;
import swim.runtime.PartContext;
import swim.runtime.PushRequest;
import swim.runtime.TierBinding;
import swim.runtime.TierContext;
import swim.runtime.UplinkError;
import swim.runtime.router.MeshTablePart;
import swim.store.StoreBinding;
import swim.structure.Extant;
import swim.structure.Text;
import swim.structure.Value;
import swim.uri.Uri;

public class MeshTable
extends AbstractTierBinding
implements MeshBinding {
    protected MeshContext meshContext;
    volatile FingerTrieSeq<PartBinding> parts = FingerTrieSeq.empty();
    volatile PartBinding gateway;
    volatile PartBinding ourself;
    static final AtomicReferenceFieldUpdater<MeshTable, FingerTrieSeq<PartBinding>> PARTS = AtomicReferenceFieldUpdater.newUpdater(MeshTable.class, FingerTrieSeq.class, "parts");

    @Override
    public final TierContext tierContext() {
        return this.meshContext;
    }

    @Override
    public final EdgeBinding edge() {
        return this.meshContext.edge();
    }

    @Override
    public final MeshBinding meshWrapper() {
        return this;
    }

    @Override
    public final MeshContext meshContext() {
        return this.meshContext;
    }

    @Override
    public void setMeshContext(MeshContext meshContext) {
        this.meshContext = meshContext;
    }

    @Override
    public <T> T unwrapMesh(Class<T> meshClass) {
        if (meshClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return this.meshContext.unwrapMesh(meshClass);
    }

    protected PartContext createPartContext(PartBinding part, Value partKey) {
        return new MeshTablePart(this, part, partKey);
    }

    @Override
    public final Uri meshUri() {
        return this.meshContext.meshUri();
    }

    @Override
    public Policy policy() {
        return this.meshContext.policy();
    }

    @Override
    public Schedule schedule() {
        return this.meshContext.schedule();
    }

    @Override
    public Stage stage() {
        return this.meshContext.stage();
    }

    @Override
    public StoreBinding store() {
        return this.meshContext.store();
    }

    @Override
    public PartBinding gateway() {
        return this.gateway;
    }

    @Override
    public void setGateway(PartBinding gateway) {
        this.gateway = gateway;
    }

    @Override
    public PartBinding ourself() {
        return this.ourself;
    }

    @Override
    public void setOurself(PartBinding ourself) {
        this.ourself = ourself;
    }

    @Override
    public FingerTrieSeq<PartBinding> parts() {
        return this.parts;
    }

    boolean isMetaNode(Uri nodeUri) {
        return !this.meshUri().isDefined() && "swim".equals(nodeUri.schemeName());
    }

    @Override
    public PartBinding getPart(Uri nodeUri) {
        if (this.isMetaNode(nodeUri)) {
            return this.ourself;
        }
        FingerTrieSeq<PartBinding> parts = this.parts;
        int n = parts.size();
        for (int i = 0; i < n; ++i) {
            PartBinding part = (PartBinding)parts.get(i);
            if (!part.predicate().test(nodeUri)) continue;
            return part;
        }
        return this.gateway;
    }

    @Override
    public PartBinding getPart(Value partKey) {
        FingerTrieSeq<PartBinding> parts = this.parts;
        int n = parts.size();
        for (int i = 0; i < n; ++i) {
            PartBinding part = (PartBinding)parts.get(i);
            if (!partKey.equals((Object)part.partKey())) continue;
            return part;
        }
        return null;
    }

    @Override
    public PartBinding openPart(Uri nodeUri) {
        FingerTrieSeq newParts;
        FingerTrieSeq oldParts;
        TierBinding partBinding = null;
        Object partKey = Value.absent();
        do {
            oldParts = this.parts;
            PartBinding part = null;
            if (this.isMetaNode(nodeUri)) {
                part = this.ourself;
            } else {
                int n = oldParts.size();
                for (int i = 0; i < n; ++i) {
                    PartBinding oldPart = (PartBinding)oldParts.get(i);
                    if (!oldPart.predicate().test(nodeUri)) continue;
                    part = oldPart;
                    break;
                }
            }
            if (part != null) {
                if (partBinding != null) {
                    partBinding.close();
                }
                partBinding = part;
                newParts = oldParts;
                break;
            }
            if (partBinding == null) {
                partKey = this.isMetaNode(nodeUri) ? Text.from((String)"swim") : Value.absent();
                partBinding = this.meshContext.createPart((Value)partKey);
                if (partBinding != null) {
                    partBinding = this.meshContext.injectPart((Value)partKey, (PartBinding)partBinding);
                    PartContext partContext = this.createPartContext((PartBinding)partBinding, (Value)partKey);
                    partBinding.setPartContext(partContext);
                    partBinding = partBinding.partWrapper();
                    newParts = oldParts.appended((Object)partBinding);
                    continue;
                }
                newParts = oldParts;
                break;
            }
            newParts = oldParts.appended((Object)partBinding);
        } while (oldParts != newParts && !PARTS.compareAndSet(this, (FingerTrieSeq<PartBinding>)oldParts, (FingerTrieSeq<PartBinding>)newParts));
        if (oldParts != newParts) {
            if (partKey instanceof Extant) {
                this.gateway = partBinding;
            } else if (this.isMetaNode(nodeUri)) {
                this.ourself = partBinding;
            }
            this.activate(partBinding);
        }
        return partBinding;
    }

    @Override
    public PartBinding openGateway() {
        FingerTrieSeq newParts;
        FingerTrieSeq oldParts;
        TierBinding partBinding = null;
        do {
            oldParts = this.parts;
            PartBinding part = this.gateway;
            if (part != null) {
                if (partBinding != null) {
                    partBinding.close();
                }
                partBinding = part;
                newParts = oldParts;
                break;
            }
            if (partBinding == null) {
                Value partKey = Value.absent();
                partBinding = this.meshContext.createPart(partKey);
                if (partBinding != null) {
                    partBinding = this.meshContext.injectPart(partKey, (PartBinding)partBinding);
                    PartContext partContext = this.createPartContext((PartBinding)partBinding, partKey);
                    partBinding.setPartContext(partContext);
                    partBinding = partBinding.partWrapper();
                    newParts = oldParts.appended((Object)partBinding);
                    continue;
                }
                newParts = oldParts;
                break;
            }
            newParts = oldParts.appended((Object)partBinding);
        } while (oldParts != newParts && !PARTS.compareAndSet(this, (FingerTrieSeq<PartBinding>)oldParts, (FingerTrieSeq<PartBinding>)newParts));
        if (oldParts != newParts) {
            this.gateway = partBinding;
            this.activate(partBinding);
        }
        return partBinding;
    }

    @Override
    public PartBinding addPart(Value partKey, PartBinding part) {
        FingerTrieSeq newParts;
        FingerTrieSeq<PartBinding> oldParts;
        PartBinding partBinding = null;
        do {
            PartBinding oldPart;
            oldParts = this.parts;
            int n = oldParts.size();
            for (int i = 0; i < n && !partKey.equals((Object)(oldPart = (PartBinding)oldParts.get(i)).partKey()); ++i) {
            }
            if (partBinding != null) continue;
            partBinding = this.meshContext.injectPart(partKey, part);
            PartContext partContext = this.createPartContext(partBinding, partKey);
            partBinding.setPartContext(partContext);
            partBinding = partBinding.partWrapper();
        } while (oldParts != (newParts = oldParts.appended(partBinding)) && !PARTS.compareAndSet(this, oldParts, (FingerTrieSeq<PartBinding>)newParts));
        if (partBinding != null) {
            this.activate(partBinding);
        }
        return partBinding;
    }

    public void closePart(Value partKey) {
        PartBinding partBinding;
        FingerTrieSeq newParts;
        FingerTrieSeq oldParts;
        block0: do {
            newParts = oldParts = this.parts;
            partBinding = null;
            int n = oldParts.size();
            for (int i = 0; i < n; ++i) {
                PartBinding part = (PartBinding)oldParts.get(i);
                if (!partKey.equals((Object)part.partKey())) continue;
                partBinding = part;
                newParts = oldParts.removed(i);
                continue block0;
            }
        } while (oldParts != newParts && !PARTS.compareAndSet(this, oldParts, newParts));
        if (partBinding != null) {
            if (this.gateway == partBinding) {
                this.gateway = null;
            } else if (this.ourself == partBinding) {
                this.ourself = null;
            }
            partBinding.didClose();
        }
    }

    @Override
    public LinkBinding bindDownlink(Downlink downlink) {
        return this.meshContext.bindDownlink(downlink);
    }

    @Override
    public void openDownlink(LinkBinding link) {
        this.meshContext.openDownlink(link);
    }

    @Override
    public void closeDownlink(LinkBinding link) {
    }

    @Override
    public void openUplink(LinkBinding link) {
        PartBinding partBinding = this.openPart(link.nodeUri());
        if (partBinding != null) {
            partBinding.openUplink(link);
        } else {
            UplinkError.rejectPartNotFound(link);
        }
    }

    @Override
    public void pushDown(PushRequest pushRequest) {
        this.meshContext.pushDown(pushRequest);
    }

    @Override
    public void pushUp(PushRequest pushRequest) {
        PartBinding partBinding = this.openPart(pushRequest.nodeUri());
        if (partBinding != null) {
            partBinding.pushUp(pushRequest);
        } else {
            pushRequest.didDecline();
        }
    }

    public void trace(Object message) {
        this.meshContext.trace(message);
    }

    public void debug(Object message) {
        this.meshContext.debug(message);
    }

    public void info(Object message) {
        this.meshContext.info(message);
    }

    public void warn(Object message) {
        this.meshContext.warn(message);
    }

    public void error(Object message) {
        this.meshContext.error(message);
    }

    @Override
    protected void willOpen() {
        super.willOpen();
        Iterator partsIterator = this.parts.iterator();
        while (partsIterator.hasNext()) {
            ((PartBinding)partsIterator.next()).open();
        }
    }

    @Override
    protected void willLoad() {
        super.willLoad();
        Iterator partsIterator = this.parts.iterator();
        while (partsIterator.hasNext()) {
            ((PartBinding)partsIterator.next()).load();
        }
    }

    @Override
    protected void willStart() {
        super.willStart();
        Iterator partsIterator = this.parts.iterator();
        while (partsIterator.hasNext()) {
            ((PartBinding)partsIterator.next()).start();
        }
    }

    @Override
    protected void willStop() {
        super.willStop();
        Iterator partsIterator = this.parts.iterator();
        while (partsIterator.hasNext()) {
            ((PartBinding)partsIterator.next()).stop();
        }
    }

    @Override
    protected void willUnload() {
        super.willUnload();
        Iterator partsIterator = this.parts.iterator();
        while (partsIterator.hasNext()) {
            ((PartBinding)partsIterator.next()).unload();
        }
    }

    @Override
    protected void willClose() {
        super.willClose();
        Iterator partsIterator = this.parts.iterator();
        while (partsIterator.hasNext()) {
            ((PartBinding)partsIterator.next()).close();
        }
    }

    @Override
    public void didClose() {
    }

    @Override
    public void didFail(Throwable error) {
        error.printStackTrace();
    }
}

