/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.warp;

import swim.api.auth.Identity;
import swim.api.warp.WarpUplink;
import swim.collections.FingerTrieSeq;
import swim.runtime.LaneModel;
import swim.runtime.LinkBinding;
import swim.runtime.PushRequest;
import swim.runtime.WarpBinding;
import swim.runtime.warp.WarpLaneRelayDidEnter;
import swim.runtime.warp.WarpLaneRelayDidLeave;
import swim.runtime.warp.WarpLaneRelayDidUplink;
import swim.runtime.warp.WarpLaneRelayOnCommand;
import swim.runtime.warp.WarpLaneView;
import swim.runtime.warp.WarpUplinkModem;
import swim.structure.Value;
import swim.warp.CommandMessage;
import swim.warp.Envelope;

public abstract class WarpLaneModel<View extends WarpLaneView, U extends WarpUplinkModem>
extends LaneModel<View, U> {
    @Override
    protected U createUplink(LinkBinding link) {
        if (link instanceof WarpBinding) {
            return this.createWarpUplink((WarpBinding)link);
        }
        return null;
    }

    protected abstract U createWarpUplink(WarpBinding var1);

    public void cueDown() {
        FingerTrieSeq uplinks;
        FingerTrieSeq closedLinks = FingerTrieSeq.empty();
        do {
            uplinks = this.uplinks;
            int n = uplinks.size();
            for (int i = 0; i < n; ++i) {
                WarpUplinkModem uplink = (WarpUplinkModem)uplinks.get(i);
                if (uplink.isConnected()) {
                    uplink.cueDown();
                    continue;
                }
                closedLinks = closedLinks.appended((Object)uplink.linkKey());
            }
        } while (uplinks != this.uplinks);
        for (Value linkKey : closedLinks) {
            this.closeUplink(linkKey);
        }
    }

    public void sendDown(Value body) {
        FingerTrieSeq uplinks;
        FingerTrieSeq closedLinks = FingerTrieSeq.empty();
        do {
            uplinks = this.uplinks;
            int n = uplinks.size();
            for (int i = 0; i < n; ++i) {
                WarpUplinkModem uplink = (WarpUplinkModem)uplinks.get(i);
                if (uplink.isConnected()) {
                    uplink.sendDown(body);
                    continue;
                }
                closedLinks = closedLinks.appended((Object)uplink.linkKey());
            }
        } while (uplinks != this.uplinks);
        for (Value linkKey : closedLinks) {
            this.closeUplink(linkKey);
        }
    }

    @Override
    public void pushUp(PushRequest pushRequest) {
        Envelope envelope = pushRequest.envelope();
        if (envelope instanceof CommandMessage) {
            this.onCommand((CommandMessage)envelope);
            pushRequest.didDeliver();
        } else {
            pushRequest.didDecline();
        }
    }

    @Override
    public void pushUpCommand(CommandMessage message) {
        this.onCommand(message);
    }

    protected void onCommand(CommandMessage message) {
        new WarpLaneRelayOnCommand(this, message).run();
    }

    @Override
    protected void didUplink(U uplink) {
        new WarpLaneRelayDidUplink(this, (WarpUplink)uplink).run();
    }

    protected void didEnter(Identity identity) {
        new WarpLaneRelayDidEnter(this, identity).run();
    }

    protected void didLeave(Identity identity) {
        new WarpLaneRelayDidLeave(this, identity).run();
    }
}

