/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import swim.api.auth.Identity;
import swim.api.downlink.EventDownlink;
import swim.api.downlink.ListDownlink;
import swim.api.downlink.MapDownlink;
import swim.api.downlink.ValueDownlink;
import swim.api.http.HttpDownlink;
import swim.api.ref.HostRef;
import swim.api.ref.LaneRef;
import swim.api.ref.NodeRef;
import swim.api.ref.SwimRef;
import swim.api.ws.WsDownlink;
import swim.concurrent.Cont;
import swim.runtime.CellContext;
import swim.runtime.Push;
import swim.runtime.downlink.EventDownlinkView;
import swim.runtime.downlink.ListDownlinkView;
import swim.runtime.downlink.MapDownlinkView;
import swim.runtime.downlink.ValueDownlinkView;
import swim.runtime.scope.HostScope;
import swim.runtime.scope.LaneScope;
import swim.runtime.scope.NodeScope;
import swim.structure.Form;
import swim.structure.Value;
import swim.uri.Uri;
import swim.uri.UriAuthority;
import swim.uri.UriFragment;
import swim.uri.UriPath;
import swim.uri.UriQuery;
import swim.uri.UriScheme;
import swim.warp.CommandMessage;

public abstract class AbstractSwimRef
implements SwimRef,
CellContext {
    public HostRef hostRef(Uri hostUri) {
        return new HostScope(this, this.stage(), this.meshUri(), hostUri);
    }

    public HostRef hostRef(String hostUri) {
        return this.hostRef(Uri.parse((String)hostUri));
    }

    public NodeRef nodeRef(Uri hostUri, Uri nodeUri) {
        if (nodeUri.authority().isDefined()) {
            nodeUri = Uri.from((UriPath)nodeUri.path(), (UriQuery)nodeUri.query(), (UriFragment)nodeUri.fragment());
        }
        return new NodeScope(this, this.stage(), this.meshUri(), hostUri, nodeUri);
    }

    public NodeRef nodeRef(String hostUri, String nodeUri) {
        return this.nodeRef(Uri.parse((String)hostUri), Uri.parse((String)nodeUri));
    }

    public NodeRef nodeRef(Uri nodeUri) {
        Uri hostUri;
        if (nodeUri.authority().isDefined()) {
            hostUri = Uri.from((UriScheme)nodeUri.scheme(), (UriAuthority)nodeUri.authority());
            nodeUri = Uri.from((UriPath)nodeUri.path(), (UriQuery)nodeUri.query(), (UriFragment)nodeUri.fragment());
        } else {
            hostUri = Uri.empty();
            nodeUri = Uri.from((UriScheme)nodeUri.scheme(), (UriAuthority)UriAuthority.undefined(), (UriPath)nodeUri.path(), (UriQuery)nodeUri.query(), (UriFragment)nodeUri.fragment());
        }
        return new NodeScope(this, this.stage(), this.meshUri(), hostUri, nodeUri);
    }

    public NodeRef nodeRef(String nodeUri) {
        return this.nodeRef(Uri.parse((String)nodeUri));
    }

    public LaneRef laneRef(Uri hostUri, Uri nodeUri, Uri laneUri) {
        if (nodeUri.authority().isDefined()) {
            nodeUri = Uri.from((UriPath)nodeUri.path(), (UriQuery)nodeUri.query(), (UriFragment)nodeUri.fragment());
        }
        return new LaneScope(this, this.stage(), this.meshUri(), hostUri, nodeUri, laneUri);
    }

    public LaneRef laneRef(String hostUri, String nodeUri, String laneUri) {
        return this.laneRef(Uri.parse((String)hostUri), Uri.parse((String)nodeUri), Uri.parse((String)laneUri));
    }

    public LaneRef laneRef(Uri nodeUri, Uri laneUri) {
        Uri hostUri;
        if (nodeUri.authority().isDefined()) {
            hostUri = Uri.from((UriScheme)nodeUri.scheme(), (UriAuthority)nodeUri.authority());
            nodeUri = Uri.from((UriPath)nodeUri.path(), (UriQuery)nodeUri.query(), (UriFragment)nodeUri.fragment());
        } else {
            hostUri = Uri.empty();
            nodeUri = Uri.from((UriScheme)nodeUri.scheme(), (UriAuthority)UriAuthority.undefined(), (UriPath)nodeUri.path(), (UriQuery)nodeUri.query(), (UriFragment)nodeUri.fragment());
        }
        return new LaneScope(this, this.stage(), this.meshUri(), hostUri, nodeUri, laneUri);
    }

    public LaneRef laneRef(String nodeUri, String laneUri) {
        return this.laneRef(Uri.parse((String)nodeUri), Uri.parse((String)laneUri));
    }

    public EventDownlink<Value> downlink() {
        return new EventDownlinkView<Value>(this, this.stage(), this.meshUri(), Uri.empty(), Uri.empty(), Uri.empty(), 0.0f, 0.0f, Value.absent(), Form.forValue());
    }

    public ListDownlink<Value> downlinkList() {
        return new ListDownlinkView<Value>(this, this.stage(), this.meshUri(), Uri.empty(), Uri.empty(), Uri.empty(), 0.0f, 0.0f, Value.absent(), Form.forValue());
    }

    public MapDownlink<Value, Value> downlinkMap() {
        return new MapDownlinkView<Value, Value>((CellContext)this, this.stage(), this.meshUri(), Uri.empty(), Uri.empty(), Uri.empty(), 0.0f, 0.0f, Value.absent(), Form.forValue(), Form.forValue());
    }

    public ValueDownlink<Value> downlinkValue() {
        return new ValueDownlinkView<Value>(this, this.stage(), this.meshUri(), Uri.empty(), Uri.empty(), Uri.empty(), 0.0f, 0.0f, Value.absent(), Form.forValue());
    }

    public <V> HttpDownlink<V> downlinkHttp() {
        return null;
    }

    public <I, O> WsDownlink<I, O> downlinkWs() {
        return null;
    }

    public void command(Uri hostUri, Uri nodeUri, Uri laneUri, float prio, Value body, Cont<CommandMessage> cont) {
        Uri meshUri = this.meshUri();
        if (!meshUri.isDefined()) {
            meshUri = hostUri;
        }
        if (nodeUri.authority().isDefined()) {
            nodeUri = Uri.from((UriPath)nodeUri.path(), (UriQuery)nodeUri.query(), (UriFragment)nodeUri.fragment());
        }
        Identity identity = null;
        CommandMessage message = new CommandMessage(nodeUri, laneUri, body);
        this.pushDown(new Push<CommandMessage>(meshUri, hostUri, nodeUri, laneUri, prio, identity, message, cont));
    }

    public void command(String hostUri, String nodeUri, String laneUri, float prio, Value body, Cont<CommandMessage> cont) {
        this.command(Uri.parse((String)hostUri), Uri.parse((String)nodeUri), Uri.parse((String)laneUri), prio, body, cont);
    }

    public void command(Uri hostUri, Uri nodeUri, Uri laneUri, Value body, Cont<CommandMessage> cont) {
        this.command(hostUri, nodeUri, laneUri, 0.0f, body, cont);
    }

    public void command(String hostUri, String nodeUri, String laneUri, Value body, Cont<CommandMessage> cont) {
        this.command(Uri.parse((String)hostUri), Uri.parse((String)nodeUri), Uri.parse((String)laneUri), body, cont);
    }

    public void command(Uri nodeUri, Uri laneUri, float prio, Value body, Cont<CommandMessage> cont) {
        Uri hostUri;
        Uri meshUri = this.meshUri();
        if (nodeUri.authority().isDefined()) {
            hostUri = Uri.from((UriScheme)nodeUri.scheme(), (UriAuthority)nodeUri.authority());
            nodeUri = Uri.from((UriPath)nodeUri.path(), (UriQuery)nodeUri.query(), (UriFragment)nodeUri.fragment());
        } else {
            hostUri = Uri.empty();
        }
        if (!meshUri.isDefined()) {
            meshUri = hostUri;
        }
        Identity identity = null;
        CommandMessage message = new CommandMessage(nodeUri, laneUri, body);
        this.pushDown(new Push<CommandMessage>(meshUri, hostUri, nodeUri, laneUri, prio, identity, message, cont));
    }

    public void command(String nodeUri, String laneUri, float prio, Value body, Cont<CommandMessage> cont) {
        this.command(Uri.parse((String)nodeUri), Uri.parse((String)laneUri), prio, body, cont);
    }

    public void command(Uri nodeUri, Uri laneUri, Value body, Cont<CommandMessage> cont) {
        this.command(nodeUri, laneUri, 0.0f, body, cont);
    }

    public void command(String nodeUri, String laneUri, Value body, Cont<CommandMessage> cont) {
        this.command(Uri.parse((String)nodeUri), Uri.parse((String)laneUri), body, cont);
    }

    public void command(Uri hostUri, Uri nodeUri, Uri laneUri, float prio, Value body) {
        this.command(hostUri, nodeUri, laneUri, prio, body, null);
    }

    public void command(String hostUri, String nodeUri, String laneUri, float prio, Value body) {
        this.command(Uri.parse((String)hostUri), Uri.parse((String)nodeUri), Uri.parse((String)laneUri), prio, body, null);
    }

    public void command(Uri hostUri, Uri nodeUri, Uri laneUri, Value body) {
        this.command(hostUri, nodeUri, laneUri, 0.0f, body, null);
    }

    public void command(String hostUri, String nodeUri, String laneUri, Value body) {
        this.command(Uri.parse((String)hostUri), Uri.parse((String)nodeUri), Uri.parse((String)laneUri), body, null);
    }

    public void command(Uri nodeUri, Uri laneUri, float prio, Value body) {
        this.command(nodeUri, laneUri, prio, body, null);
    }

    public void command(String nodeUri, String laneUri, float prio, Value body) {
        this.command(Uri.parse((String)nodeUri), Uri.parse((String)laneUri), prio, body, null);
    }

    public void command(Uri nodeUri, Uri laneUri, Value body) {
        this.command(nodeUri, laneUri, 0.0f, body, null);
    }

    public void command(String nodeUri, String laneUri, Value body) {
        this.command(Uri.parse((String)nodeUri), Uri.parse((String)laneUri), body, null);
    }

    public abstract void close();
}

