/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import swim.runtime.PartPredicate;
import swim.structure.Item;
import swim.structure.Value;
import swim.structure.operator.AndOperator;
import swim.uri.Uri;
import swim.util.Murmur3;

final class AndPartPredicate
extends PartPredicate {
    private static int hashSeed;
    final PartPredicate[] predicates;

    AndPartPredicate(PartPredicate[] predicates) {
        this.predicates = predicates;
    }

    AndPartPredicate(PartPredicate f, PartPredicate g) {
        this(new PartPredicate[]{f, g});
    }

    @Override
    public boolean test(Uri nodeUri, int nodeHash) {
        PartPredicate[] predicates = this.predicates;
        int n = predicates.length;
        for (int i = 0; i < n; ++i) {
            if (predicates[i].test(nodeUri, nodeHash)) continue;
            return false;
        }
        return true;
    }

    @Override
    public PartPredicate and(PartPredicate that) {
        PartPredicate[] predicates = this.predicates;
        int n = predicates.length;
        PartPredicate[] newPredicates = new PartPredicate[n + 1];
        System.arraycopy(predicates, 0, newPredicates, 0, n);
        newPredicates[n] = that;
        return new AndPartPredicate(newPredicates);
    }

    @Override
    public Value toValue() {
        PartPredicate[] predicates = this.predicates;
        int n = predicates.length;
        if (n > 0) {
            Value value = predicates[0].toValue();
            for (int i = 1; i < n; ++i) {
                value = new AndOperator((Item)value, (Item)predicates[i].toValue());
            }
            return value;
        }
        return Value.absent();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof AndPartPredicate) {
            AndPartPredicate that = (AndPartPredicate)other;
            int n = this.predicates.length;
            if (n == that.predicates.length) {
                for (int i = 0; i < n; ++i) {
                    if (this.predicates[i].equals(that.predicates[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(AndPartPredicate.class);
        }
        int code = hashSeed;
        int n = this.predicates.length;
        for (int i = 0; i < n; ++i) {
            code = Murmur3.mix((int)code, (int)this.predicates[i].hashCode());
        }
        return Murmur3.mash((int)code);
    }

    public String toString() {
        StringBuilder s = new StringBuilder("PartPredicate").append('.').append("and").append('(');
        int n = this.predicates.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(this.predicates[i]);
        }
        return s.append(')').toString();
    }
}

