/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.runtime.CellAddress;
import swim.util.Murmur3;

public final class AuthenticatorAddress
implements CellAddress,
Debug {
    final String authenticatorName;
    private static int hashSeed;

    public AuthenticatorAddress(String authenticatorName) {
        this.authenticatorName = authenticatorName;
    }

    public String authenticatorName() {
        return this.authenticatorName;
    }

    public AuthenticatorAddress authenticatorName(String authenticatorName) {
        return this.copy(authenticatorName);
    }

    AuthenticatorAddress copy(String authenticatorName) {
        return new AuthenticatorAddress(authenticatorName);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof AuthenticatorAddress) {
            AuthenticatorAddress that = (AuthenticatorAddress)other;
            return this.authenticatorName.equals(that.authenticatorName);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.hash(AuthenticatorAddress.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.authenticatorName.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("AuthenticatorAddress").write(46).write("from").write(40).debug((Object)this.authenticatorName).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static AuthenticatorAddress from(String authenticatorName) {
        return new AuthenticatorAddress(authenticatorName);
    }
}

