/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import swim.concurrent.Conts;
import swim.concurrent.Stage;
import swim.runtime.DownlinkModel;
import swim.runtime.DownlinkView;

public abstract class DownlinkRelay<Model extends DownlinkModel<View>, View extends DownlinkView>
implements Runnable {
    protected final Model model;
    protected final Object views;
    protected final int viewCount;
    protected final int phaseCount;
    protected int viewIndex;
    protected int phase;
    protected boolean preemptive;
    protected Stage stage;

    protected DownlinkRelay(Model model, int minPhase, int phaseCount, Stage stage) {
        this.model = model;
        this.views = ((DownlinkModel)model).views;
        this.viewCount = this.views instanceof DownlinkView ? 1 : (this.views instanceof DownlinkView[] ? ((DownlinkView[])this.views).length : 0);
        this.phase = minPhase;
        this.phaseCount = phaseCount;
        this.preemptive = true;
        this.stage = stage;
        this.beginPhase(this.phase);
    }

    protected DownlinkRelay(Model model, int phaseCount) {
        this(model, 0, phaseCount, null);
    }

    protected DownlinkRelay(Model model) {
        this(model, 0, 1, null);
    }

    public boolean isDone() {
        return this.phase > this.phaseCount;
    }

    protected void beginPhase(int phase) {
    }

    protected boolean runPhase(View view, int phase, boolean preemptive) {
        return true;
    }

    protected void endPhase(int phase) {
    }

    protected void done() {
    }

    void pass(View view) {
        block6: {
            while (true) {
                if (this.viewIndex < this.viewCount) {
                    try {
                        if (!this.runPhase(view, this.phase, this.preemptive) && this.preemptive) {
                            this.preemptive = false;
                            if (this.stage == ((DownlinkView)view).stage) continue;
                            this.stage = ((DownlinkView)view).stage;
                            this.stage.execute((Runnable)this);
                            return;
                        }
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            ((DownlinkView)view).downlinkDidFail(error);
                        }
                        throw error;
                    }
                    ++this.viewIndex;
                    continue;
                }
                if (this.phase >= this.phaseCount) break block6;
                this.endPhase(this.phase);
                this.viewIndex = 0;
                ++this.phase;
                this.preemptive = true;
                if (this.phase >= this.phaseCount) break;
                this.beginPhase(this.phase);
            }
            this.endPhase(this.phase);
            ++this.phase;
            this.done();
            return;
        }
    }

    void pass(DownlinkView[] views) {
        block6: {
            while (true) {
                if (this.viewIndex < this.viewCount) {
                    DownlinkView view = views[this.viewIndex];
                    try {
                        if (!this.runPhase(view, this.phase, this.preemptive) && this.preemptive) {
                            this.preemptive = false;
                            if (this.stage == view.stage) continue;
                            this.stage = view.stage;
                            this.stage.execute((Runnable)this);
                            return;
                        }
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            view.downlinkDidFail(error);
                        }
                        throw error;
                    }
                    ++this.viewIndex;
                    continue;
                }
                if (this.phase >= this.phaseCount) break block6;
                this.endPhase(this.phase);
                this.viewIndex = 0;
                ++this.phase;
                this.preemptive = true;
                if (this.phase >= this.phaseCount) break;
                this.beginPhase(this.phase);
            }
            this.endPhase(this.phase);
            ++this.phase;
            this.done();
            return;
        }
    }

    @Override
    public void run() {
        Stage stage = this.stage;
        long t0 = System.nanoTime();
        try {
            if (this.viewCount == 1) {
                this.pass((DownlinkView)this.views);
            } else if (this.viewCount > 1) {
                this.pass((DownlinkView[])this.views);
            }
        }
        catch (Throwable error) {
            if (Conts.isNonFatal((Throwable)error)) {
                ((DownlinkModel)this.model).didFail(error);
            }
            throw error;
        }
        long dt = System.nanoTime() - t0;
        if (stage == null) {
            ((DownlinkModel)this.model).accumulateExecTime(dt);
        }
    }
}

