/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.Downlink;
import swim.api.Link;
import swim.api.SwimContext;
import swim.api.auth.Identity;
import swim.api.function.DidClose;
import swim.api.function.DidConnect;
import swim.api.function.DidDisconnect;
import swim.api.function.DidFail;
import swim.collections.FingerTrieSeq;
import swim.concurrent.Conts;
import swim.concurrent.Stage;
import swim.runtime.CellContext;
import swim.runtime.DownlinkModel;

public abstract class DownlinkView
implements Downlink {
    static final AtomicReferenceFieldUpdater<DownlinkView, Object> OBSERVERS = AtomicReferenceFieldUpdater.newUpdater(DownlinkView.class, Object.class, "observers");
    protected final CellContext cellContext;
    protected final Stage stage;
    protected volatile Object observers;

    public DownlinkView(CellContext cellContext, Stage stage, Object observers) {
        this.cellContext = cellContext;
        this.stage = stage;
        this.observers = observers;
    }

    public final CellContext cellContext() {
        return this.cellContext;
    }

    public abstract DownlinkModel<?> downlinkModel();

    public final Stage stage() {
        return this.stage;
    }

    public boolean isConnected() {
        DownlinkModel<?> model = this.downlinkModel();
        return model != null && model.isConnected();
    }

    public boolean isRemote() {
        DownlinkModel<?> model = this.downlinkModel();
        return model != null && model.isRemote();
    }

    public boolean isSecure() {
        DownlinkModel<?> model = this.downlinkModel();
        return model != null && model.isSecure();
    }

    public String securityProtocol() {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            return model.securityProtocol();
        }
        return null;
    }

    public String cipherSuite() {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            return model.cipherSuite();
        }
        return null;
    }

    public InetSocketAddress localAddress() {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            return model.localAddress();
        }
        return null;
    }

    public Identity localIdentity() {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            return model.localIdentity();
        }
        return null;
    }

    public Principal localPrincipal() {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            return model.localPrincipal();
        }
        return null;
    }

    public Collection<Certificate> localCertificates() {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            return model.localCertificates();
        }
        return FingerTrieSeq.empty();
    }

    public InetSocketAddress remoteAddress() {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            return model.remoteAddress();
        }
        return null;
    }

    public Identity remoteIdentity() {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            return model.remoteIdentity();
        }
        return null;
    }

    public Principal remotePrincipal() {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            return model.remotePrincipal();
        }
        return null;
    }

    public Collection<Certificate> remoteCertificates() {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            return model.remoteCertificates();
        }
        return FingerTrieSeq.empty();
    }

    public DownlinkView observe(Object newObserver) {
        Object[] newObservers;
        Object oldObservers;
        do {
            if ((oldObservers = this.observers) == null) {
                newObservers = newObserver;
                continue;
            }
            if (!(oldObservers instanceof Object[])) {
                Object[] newArray = new Object[]{oldObservers, newObserver};
                newObservers = newArray;
                continue;
            }
            Object[] oldArray = (Object[])oldObservers;
            int oldCount = oldArray.length;
            Object[] newArray = new Object[oldCount + 1];
            System.arraycopy(oldArray, 0, newArray, 0, oldCount);
            newArray[oldCount] = newObserver;
            newObservers = newArray;
        } while (!OBSERVERS.compareAndSet(this, oldObservers, newObservers));
        return this;
    }

    public DownlinkView unobserve(Object oldObserver) {
        Object oldObservers;
        while ((oldObservers = this.observers) != null) {
            Object[] newObservers;
            if (!(oldObservers instanceof Object[])) {
                if (oldObservers != oldObserver) break;
                newObservers = null;
            } else {
                Object[] oldArray = (Object[])oldObservers;
                int oldCount = oldArray.length;
                if (oldCount == 2) {
                    if (oldArray[0] == oldObserver) {
                        newObservers = oldArray[1];
                    } else {
                        if (oldArray[1] != oldObserver) break;
                        newObservers = oldArray[0];
                    }
                } else {
                    int i;
                    for (i = 0; i < oldCount && oldArray[i] != oldObserver; ++i) {
                    }
                    if (i >= oldCount) break;
                    Object[] newArray = new Object[oldCount - 1];
                    System.arraycopy(oldArray, 0, newArray, 0, i);
                    System.arraycopy(oldArray, i + 1, newArray, i, oldCount - 1 - i);
                    newObservers = newArray;
                }
            }
            if (!OBSERVERS.compareAndSet(this, oldObservers, newObservers)) continue;
            break;
        }
        return this;
    }

    public abstract DownlinkView didConnect(DidConnect var1);

    public abstract DownlinkView didDisconnect(DidDisconnect var1);

    public abstract DownlinkView didClose(DidClose var1);

    public abstract DownlinkView didFail(DidFail var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidConnect(boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLink((Link)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidConnect) {
                if (((DidConnect)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidConnect)observers).didConnect();
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.downlinkDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidConnect)) continue;
                    if (((DidConnect)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidConnect)observer).didConnect();
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidDisconnect(boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLink((Link)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidDisconnect) {
                if (((DidDisconnect)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidDisconnect)observers).didDisconnect();
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.downlinkDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidDisconnect)) continue;
                    if (((DidDisconnect)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidDisconnect)observer).didDisconnect();
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidClose(boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLink((Link)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidClose) {
                if (((DidClose)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidClose)observers).didClose();
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.downlinkDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidClose)) continue;
                    if (((DidClose)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidClose)observer).didClose();
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchDidFail(Throwable cause, boolean preemptive) {
        Link oldLink = SwimContext.getLink();
        try {
            SwimContext.setLink((Link)this);
            Object observers = this.observers;
            boolean complete = true;
            if (observers instanceof DidFail) {
                if (((DidFail)observers).isPreemptive() == preemptive) {
                    try {
                        ((DidFail)observers).didFail(cause);
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.downlinkDidFail(error);
                        }
                        throw error;
                    }
                }
                if (preemptive) {
                    complete = false;
                }
            } else if (observers instanceof Object[]) {
                for (Object observer : (Object[])observers) {
                    if (!(observer instanceof DidFail)) continue;
                    if (((DidFail)observer).isPreemptive() == preemptive) {
                        try {
                            ((DidFail)observer).didFail(cause);
                            continue;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.downlinkDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) continue;
                    complete = false;
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
        }
    }

    public void downlinkDidConnect() {
    }

    public void downlinkDidDisconnect() {
    }

    public void downlinkDidClose() {
    }

    public void downlinkDidFail(Throwable error) {
    }

    public abstract DownlinkModel<?> createDownlinkModel();

    public abstract DownlinkView open();

    public void close() {
        this.downlinkModel().removeDownlink(this);
    }

    public void trace(Object message) {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            model.trace(message);
        }
    }

    public void debug(Object message) {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            model.debug(message);
        }
    }

    public void info(Object message) {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            model.info(message);
        }
    }

    public void warn(Object message) {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            model.warn(message);
        }
    }

    public void error(Object message) {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            model.error(message);
        }
    }

    public void fail(Object message) {
        DownlinkModel<?> model = this.downlinkModel();
        if (model != null) {
            model.fail(message);
        }
    }
}

