/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.runtime.EdgeAddressed;
import swim.runtime.MeshAddress;
import swim.uri.Uri;
import swim.util.Murmur3;

public final class EdgeAddress
implements EdgeAddressed,
Debug {
    final String edgeName;
    private static int hashSeed;

    public EdgeAddress(String edgeName) {
        this.edgeName = edgeName;
    }

    @Override
    public String edgeName() {
        return this.edgeName;
    }

    public EdgeAddress edgeName(String edgeName) {
        return this.copy(edgeName);
    }

    EdgeAddress copy(String edgeName) {
        return new EdgeAddress(edgeName);
    }

    @Override
    public MeshAddress meshUri(Uri meshUri) {
        return new MeshAddress(this.edgeName, meshUri);
    }

    @Override
    public MeshAddress meshUri(String meshUri) {
        return this.meshUri(Uri.parse((String)meshUri));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof EdgeAddress) {
            EdgeAddress that = (EdgeAddress)other;
            return this.edgeName.equals(that.edgeName);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.hash(EdgeAddress.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.edgeName.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("EdgeAddress").write(46).write("from").write(40).debug((Object)this.edgeName).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static EdgeAddress from(String edgeName) {
        return new EdgeAddress(edgeName);
    }
}

