/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import swim.api.auth.Identity;
import swim.codec.Decoder;
import swim.http.HttpRequest;
import swim.http.HttpResponse;
import swim.runtime.CellContext;
import swim.runtime.HttpBinding;
import swim.runtime.HttpContext;
import swim.runtime.LinkAddress;
import swim.runtime.LinkBinding;
import swim.runtime.LinkContext;
import swim.runtime.NodeBinding;
import swim.structure.Value;
import swim.uri.Uri;

public abstract class HttpProxy
implements HttpBinding,
HttpContext {
    protected final HttpBinding linkBinding;
    protected HttpContext linkContext;

    public HttpProxy(HttpBinding linkBinding) {
        this.linkBinding = linkBinding;
    }

    public final HttpBinding linkBinding() {
        return this.linkBinding;
    }

    @Override
    public final HttpBinding linkWrapper() {
        return this.linkBinding.linkWrapper();
    }

    @Override
    public final HttpContext linkContext() {
        return this.linkContext;
    }

    @Override
    public void setLinkContext(LinkContext linkContext) {
        this.linkContext = (HttpContext)linkContext;
        this.linkBinding.setLinkContext(this);
    }

    @Override
    public CellContext cellContext() {
        return this.linkBinding.cellContext();
    }

    @Override
    public void setCellContext(CellContext cellContext) {
        this.linkBinding.setCellContext(cellContext);
    }

    @Override
    public <T> T unwrapLink(Class<T> linkClass) {
        if (linkClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return this.linkContext.unwrapLink(linkClass);
    }

    @Override
    public <T> T bottomLink(Class<T> linkClass) {
        Object link = this.linkContext.bottomLink(linkClass);
        if (link == null && linkClass.isAssignableFrom(this.getClass())) {
            link = this;
        }
        return link;
    }

    @Override
    public Uri requestUri() {
        return this.linkBinding.requestUri();
    }

    @Override
    public HttpRequest<?> request() {
        return this.linkBinding.request();
    }

    @Override
    public Uri meshUri() {
        return this.linkBinding.meshUri();
    }

    @Override
    public Uri hostUri() {
        return this.linkBinding.hostUri();
    }

    @Override
    public void setHostUri(Uri hostUri) {
        this.linkBinding.setHostUri(hostUri);
    }

    @Override
    public Uri nodeUri() {
        return this.linkBinding.nodeUri();
    }

    @Override
    public void setNodeUri(Uri nodeUri) {
        this.linkBinding.setNodeUri(nodeUri);
    }

    @Override
    public Uri laneUri() {
        return this.linkBinding.laneUri();
    }

    @Override
    public Value linkKey() {
        return this.linkContext.linkKey();
    }

    @Override
    public LinkAddress cellAddressDown() {
        return this.linkBinding.cellAddressDown();
    }

    @Override
    public LinkAddress cellAddressUp() {
        return this.linkContext.cellAddressUp();
    }

    @Override
    public boolean isConnectedDown() {
        return this.linkBinding.isConnectedDown();
    }

    @Override
    public boolean isRemoteDown() {
        return this.linkBinding.isRemoteDown();
    }

    @Override
    public boolean isSecureDown() {
        return this.linkBinding.isSecureDown();
    }

    @Override
    public String securityProtocolDown() {
        return this.linkBinding.securityProtocolDown();
    }

    @Override
    public String cipherSuiteDown() {
        return this.linkBinding.cipherSuiteDown();
    }

    @Override
    public InetSocketAddress localAddressDown() {
        return this.linkBinding.localAddressDown();
    }

    @Override
    public Identity localIdentityDown() {
        return this.linkBinding.localIdentityDown();
    }

    @Override
    public Principal localPrincipalDown() {
        return this.linkBinding.localPrincipalDown();
    }

    @Override
    public Collection<Certificate> localCertificatesDown() {
        return this.linkBinding.localCertificatesDown();
    }

    @Override
    public InetSocketAddress remoteAddressDown() {
        return this.linkBinding.remoteAddressDown();
    }

    @Override
    public Identity remoteIdentityDown() {
        return this.linkBinding.remoteIdentityDown();
    }

    @Override
    public Principal remotePrincipalDown() {
        return this.linkBinding.remotePrincipalDown();
    }

    @Override
    public Collection<Certificate> remoteCertificatesDown() {
        return this.linkBinding.remoteCertificatesDown();
    }

    @Override
    public boolean isConnectedUp() {
        return this.linkContext.isConnectedUp();
    }

    @Override
    public boolean isRemoteUp() {
        return this.linkContext.isRemoteUp();
    }

    @Override
    public boolean isSecureUp() {
        return this.linkContext.isSecureUp();
    }

    @Override
    public String securityProtocolUp() {
        return this.linkContext.securityProtocolUp();
    }

    @Override
    public String cipherSuiteUp() {
        return this.linkContext.cipherSuiteUp();
    }

    @Override
    public InetSocketAddress localAddressUp() {
        return this.linkContext.localAddressUp();
    }

    @Override
    public Identity localIdentityUp() {
        return this.linkContext.localIdentityUp();
    }

    @Override
    public Principal localPrincipalUp() {
        return this.linkContext.localPrincipalUp();
    }

    @Override
    public Collection<Certificate> localCertificatesUp() {
        return this.linkContext.localCertificatesUp();
    }

    @Override
    public InetSocketAddress remoteAddressUp() {
        return this.linkContext.remoteAddressUp();
    }

    @Override
    public Identity remoteIdentityUp() {
        return this.linkContext.remoteIdentityUp();
    }

    @Override
    public Principal remotePrincipalUp() {
        return this.linkContext.remotePrincipalUp();
    }

    @Override
    public Collection<Certificate> remoteCertificatesUp() {
        return this.linkContext.remoteCertificatesUp();
    }

    @Override
    public HttpRequest<?> doRequest() {
        return this.linkBinding.doRequest();
    }

    @Override
    public Decoder<Object> decodeRequest(HttpRequest<?> request) {
        return this.linkContext.decodeRequest(request);
    }

    @Override
    public void willRequest(HttpRequest<?> request) {
        this.linkContext.willRequest(request);
    }

    @Override
    public void didRequest(HttpRequest<Object> request) {
        this.linkContext.didRequest(request);
    }

    @Override
    public void doRespond(HttpRequest<Object> request) {
        this.linkContext.doRespond(request);
    }

    @Override
    public void writeResponse(HttpResponse<?> response) {
        this.linkBinding.writeResponse(response);
    }

    @Override
    public void willRespond(HttpResponse<?> response) {
        this.linkContext.willRespond(response);
    }

    @Override
    public void didRespond(HttpResponse<?> response) {
        this.linkContext.didRespond(response);
    }

    @Override
    public void openMetaUplink(LinkBinding uplink, NodeBinding metaUplink) {
        this.linkContext.openMetaUplink(uplink, metaUplink);
    }

    @Override
    public void openMetaDownlink(LinkBinding downlink, NodeBinding metaDownlink) {
        this.linkBinding.openMetaDownlink(downlink, metaDownlink);
    }

    @Override
    public void openDown() {
        this.linkBinding.openDown();
    }

    @Override
    public void closeDown() {
        this.linkBinding.closeDown();
    }

    @Override
    public void closeUp() {
        this.linkContext.closeUp();
    }

    @Override
    public void reopen() {
        this.linkBinding.reopen();
    }

    @Override
    public void didOpenDown() {
        this.linkContext.didOpenDown();
    }

    @Override
    public void didConnect() {
        this.linkBinding.didConnect();
    }

    @Override
    public void didDisconnect() {
        this.linkBinding.didDisconnect();
    }

    @Override
    public void didCloseDown() {
        this.linkContext.didCloseDown();
    }

    @Override
    public void didCloseUp() {
        this.linkBinding.didCloseUp();
    }

    @Override
    public void didFailDown(Throwable error) {
        this.linkContext.didFailDown(error);
    }

    @Override
    public void didFailUp(Throwable error) {
        this.linkBinding.didFailUp(error);
    }

    @Override
    public void didFail(Throwable error) {
        this.linkBinding.didFail(error);
    }

    @Override
    public void traceDown(Object message) {
        this.linkBinding.traceDown(message);
    }

    @Override
    public void debugDown(Object message) {
        this.linkBinding.debugDown(message);
    }

    @Override
    public void infoDown(Object message) {
        this.linkBinding.infoDown(message);
    }

    @Override
    public void warnDown(Object message) {
        this.linkBinding.warnDown(message);
    }

    @Override
    public void errorDown(Object message) {
        this.linkBinding.errorDown(message);
    }

    @Override
    public void failDown(Object message) {
        this.linkBinding.failDown(message);
    }

    @Override
    public void traceUp(Object message) {
        this.linkContext.traceUp(message);
    }

    @Override
    public void debugUp(Object message) {
        this.linkContext.debugUp(message);
    }

    @Override
    public void infoUp(Object message) {
        this.linkContext.infoUp(message);
    }

    @Override
    public void warnUp(Object message) {
        this.linkContext.warnUp(message);
    }

    @Override
    public void errorUp(Object message) {
        this.linkContext.errorUp(message);
    }

    @Override
    public void failUp(Object message) {
        this.linkContext.failUp(message);
    }
}

